/*!
 *******************************************************************************
 * \file             spi_tclExtCompManager.cpp
 * \brief            External Factory class responsible for creation
 *                   of Adapter Interfaces.
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Class provides interfaces to get the instances of Adapters
 in the form of interfaces defined for each Adapter.
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date       |  Author                      | Modifications
 09.01.2017 |  Dhiraj Asopa                | Initial Version

 \endverbatim
 ******************************************************************************/

/******************************************************************************
 | includes:
 |----------------------------------------------------------------------------*/

#include "spi_tclExtCompManager.h"
#include "spi_tclExtCmdSensorData.h"
#include "spi_tclExtCmdPositionData.h"
#include "spi_tclExtCmdWiFi.h"
#include "spi_tclExtCmdAppleDiscoverer.h"
#include "spi_tclExtCmdRoleSwitch.h"
#include "spi_tclExtCmdMetaData.h"
#include "spi_tclExtCmdNavData.h"
#include "spi_tclExtCmdNativeTransport.h"
#include "spi_tclExtCmdBluetooth.h"
#include "spi_tclExtCmdTelephone.h"
#include "spi_tclExtCmdOOBT.h"
#include "spi_tclExtCmdMediaDevInfo.h"
#include "spi_tclExtCmdClock.h"
#include "spi_tclExtCmdInput.h"
//! Includes for Trace files
#include "Trace.h"
#ifdef TARGET_BUILD
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_EXTINTERFACE
#include "trcGenProj/Header/spi_tclExtCompManager.cpp.trc.h"
#endif
#endif

//lint -save -e1055 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e1013 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e1401 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e601 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e19 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e10 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e55 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e58 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e48 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e808 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e63 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e40 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e64 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e746 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e515 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e516 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e601 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported

/***************************************************************************
 *********************************PUBLIC*************************************
 ***************************************************************************/

/***************************************************************************
 ** FUNCTION:  spi_tclExtCompManager::~spi_tclExtCompManager
 ***************************************************************************/
spi_tclExtCompManager::~spi_tclExtCompManager()
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCompManager::~spi_tclExtCompManager()destructor entered\n"));
   m_poCmdSensorIntf = NULL;
   m_poCmdPosIntf = NULL;
   m_poCmdWiFiIntf = NULL;
   m_poCmdAppleDiscovererIntf = NULL;
   m_poCmdRoleSwitchIntf = NULL;
   m_poCmdMetaDataIntf = NULL;
   m_poCmdNavDataIntf = NULL;
   m_poCmdNativeTransportIntf = NULL;
   m_poCmdBluetoothIntf = NULL;
   m_poCmdTelephoneIntf = NULL;
   m_poCmdOOBTIntf = NULL;
   m_poCmdMediaDevInfoIntf = nullptr;
   m_poCmdClockIntf = NULL;
   m_poCmdInputIntf = NULL;
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCompManager::~spi_tclExtCompManager()destructor left\n"));
}

/***************************************************************************
 ** FUNCTION:  t_Bool spi_tclExtCompManager::bInitialize()
 ***************************************************************************/
t_Bool spi_tclExtCompManager::bInitialize()
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCompManager::bInitialize() entered\n"));
   m_poCmdSensorIntf = new spi_tclExtCmdSensorData();
   SPI_NORMAL_ASSERT(NULL == m_poCmdSensorIntf);

   m_poCmdPosIntf = new spi_tclExtCmdPositionData();
   SPI_NORMAL_ASSERT(NULL == m_poCmdPosIntf);

   m_poCmdWiFiIntf = new spi_tclExtCmdWiFi();
   SPI_NORMAL_ASSERT(NULL == m_poCmdWiFiIntf);

   m_poCmdAppleDiscovererIntf = new spi_tclExtCmdAppleDiscoverer();
   SPI_NORMAL_ASSERT(NULL == m_poCmdAppleDiscovererIntf);

   m_poCmdRoleSwitchIntf = new spi_tclExtCmdRoleSwitch();
   SPI_NORMAL_ASSERT(NULL == m_poCmdRoleSwitchIntf);

   m_poCmdMetaDataIntf = new spi_tclExtCmdMetaData();
   SPI_NORMAL_ASSERT(NULL == m_poCmdMetaDataIntf);

   m_poCmdNavDataIntf = new spi_tclExtCmdNavData();
   SPI_NORMAL_ASSERT(NULL == m_poCmdNavDataIntf);

   m_poCmdNativeTransportIntf = new spi_tclExtCmdNativeTransport();
   SPI_NORMAL_ASSERT(NULL == m_poCmdNativeTransportIntf);

   m_poCmdBluetoothIntf = new spi_tclExtCmdBluetooth();
   SPI_NORMAL_ASSERT(NULL == m_poCmdBluetoothIntf);

   m_poCmdTelephoneIntf = new spi_tclExtCmdTelephone();
   SPI_NORMAL_ASSERT(NULL == m_poCmdTelephoneIntf);

   m_poCmdOOBTIntf = new spi_tclExtCmdOOBT();
   SPI_NORMAL_ASSERT(NULL == m_poCmdOOBTIntf);

   m_poCmdMediaDevInfoIntf = new (std::nothrow) spi_tclExtCmdMediaDevInfo();
   SPI_NORMAL_ASSERT(NULL == m_poCmdMediaDevInfoIntf);

   m_poCmdClockIntf = new spi_tclExtCmdClock();
   SPI_NORMAL_ASSERT(NULL == m_poCmdClockIntf);

   m_poCmdInputIntf = new (std::nothrow) spi_tclExtCmdInput();
   SPI_NORMAL_ASSERT(NULL == m_poCmdInputIntf);

   t_Bool bInit = ((NULL != m_poCmdSensorIntf) && (NULL != m_poCmdPosIntf) && (NULL != m_poCmdWiFiIntf)
            && (NULL != m_poCmdAppleDiscovererIntf) && (NULL != m_poCmdRoleSwitchIntf) && (NULL != m_poCmdMetaDataIntf)
            && (NULL != m_poCmdNavDataIntf) && (NULL != m_poCmdNativeTransportIntf) && (NULL != m_poCmdBluetoothIntf)
            && (NULL != m_poCmdTelephoneIntf) && (NULL != m_poCmdOOBTIntf) && (nullptr != m_poCmdMediaDevInfoIntf)
            && (NULL != m_poCmdInputIntf)
            && (NULL != m_poCmdClockIntf) && (m_poCmdSensorIntf->bInitialize()) && (m_poCmdPosIntf->bInitialize())
            && (m_poCmdWiFiIntf->bInitialize()) && (m_poCmdAppleDiscovererIntf->bInitialize())
            && (m_poCmdRoleSwitchIntf->bInitialize()) && (m_poCmdNavDataIntf->bInitialize())
            && (m_poCmdNativeTransportIntf->bInitialize()) && (m_poCmdMetaDataIntf->bInitialize())
            && (m_poCmdBluetoothIntf->bInitialize()) && (m_poCmdTelephoneIntf->bInitialize())
            && (m_poCmdOOBTIntf->bInitialize()) && (m_poCmdMediaDevInfoIntf->bInitialize())
            && (m_poCmdClockIntf->bInitialize()) && (m_poCmdInputIntf->bInitialize()));

   ETG_TRACE_USR1(("[FUNC]spi_tclExtCompManager::bInitialize() left with bInit=%d\n", ETG_ENUM(BOOL, bInit)));
   return bInit;
}

/***************************************************************************
 ** FUNCTION:  t_Bool spi_tclExtCompManager::bUnInitialize()
 ***************************************************************************/
t_Bool spi_tclExtCompManager::bUnInitialize()
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCompManager::bUnInitialize() entered\n"));
   t_Bool bUnInit = true; // return is not handled, hence it is always true.
   //! Release resources
   m_poCmdSensorIntf->bUnInitialize();
   m_poCmdPosIntf->bUnInitialize();
   m_poCmdWiFiIntf->bUnInitialize();
   m_poCmdAppleDiscovererIntf->bUnInitialize();
   m_poCmdRoleSwitchIntf->bUnInitialize();
   m_poCmdMetaDataIntf->bUnInitialize();
   m_poCmdNavDataIntf->bUnInitialize();
   m_poCmdNativeTransportIntf->bUnInitialize();
   m_poCmdBluetoothIntf->bUnInitialize();
   m_poCmdTelephoneIntf->bUnInitialize();
   m_poCmdOOBTIntf->bUnInitialize();
   m_poCmdClockIntf->bUnInitialize();

   RELEASE_MEM(m_poCmdSensorIntf);
   RELEASE_MEM(m_poCmdPosIntf);
   RELEASE_MEM(m_poCmdWiFiIntf);
   RELEASE_MEM(m_poCmdAppleDiscovererIntf);
   RELEASE_MEM(m_poCmdMetaDataIntf);
   RELEASE_MEM(m_poCmdRoleSwitchIntf);
   RELEASE_MEM(m_poCmdNavDataIntf);
   RELEASE_MEM(m_poCmdNativeTransportIntf);
   RELEASE_MEM(m_poCmdBluetoothIntf);
   RELEASE_MEM(m_poCmdTelephoneIntf);
   RELEASE_MEM(m_poCmdOOBTIntf);
   RELEASE_MEM(m_poCmdClockIntf);

   if (nullptr != m_poCmdMediaDevInfoIntf)
   {
      m_poCmdMediaDevInfoIntf->bUnInitialize();
      delete m_poCmdMediaDevInfoIntf;
      m_poCmdMediaDevInfoIntf = nullptr;
   }

   ETG_TRACE_USR1(("[FUNC]spi_tclExtCompManager::bUnInitialize() left\n"));
   return bUnInit;
}

/****************************************************************************************************************
 ** FUNCTION:  spi_tclExtCmdSensorDataIntf* spi_tclExtCompManager::poGetClientHandlersFactoryInstance()
 ****************************************************************************************************************/
spi_tclExtCmdSensorDataIntf* spi_tclExtCompManager::poGetCmdSensorDataIntfInst()
{
   return m_poCmdSensorIntf;
}

/****************************************************************************************************************
 ** FUNCTION:  spi_tclExtCmdPositionDataIntf* spi_tclExtCompManager::poGetCmdPositionDataIntfInst()
 ****************************************************************************************************************/
spi_tclExtCmdPositionDataIntf* spi_tclExtCompManager::poGetCmdPositionDataIntfInst()
{
   return m_poCmdPosIntf;
}

/****************************************************************************************************************
 ** FUNCTION:  spi_tclExtCmdWiFiIntf* spi_tclExtCompManager::poGetCmdWiFiIntfInst()
 ****************************************************************************************************************/
spi_tclExtCmdWiFiIntf* spi_tclExtCompManager::poGetCmdWiFiIntfInst()
{
   return m_poCmdWiFiIntf;
}

/****************************************************************************************************************
 ** FUNCTION:  spi_tclExtCmdAppleDiscovererIntf* spi_tclExtCompManager::poGetCmdAppleDiscovererIntfInst()
 ****************************************************************************************************************/
spi_tclExtCmdAppleDiscovererIntf* spi_tclExtCompManager::poGetCmdAppleDiscovererIntfInst()
{
   return m_poCmdAppleDiscovererIntf;
}

/****************************************************************************************************************
 ** FUNCTION:  spi_tclExtCmdRoleSwitchIntf* spi_tclExtCompManager::poGetCmdRoleSwitchIntfInst()
 ********************************************************************************************************/

spi_tclExtCmdRoleSwitchIntf* spi_tclExtCompManager::poGetCmdRoleSwitchIntfInst()
{
   return m_poCmdRoleSwitchIntf;
}

/****************************************************************************************************************
 ** FUNCTION:  spi_tclExtCmdMetaDataIntf* spi_tclExtCompManager::poGetCmdMetaDataIntfInst()
 ****************************************************************************************************************/
spi_tclExtCmdMetaDataIntf* spi_tclExtCompManager::poGetCmdMetaDataIntfInst()
{
   return m_poCmdMetaDataIntf;
}

/****************************************************************************************************************
 ** FUNCTION:  spi_tclExtCmdNavDataIntf* spi_tclExtCompManager::poGetCmdNavDataIntfInst()
 ****************************************************************************************************************/
spi_tclExtCmdNavDataIntf* spi_tclExtCompManager::poGetCmdNavDataIntfInst()
{
   return m_poCmdNavDataIntf;
}

/****************************************************************************************************************
 ** FUNCTION:  spi_tclExtCmdNativeTransportIntf* spi_tclExtCompManager::poGetCmdNativeTransportIntfInst()
 ****************************************************************************************************************/
spi_tclExtCmdNativeTransportIntf* spi_tclExtCompManager::poGetCmdNativeTransportIntfInst()
{
   return m_poCmdNativeTransportIntf;
}

/****************************************************************************************************************
 ** FUNCTION:  spi_tclExtCmdBluetoothIntf* spi_tclExtCompManager::poGetCmdBluetoothIntfInst()
 ****************************************************************************************************************/
spi_tclExtCmdBluetoothIntf* spi_tclExtCompManager::poGetCmdBluetoothIntfInst()
{
   return m_poCmdBluetoothIntf;
}

/****************************************************************************************************************
 ** FUNCTION:  spi_tclExtCmdTelephoneIntf* spi_tclExtCompManager::poGetCmdTelephoneIntfInst()
 ****************************************************************************************************************/
spi_tclExtCmdTelephoneIntf* spi_tclExtCompManager::poGetCmdTelephoneIntfInst()
{
   return m_poCmdTelephoneIntf;
}

/****************************************************************************************************************
 ** FUNCTION:  spi_tclExtCmdOOBTIntf* spi_tclExtCompManager::poGetCmdOOBTIntfInst()
 ****************************************************************************************************************/
spi_tclExtCmdOOBTIntf* spi_tclExtCompManager::poGetCmdOOBTIntfInst()
{
   return m_poCmdOOBTIntf;
}

/*************************************************************************************************************
 ** FUNCTION:  spi_tclExtCmdMediaDevInfoIntf* spi_tclExtCompManager::poGetCmdMediaDevInfo
 *************************************************************************************************************/
spi_tclExtCmdMediaDevInfoIntf* spi_tclExtCompManager::poGetCmdMediaDevInfo()
{
   return m_poCmdMediaDevInfoIntf;
}

/*************************************************************************************************************
 ** FUNCTION:  spi_tclExtCmdClockIntf* spi_tclExtCompManager::poGetCmdClockIntfInst
 *************************************************************************************************************/
spi_tclExtCmdClockIntf* spi_tclExtCompManager::poGetCmdClockIntfInst()
{
   return m_poCmdClockIntf;
}

/*************************************************************************************************************
 ** FUNCTION:  spi_tclExtCmdInputIntf* spi_tclExtCompManager::poGetCmdInputInst
 *************************************************************************************************************/
spi_tclExtCmdInputIntf* spi_tclExtCompManager::poGetCmdInputInst()
{
   return m_poCmdInputIntf;
}

/***************************************************************************
 *********************************PRIVATE***********************************
 ***************************************************************************/
spi_tclExtCompManager::spi_tclExtCompManager() :
                  m_poCmdSensorIntf(NULL),
                  m_poCmdPosIntf(NULL),
                  m_poCmdWiFiIntf(NULL),
                  m_poCmdAppleDiscovererIntf(NULL),
                  m_poCmdRoleSwitchIntf(NULL),
                  m_poCmdMetaDataIntf(NULL),
                  m_poCmdNavDataIntf(NULL),
                  m_poCmdNativeTransportIntf(NULL),
                  m_poCmdBluetoothIntf(NULL),
                  m_poCmdTelephoneIntf(NULL),
                  m_poCmdOOBTIntf(NULL),
                  m_poCmdMediaDevInfoIntf(nullptr),
                  m_poCmdClockIntf(NULL),
                  m_poCmdInputIntf(NULL)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCompManager::spi_tclExtCompManager() constructor entered\n"));
}

//lint -restore
