/***********************************************************************/
/*!
* \file  spi_tclExtCompMsgQThreadable.h
* \brief implements threading based on MsgQthreader for External Interface
*************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    implements threading based on MsgQthreader for External Interface
AUTHOR:         Unmukt Jain
COPYRIGHT:      &copy; RBEI

HISTORY:
Date        | Author                			| Modification
06.01.2017  |  Unmukt Jain (RBEI/ECP2)          | Initial Version

\endverbatim
*************************************************************************/

#ifndef SPI_TCLEXTCOMPMSGQTHREADER_H_
#define SPI_TCLEXTCOMPMSGQTHREADER_H_


/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/
#include "MsgQThreadable.h"
#include "SPITypes.h"

#include "spi_tclExtPositionDataDispatcher.h"
#include "spi_tclExtSensorDataDispatcher.h"
#include "spi_tclExtWiFiDispatcher.h"
#include "spi_tclExtAppleDiscovererDispatcher.h"
#include "spi_tclExtRoleSwitchDispatcher.h"
#include "spi_tclExtMetaDataDispatcher.h"
#include "spi_tclExtNavDataDispatcher.h"
#include "spi_tclExtNativeTransportDispatcher.h"
#include "spi_tclExtBluetoothDispatcher.h"
#include "spi_tclExtTelephoneDispatcher.h"
#include "spi_tclExtOOBTDispatcher.h"
#include "spi_tclExtMediaDevInfoDispatcher.h"
#include "spi_tclExtClockDispatcher.h"

using namespace shl::thread;

/****************************************************************************/
/*!
* \class spi_tclExtCompMsgQThreadable
* \brief implements threading based on MsgQthreader for External Interface
*
* Responsible for calling the respective dispatchers and to allocate memory
* when a message arrives on Q
*
****************************************************************************/

class spi_tclExtCompMsgQThreadable : public MsgQThreadable
{
   public:

      /***************************************************************************
      ** FUNCTION:  spi_tclExtCompMsgQThreadable::spi_tclExtCompMsgQThreadable()
      ***************************************************************************/
      /*!
      * \fn      spi_tclExtCompMsgQThreadable()
      * \brief   Default Constructor
      * \sa      ~spi_tclExtCompMsgQThreadable()
      **************************************************************************/
	spi_tclExtCompMsgQThreadable();

      /***************************************************************************
      ** FUNCTION:  spi_tclExtCompMsgQThreadable::~spi_tclExtCompMsgQThreadable()
      ***************************************************************************/
      /*!
      * \fn      ~spi_tclExtCompMsgQThreadable()
      * \brief   Destructor
      * \sa      spi_tclExtCompMsgQThreadable()
      **************************************************************************/
      ~spi_tclExtCompMsgQThreadable();

   protected:
      /***************************************************************************
      ** FUNCTION:  spi_tclExtCompMsgQThreadable::vExecute
      ***************************************************************************/
      /*!
      * \fn      t_Void vExecute(tShlMessage *poMessage)
      * \brief   Responsible for posting the message to respective dispatchers
      * \param   poMessage : message received from MsgQ for dispatching
      **************************************************************************/
      virtual t_Void vExecute(tShlMessage *poMessage);

      /***************************************************************************
      ** FUNCTION:  spi_tclExtCompMsgQThreadable::tShlMessage* poGetMsgBuffer(size_t )
      ***************************************************************************/
      /*!
      * \fn      tShlMessage* poGetMsgBuffer(size_t )
      * \brief  This function will be called for requesting the storage allocation for received
      *           message
      * \param siBuffer: size of the buffer to be allocated for the received message
      **************************************************************************/
      virtual tShlMessage* poGetMsgBuffer(size_t siBuffer);

   private:

      /***************************************************************************
       ** FUNCTION:  spi_tclExtCompMsgQThreadable(const spi_tclExtCompMsgQThreadable...
       ***************************************************************************/
      /*!
       * \fn      spi_tclExtCompMsgQThreadable(
       *                             const spi_tclExtCompMsgQThreadable& corfoSrc)
       * \brief   Copy constructor - Do not allow the creation of copy constructor
       * \param   corfoSrc : [IN] reference to source data interface object
       * \retval
       * \sa      spi_tclExtCompMsgQThreadable()
       ***************************************************************************/
       spi_tclExtCompMsgQThreadable(const spi_tclExtCompMsgQThreadable& corfoSrc);


      /***************************************************************************
       ** FUNCTION:  spi_tclExtCompMsgQThreadable& operator=( const spi_tclAAP...
       ***************************************************************************/
      /*!
       * \fn      spi_tclExtCompMsgQThreadable& operator=(
       *                          const spi_tclExtCompMsgQThreadable& corfoSrc))
       * \brief   Assignment operator
       * \param   corfoSrc : [IN] reference to source data interface object
       * \retval
       * \sa      spi_tclExtCompMsgQThreadable(const spi_tclExtCompMsgQThreadable& otrSrc)
       ***************************************************************************/
       spi_tclExtCompMsgQThreadable& operator=(const spi_tclExtCompMsgQThreadable& corfoSrc);     
   
      spi_tclExtPositionDataDispatcher*     m_poExtPositionDispatcher;

      spi_tclExtSensorDataDispatcher*       m_poExtSensorDispatcher;

      spi_tclExtWiFiDispatcher*         m_poExtWiFiDispatcher;

      spi_tclExtAppleDiscovererDispatcher* m_poExtAppleDiscovererDispatcher;

      spi_tclExtRoleSwitchDispatcher *m_poExtRoleSwitchDispatcher;

      spi_tclExtMetaDataDispatcher *m_poExtMetaDataDispatcher;

      spi_tclExtNativeTransportDispatcher *m_poExtNativeTransportDispatcher;

      spi_tclExtNavDataDispatcher *m_poExtNavDataDispatcher;

      spi_tclExtBluetoothDispatcher *m_poExtBluetoothDispatcher;
	  
	  spi_tclExtTelephoneDispatcher *m_poExtTelephoneDispatcher;

      spi_tclExtOOBTDispatcher *m_poExtOOBTDispatcher;

      spi_tclExtMediaDevInfoDispatcher* m_poExtMediaDevInfoDispatcher;

      spi_tclExtClockDispatcher *m_poExtClockDispatcher;

};


#endif /* SPI_TCLEXTCOMPMSGQTHREADER_H_ */
