/*!
 *******************************************************************************
 * \file             spi_tclExtCompManager.h
 * \brief            External Factory class responsible for creation
 *                   of Adapter Interfaces
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Class provides interfaces to get the instances of Adapters
                 in the form of interfaces defined for each Adapter.
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date       |  Author                      | Modifications
 09.01.2017 |  Dhiraj Asopa                | Initial Version
 \endverbatim
 ******************************************************************************/
#ifndef _SPI_TCLEXTCOMPMANAGER_H_
#define _SPI_TCLEXTCOMPMANAGER_H_

#include "GenericSingleton.h"
#include "BaseTypes.h"

class spi_tclExtCmdSensorDataIntf;
class spi_tclExtCmdPositionDataIntf;
class spi_tclExtCmdWiFiIntf;
class spi_tclExtCmdAppleDiscovererIntf;
class spi_tclExtCmdRoleSwitchIntf;
class spi_tclExtCmdMetaDataIntf;
class spi_tclExtCmdNavDataIntf;
class spi_tclExtCmdNativeTransportIntf;
class spi_tclExtCmdBluetoothIntf;
class spi_tclExtCmdTelephoneIntf;
class spi_tclExtCmdOOBTIntf;
class spi_tclExtCmdMediaDevInfoIntf;
class spi_tclExtCmdClockIntf;
class spi_tclExtCmdInputIntf;


class spi_tclExtCompManager: public GenericSingleton<spi_tclExtCompManager>
{
   public:
      /***************************************************************************
       *********************************PUBLIC*************************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclExtCompManager::~spi_tclExtCompManager
       ***************************************************************************/
      /*!
       * \fn     ~spi_tclExtCompManager()
       * \brief  Destructor
       **************************************************************************/
      ~spi_tclExtCompManager();

      /***************************************************************************
       ** FUNCTION:  t_Bool spi_tclExtCompManager::bInitialize()
       ***************************************************************************/
      /*!
       * \fn      bInitialize()
       * \brief   Method to Initialize
       * \sa      bUnInitialize()
       **************************************************************************/
      virtual t_Bool bInitialize();

      /***************************************************************************
       ** FUNCTION:  t_Bool spi_tclExtCompManager::bUnInitialize()
       ***************************************************************************/
      /*!
       * \fn      bUnInitialize()
       * \brief   Method to UnInitialize
       * \sa      bInitialize()
       **************************************************************************/
      virtual t_Bool bUnInitialize();
      /*************************************************************************************************************
       ** FUNCTION:  spi_tclExtCmdSensorDataIntf*spi_tclExtCompManager::poGetCmdSensorDataIntfInst
       *************************************************************************************************************/
      /*!
       * \fn     sspi_tclExtCmdSensorDataIntf* poGetCmdSensorDataIntfInst()
       * \brief  returns Sensor Interface instance
       **************************************************************************/
      spi_tclExtCmdSensorDataIntf* poGetCmdSensorDataIntfInst();

      /*************************************************************************************************************
       ** FUNCTION:  spi_tclExtCmdPositionDataIntf*spi_tclExtCompManager::poGetCmdPositionDataIntfInst
       *************************************************************************************************************/
      /*!
       * \fn     spi_tclExtCmdPositionDataIntf* spi_tclExtCmdPositionDataIntf()
       * \brief  returns Position Data Interface instance
       **************************************************************************/
      spi_tclExtCmdPositionDataIntf* poGetCmdPositionDataIntfInst();

      /*************************************************************************************************************
       ** FUNCTION:  spi_tclExtCmdWiFiIntf*spi_tclExtCompManager::poGetCmdWiFiIntfInst
       *************************************************************************************************************/
      /*!
       * \fn     spi_tclExtCmdWiFiIntf* poGetCmdWiFiIntfInst()
       * \brief  returns WiFi Interface instance
       **************************************************************************/
      spi_tclExtCmdWiFiIntf* poGetCmdWiFiIntfInst();

      /*************************************************************************************************************
       ** FUNCTION:  spi_tclExtCmdAppleDiscovererIntf* spi_tclExtCompManager::poGetCmdAppleDiscovererIntfInst
       *************************************************************************************************************/
      /*!
       * \fn     spi_tclExtCmdAppleDiscovererIntf* poGetCmdAppleDiscovererIntfInst()
       * \brief  returns Apple Discoverer Interface instance
       **************************************************************************/
      spi_tclExtCmdAppleDiscovererIntf* poGetCmdAppleDiscovererIntfInst();

      /*************************************************************************************************************
       ** FUNCTION:  spi_tclExtCmdRoleSwitchIntf* spi_tclExtCompManager::poGetCmdRoleSwitchIntfInst
       *************************************************************************************************************/
      /*!
       * \fn     spi_tclExtCmdRoleSwitchIntf* poGetCmdRoleSwitchIntfInst()
       * \brief  returns Role Switch Interface instance
       **************************************************************************/
      spi_tclExtCmdRoleSwitchIntf* poGetCmdRoleSwitchIntfInst();

      /*************************************************************************************************************
       ** FUNCTION:  spi_tclExtCmdMetaDataIntf* spi_tclExtCompManager::poGetCmdMetaDataIntfInst
       *************************************************************************************************************/
      /*!
       * \fn     spi_tclExtCmdMetaDataIntf* poGetCmdMetaDataIntfInst()
       * \brief  returns MetaData Interface instance
       **************************************************************************/
      spi_tclExtCmdMetaDataIntf* poGetCmdMetaDataIntfInst();

      /*************************************************************************************************************
       ** FUNCTION:  spi_tclExtCmdNavDataIntf* spi_tclExtCompManager::poGetCmdNavDataIntfInst
       *************************************************************************************************************/
      /*!
       * \fn     spi_tclExtCmdNavDataIntf* poGetCmdNavDataIntfInst()
       * \brief  returns Nav Data Interface instance
       **************************************************************************/
      spi_tclExtCmdNavDataIntf* poGetCmdNavDataIntfInst();

      /*************************************************************************************************************
       ** FUNCTION:  spi_tclExtCmdNativeTransportIntf* spi_tclExtCompManager::poGetCmdNativeTransportIntfInst
       *************************************************************************************************************/
      /*!
       * \fn     spi_tclExtCmdNativeTransportIntf* poGetCmdNativeTransportIntfInst()
       * \brief  returns Nav Data Interface instance
       **************************************************************************/
      spi_tclExtCmdNativeTransportIntf* poGetCmdNativeTransportIntfInst();

      /*************************************************************************************************************
       ** FUNCTION:  spi_tclExtCmdBluetoothIntf* spi_tclExtCompManager::poGetCmdBluetoothIntfInst
       *************************************************************************************************************/
      /*!
       * \fn     spi_tclExtCmdBluetoothIntf* poGetCmdBluetoothIntfInst()
       * \brief  returns Bluetooth Interface instance
       **************************************************************************/
      spi_tclExtCmdBluetoothIntf* poGetCmdBluetoothIntfInst();
	  
	  /*************************************************************************************************************
       ** FUNCTION:  spi_tclExtCmdTelephoneIntf* spi_tclExtCompManager::poGetCmdTelephoneIntfInst
       *************************************************************************************************************/
      /*!
       * \fn     spi_tclExtCmdTelephoneIntf* poGetCmdTelephoneIntfInst()
       * \brief  returns Telephone Interface instance
       **************************************************************************/
      spi_tclExtCmdTelephoneIntf* poGetCmdTelephoneIntfInst();

      /*************************************************************************************************************
       ** FUNCTION:  spi_tclExtCmdBluetoothIntf* spi_tclExtCompManager::poGetCmdOOBTIntfInst
       *************************************************************************************************************/
      /*!
       * \fn     spi_tclExtCmdBluetoothIntf* poGetCmdOOBTIntfInst()
       * \brief  returns OOBT Interface instance
       **************************************************************************/
      spi_tclExtCmdOOBTIntf* poGetCmdOOBTIntfInst();

	  /*************************************************************************************************************
       ** FUNCTION:  spi_tclExtCmdMediaDevInfoIntf* spi_tclExtCompManager::poGetCmdMediaDevInfo
       *************************************************************************************************************/
      /*!
       * \fn     spi_tclExtCmdMediaDevInfoIntf* poGetCmdMediaDevInfo()
       * \brief  returns Media Device Info instance
       **************************************************************************/
      spi_tclExtCmdMediaDevInfoIntf* poGetCmdMediaDevInfo();

      /*************************************************************************************************************
        ** FUNCTION:  spi_tclExtCmdClockIntf* spi_tclExtCompManager::poGetCmdClockIntfInst
        *************************************************************************************************************/
       /*!
        * \fn     spi_tclExtCmdClockIntf* poGetCmdClockIntfInst()
        * \brief  returns Clock Interface instance
        **************************************************************************/
      spi_tclExtCmdClockIntf* poGetCmdClockIntfInst();

      /*************************************************************************************************************
        ** FUNCTION:  spi_tclExtCmdClockIntf* spi_tclExtCompManager::poGetCmdInputInst
        *************************************************************************************************************/
       /*!
        * \fn     spi_tclExtCmdClockIntf* poGetCmdInputInst()
        * \brief  returns Input Interface instance
        **************************************************************************/
      spi_tclExtCmdInputIntf* poGetCmdInputInst();


   private:
      /***************************************************************************
       *********************************PRIVATE***********************************
       ***************************************************************************/
      friend class GenericSingleton<spi_tclExtCompManager>;

      /***************************************************************************
       ** FUNCTION:  spi_tclExtCompManager::spi_tclExtCompManager()
       ***************************************************************************/
      /*!
       * \fn     spi_tclExtCompManager()
       * \brief  Default Constructor
       **************************************************************************/
      spi_tclExtCompManager();

      //!Pointer to spi_tclExtCmdSensorDataIntf
      spi_tclExtCmdSensorDataIntf* m_poCmdSensorIntf;

      //!Pointer to spi_tclExtCmdPositionDataIntf
      spi_tclExtCmdPositionDataIntf* m_poCmdPosIntf;

      //!pointer to spi_tclExtCmdWiFiIntf
      spi_tclExtCmdWiFiIntf *m_poCmdWiFiIntf;

      //!Pointer to spi_tclExtCmdAppleDiscovererIntf
      spi_tclExtCmdAppleDiscovererIntf *m_poCmdAppleDiscovererIntf;

      //!Pointer to spi_tclExtCmdRoleSwitchIntf
      spi_tclExtCmdRoleSwitchIntf *m_poCmdRoleSwitchIntf;

      //!Pointer to spi_tclExtCmdMetaDataIntf
      spi_tclExtCmdMetaDataIntf *m_poCmdMetaDataIntf;

      //!Pointer to spi_tclExtCmdNavDataIntf
      spi_tclExtCmdNavDataIntf *m_poCmdNavDataIntf;

      //!Pointer to spi_tclExtCmdNativeTransportIntf
      spi_tclExtCmdNativeTransportIntf *m_poCmdNativeTransportIntf;

      //!Pointer to spi_tclExtCmdBluetoothIntf
      spi_tclExtCmdBluetoothIntf *m_poCmdBluetoothIntf;
	  
	  //!Pointer to spi_tclExtCmdTelephoneIntf
      spi_tclExtCmdTelephoneIntf *m_poCmdTelephoneIntf;

      //!Pointer to spi_tclExtCmdOOBTIntf
      spi_tclExtCmdOOBTIntf *m_poCmdOOBTIntf;

      //!Pointer to spi_tclExtCmdMediaDevInfoIntf
      spi_tclExtCmdMediaDevInfoIntf* m_poCmdMediaDevInfoIntf;

      //!Pointer to spi_tclExtCmdClockIntf
      spi_tclExtCmdClockIntf* m_poCmdClockIntf;

      //!Pointer to spi_tclExtCmdInputIntf
      spi_tclExtCmdInputIntf* m_poCmdInputIntf;

};
#endif /* _SPI_TCLEXTCOMPMANAGER_H_ */
