/*!
 *******************************************************************************
 * \file             spi_tclExtClientFactory.h
 * \brief            Factory class responsible for creation of Client Handlers
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Factory class responsible for creation of Client Handlers
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date       |  Author                      | Modifications
 09.01.2017 |  Dhiraj Asopa                | Initial Version
 \endverbatim
 ******************************************************************************/
#ifndef _SPI_TCLEXTCLIENTFACTORY_H_
#define _SPI_TCLEXTCLIENTFACTORY_H_
#include "GenericSingleton.h"
#include "BaseTypes.h"
#include "SPITypes.h"

class spi_tclSensorPVDataClientHandler;
class spi_tclSensorDataClientHandler;
class spi_tclWBLClientHandler;
class spi_tclMPlayClientHandler;
class spi_tclBluetoothClient;
class spi_tclTelephoneClient;
class spi_tclClockClientHandler;
class ahl_tclBaseOneThreadApp;

class spi_tclExtClientFactory: public GenericSingleton<spi_tclExtClientFactory>
{
   public:
      /***************************************************************************
       *********************************PUBLIC*************************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclExtClientFactory::~spi_tclExtClientFactory
       ***************************************************************************/
      /*!
       * \fn     ~spi_tclExtClientFactory()
       * \brief  Destructor
       **************************************************************************/
      ~spi_tclExtClientFactory();

      /***************************************************************************
       ** FUNCTION:  t_Bool spi_tclExtClientFactory::bInitialize()
       ***************************************************************************/
      /*!
       * \fn      bInitialize()
       * \brief   Method to Initialize
       * \sa      bUnInitialize()
       **************************************************************************/
      virtual t_Bool bInitialize();

      /***************************************************************************
       ** FUNCTION:  t_Bool spi_tclExtClientFactory::bUnInitialize()
       ***************************************************************************/
      /*!
       * \fn      bUnInitialize()
       * \brief   Method to UnInitialize
       * \sa      bInitialize()
       **************************************************************************/
      virtual t_Bool bUnInitialize();
      /*************************************************************************************************************
       ** FUNCTION:  spi_tclSensorDataClientHandler*spi_tclExtClientFactory::poGetSensorDataClientHandlerInstance
       *************************************************************************************************************/
      /*!
       * \fn     spi_tclSensorDataClientHandler* poGetSensorDataClientHandlerInstance()()
       * \brief  returns Sensor Data Client Handler instance
       **************************************************************************/
      spi_tclSensorDataClientHandler* poGetSensorDataClientHandlerInstance();
      /*************************************************************************************************************
       ** FUNCTION:  spi_tclSensorPVDataClientHandler*spi_tclExtClientFactory::poGetPosDataClientHandlerInstance
       *************************************************************************************************************/
      /*!
       * \fn      spi_tclSensorPVDataClientHandler* poGetPosDataClientHandlerInstance()()
       * \brief  returns pos Data Client Handler instance
       **************************************************************************/
      spi_tclSensorPVDataClientHandler* poGetPosDataClientHandlerInstance();

      /*************************************************************************************************************
       ** FUNCTION:  spi_tclWBLClientHandler* spi_tclExtClientFactory::poGetWBLClientHandlerInstance
       *************************************************************************************************************/
      /*!
       * \fn     spi_tclWBLClientHandler* poGetWBLClientHandlerInstance()
       * \brief  returns WBL Client Handler instance
       **************************************************************************/
      spi_tclWBLClientHandler* poGetWBLClientHandlerInstance();

      /*************************************************************************************************************
       ** FUNCTION:  spi_tclMPlayClientHandler* spi_tclExtClientFactory::poGetMPlayClientHandlerInstance
       *************************************************************************************************************/
      /*!
       * \fn     spi_tclMPlayClientHandler* poGetMPlayClientHandlerInstance()
       * \brief  returns MPlay Client Handler instance
       **************************************************************************/
      spi_tclMPlayClientHandler* poGetMPlayClientHandlerInstance();

      /*************************************************************************************************************
       ** FUNCTION:  spi_tclBluetoothClient* spi_tclExtClientFactory::poGetBTClientHandlerInstance
       *************************************************************************************************************/
      /*!
       * \fn     spi_tclBluetoothClient* poGetBTClientHandlerInstance()
       * \brief  returns BT Client Handler instance
       **************************************************************************/
      spi_tclBluetoothClient* poGetBTClientHandlerInstance();
	  
	  /*************************************************************************************************************
       ** FUNCTION:  spi_tclTelephoneClient* spi_tclExtClientFactory::poGetTelClientHandlerInstance
       *************************************************************************************************************/
      /*!
       * \fn     spi_tclTelephoneClient* poGetTelClientHandlerInstance()
       * \brief  returns Telephone Client Handler instance
       **************************************************************************/
      spi_tclTelephoneClient* poGetTelClientHandlerInstance();

      /***************************************************************************
       ** FUNCTION:  spi_tclExtClientFactory::vLoadSettings()
       ***************************************************************************/
      /*!
       * \fn      vLoadSettings(const t_Bool cobCPWEnabledStatus)
       * \brief   vLoadSettings Method. Invoked during OFF->NORMAL state transition.
       * \sa      vLoadSettings()
       **************************************************************************/
      virtual t_Void vLoadSettings(const trSpiFeatureSupport& corfrSpiFeatureSupport);

      /***************************************************************************
       ** FUNCTION: t_Void spi_tclExtClientFactory::vRestoreSettings()
       ***************************************************************************/
      /*!
       * \fn     vRestoreSettings()
       * \brief  Interface to restore settings in SPI.
       * \param  None
       * \sa
       **************************************************************************/
      t_Void vRestoreSettings();

      /*************************************************************************************************************
       ** FUNCTION:  spi_tclClockClientHandler* spi_tclExtClientFactory::poGetClockClientHandlerInstance
       *************************************************************************************************************/
      /*!
       * \fn     spi_tclClockClientHandler* poGetClockClientHandlerInstance()()
       * \brief  returns VD Clock Client Handler instance
       **************************************************************************/
      spi_tclClockClientHandler* poGetClockClientHandlerInstance();


      /***************************************************************************
      ** FUNCTION: t_Void spi_tclExtClientFactory::vPrepareForRestoreSettings()
      ***************************************************************************/
      /*!
      * \fn     vPrepareForRestoreSettings()
      * \brief  Interface to Prepare for restore settings in SPI.
      * \param  None
      * \sa
      **************************************************************************/
      t_Void vPrepareForRestoreSettings();

      /***************************************************************************
      ** FUNCTION: t_Void spi_tclExtClientFactory::vRestoreSettingsComplete()
      ***************************************************************************/
      /*!
      * \fn     vRestoreSettingsComplete()
      * \param  None
      * \sa
      **************************************************************************/
      t_Void vRestoreSettingsComplete();


   private:
      /***************************************************************************
       *********************************PRIVATE***********************************
       ***************************************************************************/
      friend class GenericSingleton<spi_tclExtClientFactory>;

      spi_tclExtClientFactory();

      /***************************************************************************
       ** FUNCTION:  spi_tclExtClientFactory::spi_tclExtClientFactory
       ***************************************************************************/
      /*!
       * \fn     spi_tclExtClientFactory()
       * \brief  Parameterized  Constructor
       * \param  poMainAppl: pointer to main application
       **************************************************************************/
      spi_tclExtClientFactory(ahl_tclBaseOneThreadApp* poMainAppl);

      //!pointer to main app
      ahl_tclBaseOneThreadApp* m_poMainApp;

      //!pointer to Sensor Client Handler
      spi_tclSensorDataClientHandler* m_poSensorDataClient;

      //!pointer to Sensor PV Client Handler
      spi_tclSensorPVDataClientHandler* m_poPosDataClient;

      //!pointer to WBL Client Handler
      spi_tclWBLClientHandler* m_poWBLClientHandler;

      //!pointer to MediaPlayer Client Handler
      spi_tclMPlayClientHandler* m_poMPlayClientHandler;

      //!pointer to BT Client Handler
      spi_tclBluetoothClient* m_poBTClientHandler;
	  
	  //!pointer to Telephone Client Handler
      spi_tclTelephoneClient* m_poTelClientHandler;

      //!pointer to VD Clock Client Handler
      spi_tclClockClientHandler* m_poClockClient;	  

};

#endif /* _SPI_TCLEXTCLIENTFACTORY_H_ */
