/*!
 *******************************************************************************
 * \file              ExtInterfacesTypes.h
 * \brief             External Interfaces Types
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Common External Interfaces Types
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date       |  Author                      | Modifications
 09.01.2017 |  Unmukt Jain                 | Initial Version

 \endverbatim
 ******************************************************************************/
#ifndef ExtInterfacesTypes_H_
#define ExtInterfacesTypes_H_

#include <functional>
#include "BaseTypes.h"

typedef enum
{
   e32MODULEID_EXTPOSITION      = 1,
   e32MODULEID_EXTSENSOR        = 2,
   e32MODULEID_EXTWIFI          = 3,
   e32MODULEID_APPLEDISCOVERER  = 4,
   e32MODULEID_ROLESWITCH       = 5,
   e32MODULEID_METADATA         = 6,
   e32MODULEID_NAVDATA          = 7,
   e32MODULEID_NATIVETRANSPORT  = 8,
   e32MODULEID_BLUETOOTH        = 9,
   e32MODULEID_OOBT             = 10,
   e32MODULEID_TELEPHONE        = 11,
   e32MODULEID_MEDIADEVINFO     = 12,
   e32MODULEID_CLOCK            = 13
} tenExternalInterfaceModuleID;

/* 
* \struct trMediaDeviceInfo
* \brief Structure to maintain the BT media device info
*/
struct trMediaDeviceInfo
{
   t_U32 u32DevID;
   t_Bool bIsConnected;
   t_Bool bIsMediaPlaying;
   t_String szBTMACAddress;

   trMediaDeviceInfo():u32DevID(0),bIsConnected(false),bIsMediaPlaying(false),szBTMACAddress(){}

};

typedef std::function<t_Void(const trMediaDeviceInfo&)> tfpvMediaDeviceInfo;


/* 
* \struct trMediaDeviceInfoCbs
* \brief Structure to maintain the callbacks related to BT media device info
*/
struct trMediaDeviceInfoCbs
{
   tfpvMediaDeviceInfo fpvMediaDeviceInfo;
   trMediaDeviceInfoCbs():fpvMediaDeviceInfo(nullptr){}
};
#endif //ExtInterfacesTypes_H_
