/***********************************************************************/
/*!
 * \file  spi_tclExtClockDispatcher.h
 * \brief Message Dispatcher for Clock Messages.Implemented using
 *        double dispatch mechanism
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Message Dispatcher for Clock Messages
 AUTHOR:         Rajendra Naik Vadthe
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date        | Author                | Modification
 24.01.2019  |Rajendra Naik Vadthe   | Initial Version

 \endverbatim
 *************************************************************************/
#ifndef _SPI_TCLEXTCLOCKDISPATCHER_H_
#define _SPI_TCLEXTCLOCKDISPATCHER_H_

/***************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |--------------------------------------------------------------------------*/
#include "SPITypes.h"
#include "ExtInterfacesTypes.h"
#include "RespRegister.h"

/**************Forward Declarations******************************************/
class spi_tclExtClockDispatcher;

/****************************************************************************/
/*!
 * \class ClockMsgBase
 * \brief Base Message type for all Clock messages
 ****************************************************************************/
class ClockMsgBase: public trMsgBase
{
   public:

   /***************************************************************************
    ** FUNCTION:  ClockMsgBase::ClockMsgBase
    ***************************************************************************/
   /*!
    * \fn      ClockMsgBase()
    * \brief   Default constructor
    **************************************************************************/
   ClockMsgBase();

   /***************************************************************************
    ** FUNCTION:  ClockMsgBase::vDispatchMsg
    ***************************************************************************/
   /*!
    * \fn      vDispatchMsg(spi_tclExtClockDispatcher* poClockDispatcher)
    * \brief   Pure virtual function to be overridden by inherited classes for
    *          dispatching the message
    * \param   poClockDispatcher : pointer to Message dispatcher for Clock
    **************************************************************************/
   virtual t_Void vDispatchMsg(spi_tclExtClockDispatcher* poClockDispatcher) = 0;

   /***************************************************************************
    ** FUNCTION:  ClockMsgBase::~ClockMsgBase
    ***************************************************************************/
   /*!
    * \fn      ~ClockMsgBase()
    * \brief   Destructor
    **************************************************************************/
   virtual ~ClockMsgBase()
   {

   }
};


/****************************************************************************/
/*!
 * \class ClockMsg
 * \brief Configure Clock Result msg
 ****************************************************************************/
class ClockMsg: public ClockMsgBase
{
   public:

	  t_U8  m_cou8TimeFormat;
   /***************************************************************************
    ** FUNCTION:  ClockDataMsg::ClockDataMsg
    ***************************************************************************/
   /*!
    * \fn      ClockMsg()
    * \brief   Default constructor
    **************************************************************************/
   ClockMsg();

   /***************************************************************************
    ** FUNCTION:  ClockMsg::ClockMsg
    ***************************************************************************/
   /*!
    * \fn      ClockMsg(trClock rClock)
    * \brief   Paramaterized constructor
    **************************************************************************/
   ClockMsg(const t_U8 cou8TimeFormat);

   /***************************************************************************
    ** FUNCTION:  ClockMsg::~ClockMsg
    ***************************************************************************/
   /*!
    * \fn      ~ClockMsg()
    * \brief   Destructor
    **************************************************************************/
   virtual ~ClockMsg(){}

   /***************************************************************************
    ** FUNCTION:  ClockMsg::vDispatchMsg
    ***************************************************************************/
   /*!
    * \fn      vDispatchMsg(spi_tclExtClockDispatcher* poSensorDispatcher)
    * \brief   virtual function for dispatching the message of 'this' type
    * \param   poSensorDispatcher : pointer to Message dispatcher for Clock
    **************************************************************************/
   t_Void vDispatchMsg(spi_tclExtClockDispatcher* poSensorDispatcher);

   /***************************************************************************
    ** FUNCTION:  ClockMsg::vAllocateMsg
    ***************************************************************************/
   /*!
    * \fn      vAllocateMsg()
    * \brief   Allocates memory for non trivial datatypes (ex STL containers)
    * \sa      vDeAllocateMsg
    **************************************************************************/
   t_Void vAllocateMsg();

   /***************************************************************************
    ** FUNCTION:  ClockMsg::vDeAllocateMsg
    ***************************************************************************/
   /*!
    * \fn      vDeAllocateMsg()
    * \brief   Destroys memory allocated by vAllocateMsg()
    * \sa      vAllocateMsg
    **************************************************************************/
   t_Void vDeAllocateMsg();
};

/****************************************************************************/
/*!
 * \class spi_tclExtClockDispatcher
 * \brief Message Dispatcher for Sensor Messages
 ****************************************************************************/
class spi_tclExtClockDispatcher
{
   public:
   /***************************************************************************
    ** FUNCTION:  spi_tclExtClockDispatcher::spi_tclExtClockDispatcher
    ***************************************************************************/
   /*!
    * \fn      spi_tclExtClockDispatcher()
    * \brief   Default constructor
    **************************************************************************/
      spi_tclExtClockDispatcher();

   /***************************************************************************
    ** FUNCTION:  spi_tclExtClockDispatcher::~spi_tclExtClockDispatcher
    ***************************************************************************/
   /*!
    * \fn      ~spi_tclExtClockDispatcher()
    * \brief   Destructor
    **************************************************************************/
   ~spi_tclExtClockDispatcher();

   /***************************************************************************
    ** FUNCTION:  spi_tclExtClockDispatcher::vHandleSensorMsg(ClockMsg*...)
    ***************************************************************************/
   /*!
    * \fn      vHandleClockMsg(ClockMsg* poClockMsg)
    * \brief   Handles Messages of ClockMsg type
    * \param   poClockMsg : pointer to ClockMsg.
    **************************************************************************/
   t_Void vHandleClockMsg(ClockMsg* poClockMsg) const;

};
#endif /* _SPI_TCLEXTCLOCKDISPATCHER_H_ */
