/*!
*******************************************************************************
* \file              spi_tclExtCmdOOBT.cpp
* \brief             OOBT Adapter Implementation Class
*******************************************************************************
\verbatim
PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    OOBT Adapter Implementation Class
 AUTHOR:         Ramesh Sidaray Mudalagi
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date        | Author                           | Modification
 19.02.2018  | Ramesh Sidaray Mudalagi          | Initial Version

 \endverbatim
******************************************************************************/

/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/

#include "spi_tclExtCmdOOBT.h"
#include "Trace.h"
#include "spi_tclBluetoothClient.h"
#include "spi_tclExtClientFactory.h"
#include "spi_tclExtOOBTDispatcher.h"
#include "spi_tclExtCompMsgQInterface.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_EXTINTERFACE
#include "trcGenProj/Header/spi_tclExtCmdOOBT.cpp.trc.h"
#endif
//lint -save -e1055 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e1013 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e1401 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e601 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e19 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e10 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e55 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e58 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e48 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e808 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e63 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e40 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e64 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e746 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e515 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e516 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e601 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported

/*******************************************************************************
* FUNCTION: spi_tclExtCmdOOBT:: spi_tclExtCmdOOBT(t_Void)
*******************************************************************************/

spi_tclExtCmdOOBT::spi_tclExtCmdOOBT() : m_poBTClientHandler(NULL)
{
}

/*******************************************************************************
* FUNCTION: spi_tclExtCmdOOBT::~spi_tclExtCmdOOBT(t_Void)
*******************************************************************************/
spi_tclExtCmdOOBT::~spi_tclExtCmdOOBT()
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdOOBT::~spi_tclExtCmdOOBT entered "));
   m_poBTClientHandler = NULL;
}

/*******************************************************************************
* FUNCTION: spi_tclExtCmdOOBT::bInitialize()
*******************************************************************************/
t_Bool spi_tclExtCmdOOBT::bInitialize()
{
	ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdOOBT::bInitialize entered "));
    t_Bool bInit = false;
	spi_tclExtClientFactory *poExtClientFactory = spi_tclExtClientFactory::getInstance();
	if(NULL != poExtClientFactory)
	{
		m_poBTClientHandler = poExtClientFactory->poGetBTClientHandlerInstance();
		bInit = (NULL != m_poBTClientHandler);
	}

	vRegisterOOBTCallbacks();

	if(NULL != m_poBTClientHandler)
	{
	    m_poBTClientHandler->vRegisterForProperties();
	}

	ETG_TRACE_USR1(("[DESC]spi_tclExtCmdOOBT::bInitialize() status = %d",ETG_ENUM(BOOL,bInit)));
	return bInit;
}

/*******************************************************************************
* FUNCTION: spi_tclExtCmdOOBT::bUnInitialize()
*******************************************************************************/
t_Bool spi_tclExtCmdOOBT::bUnInitialize()
{
	ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdOOBT::bUnInitialize entered "));
	t_Bool bUninitSuccess = true;

	m_poBTClientHandler = NULL;

	ETG_TRACE_USR2(("[DESC]spi_tclExtCmdOOBT::bUnInitialize() status = %d ", ETG_ENUM(BOOL,bUninitSuccess)));
	return bUninitSuccess;
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclExtCmdOOBT::vRegisterBTCallbacks()
***************************************************************************/
t_Void spi_tclExtCmdOOBT::vRegisterOOBTCallbacks()
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdOOBT::vRegisterOOBTCallbacks() entered "));
   trOOBTPairingCallbacks rOOBTCallbacks;
   rOOBTCallbacks.fvOnOOBTComplete = std::bind(&spi_tclExtCmdOOBT::vOnOOBTCompleteCb,
                                                        this);

   if(NULL != m_poBTClientHandler)
   {
	   m_poBTClientHandler->vRegisterOOBTCallbacks(rOOBTCallbacks);
   }
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclExtCmdOOBT::vOnBTDeviceNameUpdateCb()
***************************************************************************/
t_Void spi_tclExtCmdOOBT::vOnOOBTCompleteCb()
{
	ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdOOBT::vOnOOBTTriggerCb() entered "));
	OOBTTriggerMsg oConflictsTriggerMsg;
	spi_tclExtCompMsgQInterface *poExtMsgQinterface = spi_tclExtCompMsgQInterface::getInstance();
	if (NULL != poExtMsgQinterface)
	{
		poExtMsgQinterface->bWriteMsgToQ(&oConflictsTriggerMsg,sizeof(oConflictsTriggerMsg));
	}//if (NULL != poExtMsgQinterface)

}
//lint �restore

