/*!
 *******************************************************************************
 * \file              spi_tclExtRespMediaDevInfo.h
 * \brief             External Interfaces Wrapper Response class for OOBT
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:   External Interfaces Wrapper Response class for OOBT
 COPYRIGHT:     &copy; RBEI


 \endverbatim
 ******************************************************************************/
#ifndef _SPI_TCLEXTRESPMEDIADEVINFO_H_
#define _SPI_TCLEXTRESPMEDIADEVINFO_H_

#include "ExtInterfacesTypes.h"
#include "RespBase.h"



/**
* \class   spi_tclExtRespMediaDevInfo
* \brief   Response class to send Media Device Info updates
*/
class spi_tclExtRespMediaDevInfo: public RespBase
{

public:

   /***************************************************************************
    ** FUNCTION:  virtual spi_tclExtRespMediaDevInfo::spi_tclExtRespMediaDevInfo()
    ***************************************************************************/
   /*!
    * \fn      spi_tclExtRespMediaDevInfo()
    * \brief   Constructor
    * \sa      spi_tclExtRespMediaDevInfo()
    **************************************************************************/
	spi_tclExtRespMediaDevInfo(): RespBase(e16EXT_MEDIADEVINFO_REGID) {}

   /***************************************************************************
    ** FUNCTION:  virtual spi_tclExtRespMediaDevInfo::~spi_tclExtRespMediaDevInfo()
    ***************************************************************************/
   /*!
    * \fn      virtual ~spi_tclExtRespMediaDevInfo()
    * \brief   Destructor
    * \sa      spi_tclExtRespMediaDevInfo()
    **************************************************************************/
   virtual ~spi_tclExtRespMediaDevInfo() {}

   /***************************************************************************
    ** FUNCTION:  t_Void spi_tclExtRespMediaDevInfo::vPostBTMediaDeviceInfo()
    ***************************************************************************/
   /*!
    * \fn      t_Void vPostBTMediaDeviceInfo(const trMediaDeviceInfo& corfrMediaDeviceInfo)
    * \brief   Called when Media device info is available
    * \param   corfrMediaDeviceInfo : [IN] Media Device Info
    * \sa      None
    **************************************************************************/
   virtual t_Void vPostBTMediaDeviceInfo(const trMediaDeviceInfo& /*corfrMediaDeviceInfo*/){}
};

#endif /* _SPI_TCLEXTRESPMEDIADEVINFO_H_ */
