/*!
 *******************************************************************************
 * \file              spi_tclExtRespBluetooth.h
 * \brief             External Interfaces Wrapper Response class for Bluetooth
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:   External Interfaces Wrapper Response class for Bluetooth
 COPYRIGHT:     &copy; RBEI

 HISTORY:
 Date       |  Author               | Modifications
 02.02.2017 |Dhiraj Asopa          | Initial Version

 \endverbatim
 ******************************************************************************/
#ifndef _SPI_TCLEXTRESPBLUETOOTH_H_
#define _SPI_TCLEXTRESPBLUETOOTH_H_

#include "ExtInterfacesTypes.h"
#include "RespBase.h"
#include "SPITypes.h"

class spi_tclExtRespBluetooth: public RespBase
{

public:

   /***************************************************************************
    ** FUNCTION:  virtual spi_tclExtRespBluetooth::spi_tclExtRespBluetooth()
    ***************************************************************************/
   /*!
    * \fn      spi_tclExtRespBluetooth()
    * \brief   Constructor
    * \sa      spi_tclExtRespBluetooth()
    **************************************************************************/
	spi_tclExtRespBluetooth(): RespBase(e16EXT_BLUETOOTH_REGID) {}

   /***************************************************************************
    ** FUNCTION:  virtual spi_tclExtRespBluetooth::~spi_tclExtRespBluetooth()
    ***************************************************************************/
   /*!
    * \fn      virtual ~spi_tclExtRespBluetooth()
    * \brief   Destructor
    * \sa      spi_tclExtRespBluetooth()
    **************************************************************************/
   virtual ~spi_tclExtRespBluetooth() {}

   /***************************************************************************
    ** FUNCTION:  t_Void spi_tclExtRespBluetooth::vPostBTConnectionChangedMsg()
    ***************************************************************************/
   /*!
    * \fn      t_Void vPostBTConnectionChangedMsg()
    * \brief   Called when BT Connection change result is sent by BT Client Handler.
    * \sa      None
    **************************************************************************/
   virtual t_Void vPostBTConnectionChangedMsg(t_String /*szBTDeviceAddress*/,tenBTConnectionResult /*enBTConnResult*/){}

   /***************************************************************************
    ** FUNCTION:  t_Void spi_tclExtRespBluetooth::vPostBTPairingStatusMsg()
    ***************************************************************************/
   /*!
    * \fn      t_Void vPostBTPairingStatusMsg()
    * \brief   Called when BT Pairing Status is sent by BT Client Handler.
    * \sa      None
    **************************************************************************/
   virtual t_Void vPostBTPairingStatusMsg(tenBTSetPairingStatus /*enBTSetPairingStatus*/, t_String /*szBTDeviceAddress*/){}

   /***************************************************************************
    ** FUNCTION:  t_Void spi_tclExtRespBluetooth::vPostBTServiceAvailabilityMsg()
    ***************************************************************************/
   /*!
    * \fn      t_Void vPostBTConnectionChangedMsg()
    * \brief   Called when BT On Service Availability is  sent by BT Client Handler.
    * \sa      None
    **************************************************************************/
   virtual t_Void vPostBTServiceAvailabilityMsg(t_Bool /*bServiceAvailable*/){}

   /***************************************************************************
    ** FUNCTION:  t_Void spi_tclExtRespBluetooth::vPostBTPairingInfoMsg()
    ***************************************************************************/
   /*!
    * \fn      t_Void vPostBTPairingInfoMsg()
    * \brief   Called when BT Pairing message is  sent by BT Client Handler.
    * \sa      None
    **************************************************************************/
   virtual t_Void vPostBTPairingInfoMsg(trBTPairingRequestInfo /*rBTPairingReqInfo*/){}

   /***************************************************************************
    ** FUNCTION:  t_Void spi_tclExtRespBluetooth::vPostBTLimitationModeMsg()
    ***************************************************************************/
   /*!
    * \fn      t_Void vPostBTLimitationModeMsg()
    * \brief   Called when BT limitation mode message is  sent by BT Client Handler.
    * \sa      None
    **************************************************************************/
   virtual t_Void vPostBTLimitationModeMsg(trBTLimitationModeInfo /*rBTLimitationModeInfo*/){}

   /***************************************************************************
    ** FUNCTION:  t_Void spi_tclExtRespBluetooth::vPostBTDeviceNameUpdateMsg()
    ***************************************************************************/
   /*!
    * \fn      t_Void vPostBTDeviceNameUpdateMsg()
    * \brief   Called when BT Device Name update message is  sent by BT Client Handler.
    * \sa      None
    **************************************************************************/
   virtual t_Void vPostBTDeviceNameUpdateMsg(t_String /*szBTDeviceAddress*/,t_String /*szBTDeviceName*/){}

   /***************************************************************************
    ** FUNCTION:  t_Void spi_tclExtRespBluetooth::vPostSetBTLimitationModeResultMsg()
    ***************************************************************************/
   /*!
    * \fn      t_Void vPostSetBTLimitationModeResultMsg()
    * \brief   Called when BT limitation mode message is  sent by BT Client Handler.
    * \sa      None
    **************************************************************************/
   virtual t_Void vPostSetBTLimitationModeResultMsg(t_Bool /*bSetBTLimitationModeResult*/){}

   /***************************************************************************
    ** FUNCTION:  t_Void spi_tclExtRespBluetooth::vPostBTProfileStatusUpdateMsg()
    ***************************************************************************/
   /*!
    * \fn      t_Void vPostBTProfileStatusUpdateMsg()
    * \brief   Called when BT profile status message is  sent by BT Client Handler.
    * \sa      None
    **************************************************************************/
   virtual t_Void vPostBTProfileStatusUpdateMsg(){}

};

#endif /* _SPI_TCLEXTRESPBLUETOOTH_H_ */
