/***********************************************************************/
/*!
 * \file  spi_tclExtOOBTDispatcher.h
 * \brief Message Dispatcher for OOBT Messages. implemented using
 *        double dispatch mechanism
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Message Dispatcher for Bluetooth Messages
 AUTHOR:         Ramesh Sidaray Mudalagi
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date        | Author                           | Modification
 19.02.2018  | Ramesh Sidaray Mudalagi          | Initial Version

 \endverbatim
 *************************************************************************/
#ifndef _SPI_TCLEXTOOBTDISPATCHER_H_
#define _SPI_TCLEXTOOBTDISPATCHER_H_

/***************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |--------------------------------------------------------------------------*/
#include "SPITypes.h"
#include "ExtInterfacesTypes.h"
#include "RespRegister.h"
#include "spi_BluetoothTypedefs.h"

/**************Forward Declarations******************************************/
class spi_tclExtOOBTDispatcher;

/****************************************************************************/
/*!
 * \class OOBTMsgBase
 * \brief Base Message type for all OOBT messages
 ****************************************************************************/
class OOBTMsgBase: public trMsgBase
{
   public:

   /***************************************************************************
    ** FUNCTION:  OOBTMsgBase::OOBTMsgBase
    ***************************************************************************/
   /*!
    * \fn      OOBTMsgBase()
    * \brief   Default constructor
    **************************************************************************/
	OOBTMsgBase();

   /***************************************************************************
    ** FUNCTION:  OOBTMsgBase::vDispatchMsg
    ***************************************************************************/
   /*!
    * \fn      vDispatchMsg(spi_tclExtOOBTDispatcher* poOOBTDispatcher)
    * \brief   Pure virtual function to be overridden by inherited classes for
    *          dispatching the message
    * \param   poOOBTDispatcher : pointer to Message dispatcher for Bluetooth
    **************************************************************************/
   virtual t_Void vDispatchMsg(spi_tclExtOOBTDispatcher* poOOBTDispatcher) = 0;

   /***************************************************************************
    ** FUNCTION:  OOBTMsgBase::~OOBTMsgBase
    ***************************************************************************/
   /*!
    * \fn      ~OOBTMsgBase()
    * \brief   Destructor
    **************************************************************************/
   virtual ~OOBTMsgBase()
   {

   }
};

/****************************************************************************/
/*!
 * \class OOBTTriggerMsg
 * \brief Conflicts Trigger Msg to invoke the PrepareSetup
 ****************************************************************************/
class OOBTTriggerMsg: public OOBTMsgBase
{
   public:

   /***************************************************************************
    ** FUNCTION:  OOBTTriggerMsg::OOBTTriggerMsg
    ***************************************************************************/
   /*!
    * \fn      OOBTTriggerMsg()
    **************************************************************************/
	OOBTTriggerMsg();

   /***************************************************************************
    ** FUNCTION:  OOBTTriggerMsg::~OOBTTriggerMsg
    ***************************************************************************/
   /*!
    * \fn      ~OOBTTriggerMsg()
    * \brief   Destructor
    **************************************************************************/
   virtual ~OOBTTriggerMsg(){}

   /***************************************************************************
    ** FUNCTION:  OOBTTriggerMsg::vDispatchMsg
    ***************************************************************************/
   /*!
    * \fn      vDispatchMsg(spi_tclExtOOBTDispatcher* poOOBTDispatcher)
    * \brief   virtual function for dispatching the message of 'this' type
    * \param   poOOBTDispatcher : pointer to Message dispatcher for OOBT
    **************************************************************************/
   t_Void vDispatchMsg(spi_tclExtOOBTDispatcher* poOOBTDispatcher);


   /***************************************************************************
    ** FUNCTION:  OOBTTriggerMsg::vAllocateMsg
    ***************************************************************************/
   /*!
    * \fn      vAllocateMsg()
    * \brief   Allocates memory for non trivial datatypes (ex STL containers)
    * \sa      vDeAllocateMsg
    **************************************************************************/
   t_Void vAllocateMsg();

   /***************************************************************************
    ** FUNCTION:  OOBTTriggerMsg::vDeAllocateMsg
    ***************************************************************************/
   /*!
    * \fn      vDeAllocateMsg()
    * \brief   Destroys memory allocated by vAllocateMsg()
    * \sa      vAllocateMsg
    **************************************************************************/
   t_Void vDeAllocateMsg();

};

/****************************************************************************/
/*!
 * \class spi_tclExtOOBTDispatcher
 * \brief Message Dispatcher for OOBT Messages
 ****************************************************************************/
class spi_tclExtOOBTDispatcher
{
   public:
   /***************************************************************************
    ** FUNCTION:  spi_tclExtOOBTDispatcher::spi_tclExtOOBTDispatcher
    ***************************************************************************/
   /*!
    * \fn      spi_tclExtOOBTDispatcher()
    * \brief   Default constructor
    **************************************************************************/
	spi_tclExtOOBTDispatcher();

   /***************************************************************************
    ** FUNCTION:  spi_tclExtOOBTDispatcher::~spi_tclExtOOBTDispatcher
    ***************************************************************************/
   /*!
    * \fn      ~spi_tclExtOOBTDispatcher()
    * \brief   Destructor
    **************************************************************************/
   ~spi_tclExtOOBTDispatcher();

   /***************************************************************************
    ** FUNCTION:  spi_tclExtOOBTDispatcher::vHandleOOBTMsg(OOBTTriggerMsg*...)
    ***************************************************************************/
   /*!
    * \fn      vHandleOOBTMsg(OOBTTriggerMsg* poOOBTTriggerMsg)
    * \brief   Handles Messages of OOBTTriggerMsg type
    * \param   poOOBTTriggerMsg : pointer to OOBTTriggerMsg.
    **************************************************************************/
   t_Void vHandleOOBTMsg(OOBTTriggerMsg* poOOBTTriggerMsg) const;

};

#endif /* _SPI_TCLEXTOOBTDISPATCHER_H_ */
