/*!
*******************************************************************************
* \file              spi_tclExtCmdOOBTIntf.h
* \brief             OOBT Interface class
*******************************************************************************
\verbatim
PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Class which provides interfaces to register/un-register
                with OOBT data provider.
AUTHOR:         Ramesh Sidaray Mudalagi
COPYRIGHT:      &copy; RBEI

HISTORY:
Date       |  Author                                   | Modifications
19.02.2018 |  Ramesh Sidaray Mudalagi                  | Initial Version
\endverbatim
******************************************************************************/

#ifndef _SPI_TCLEXTCMDOOBTINTF_H_
#define _SPI_TCLEXTCMDOOBTINTF_H_

/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/

#include "spi_BluetoothTypedefs.h"
/**
* \brief   OOBT Intf class
*/
class spi_tclExtCmdOOBTIntf
{
public:
   /***************************************************************************
   *********************************PUBLIC*************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  virtual spi_tclExtCmdOOBTIntf::~spi_tclExtCmdOOBTIntf()
   ***************************************************************************/
   /*!
   * \fn      ~spi_tclExtCmdOOBTIntf()
   * \brief   Destructor
   * \sa
   **************************************************************************/
   virtual ~spi_tclExtCmdOOBTIntf(){}

   /***************************************************************************
    ** FUNCTION:  t_Bool spi_tclExtCmdOOBTIntf::bInitialize()
    ***************************************************************************/
   /*!
    * \fn      bInitialize()
    * \brief   Method to Initialize
    * \sa      bInitialize()
    **************************************************************************/
   virtual t_Bool bInitialize() = 0;

   /***************************************************************************
    ** FUNCTION:  t_Bool spi_tclExtCmdOOBTIntf::bUnInitialize()
    ***************************************************************************/
   /*!
    * \fn      bUnInitialize()
    * \brief   Method to UnInitialize
    * \sa      bInitialize()
    **************************************************************************/
   virtual t_Bool bUnInitialize() = 0;

   /***************************************************************************
    ** FUNCTION:  virtual t_Void spi_tclExtCmdOOBT::fvOnOOBTTriggerCb(...)
    ***************************************************************************/
   /*!
    * \fn      fvOnOOBTTriggerCb()
    * \brief   Interface to receive notification on Resolve Conflicts - to invoke the PrepareSetup
    * \retval  None
    **************************************************************************/
   virtual t_Void vOnOOBTCompleteCb()=0;
   /*************************************************************************
   ****************************END OF PUBLIC*********************************
   *************************************************************************/

private:
   /***************************************************************************
   *********************************PRIVATE************************************
   ***************************************************************************/

   /***************************************************************************
   *! Data members
   ***************************************************************************/

   /*************************************************************************
   ****************************END OF PRIVATE********************************
   *************************************************************************/

};

#endif // #define _SPI_TCLEXTCMDOOBTINTF_H_

