/*!
*******************************************************************************
* \file              spi_tclExtCmdBluetooth.h
* \brief             Bluetooth Adapter Implementation class
*******************************************************************************
\verbatim
PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Bluetooth Adapter Implementation class
AUTHOR:         Ramesh Sidaray Mudalagi
COPYRIGHT:      &copy; RBEI

HISTORY:
Date       |  Author                                   | Modifications
19.02.2018 |  Ramesh Sidaray Mudalagi                  | Initial Version
\endverbatim
******************************************************************************/

#ifndef SPI_TCLEXTCMDOOBT_H_
#define SPI_TCLEXTCMDOOBT_H_


/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/

#include "spi_tclExtCmdOOBTIntf.h"
#include "spi_BluetoothTypedefs.h"

class spi_tclBluetoothClient;

class spi_tclExtCmdOOBT: public spi_tclExtCmdOOBTIntf
{
public:
   /***************************************************************************
   *********************************PUBLIC*************************************
   ***************************************************************************/
   /***************************************************************************
   ** FUNCTION:  spi_tclExtCmdOOBT::spi_tclExtCmdOOBT()
   ***************************************************************************/
  /*!
   * \fn      spi_tclExtCmdOOBT()
   * \brief   Default constructor
   * \sa
   **************************************************************************/
	spi_tclExtCmdOOBT();

   /***************************************************************************
   ** FUNCTION:  virtual spi_tclExtCmdOOBT::~spi_tclExtCmdOOBT()
   ***************************************************************************/
   /*!
   * \fn      ~spi_tclExtCmdOOBT()
   * \brief   Destructor
   * \sa
   **************************************************************************/
   virtual ~spi_tclExtCmdOOBT();

   /***************************************************************************
    ** FUNCTION:  t_Bool spi_tclExtCmdOOBT::bInitialize()
    ***************************************************************************/
   /*!
    * \fn      bInitialize()
    * \brief   Method to Initialize
    * \sa      bInitialize()
    **************************************************************************/
   t_Bool bInitialize();

   /***************************************************************************
    ** FUNCTION:  t_Bool spi_tclExtCmdOOBT::bUnInitialize()
    ***************************************************************************/
   /*!
    * \fn      bUnInitialize()
    * \brief   Method to UnInitialize
    * \sa      bInitialize()
    **************************************************************************/
   t_Bool bUnInitialize();

   /***************************************************************************
    ** FUNCTION:  t_Void spi_tclExtCmdOOBT::fvOnOOBTTriggerCb(...)
    ***************************************************************************/
   /*!
    * \fn      fvOnOOBTTriggerCb()
    * \brief   Interface to receive notification on Resolve Conflicts - to invoke the PrepareSetup
    * \retval  None
    **************************************************************************/
   t_Void vOnOOBTCompleteCb();

   /*************************************************************************
   ****************************END OF PUBLIC*********************************
   *************************************************************************/

protected:

   /***************************************************************************
   *********************************PROTECTED**********************************
   ***************************************************************************/

   /***************************************************************************
   ******************************END OF PROTECTED******************************
   ***************************************************************************/

private:
   /***************************************************************************
   *********************************PRIVATE************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclExtCmdOOBT::vRegisterBTCallbacks()
   ***************************************************************************/
   /*!
   * \fn      vRegisterOOBTCallbacks()
   * \brief   register for OOBT callbacks.
   * \retval  None
   **************************************************************************/
   t_Void vRegisterOOBTCallbacks();

   /***************************************************************************
   *! Data members
   ***************************************************************************/

   //! BT client handler pointer
   spi_tclBluetoothClient *m_poBTClientHandler;

   /*************************************************************************
   ****************************END OF PRIVATE********************************
   *************************************************************************/

};
#endif // #define SPI_TCLEXTCMDOOBT_H_
