/*!
*******************************************************************************
* \file              spi_tclExtCmdMediaDevInfoIntf.h
* \brief             Adapter interface class for active media device info
*******************************************************************************
\verbatim
PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Adapter interface class for active media device info
AUTHOR:         Shiva Kumar Gurija
COPYRIGHT:      &copy; RBEI

HISTORY:
Date       |  Author                                   | Modifications
03.05.2018 |  Shiva Kumar Gurija                       | Initial Version
\endverbatim
******************************************************************************/

#ifndef _SPI_TCLCMDEXTCMDMEDIADEVINFOINTF_H_
#define _SPI_TCLCMDEXTCMDMEDIADEVINFOINTF_H_

/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/
#include "ExtInterfacesTypes.h"

/**
* \brief   Adapter interface class for active media device info
*/
class spi_tclExtCmdMediaDevInfoIntf
{
public:
   /***************************************************************************
   *********************************PUBLIC*************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  virtual spi_tclExtCmdMediaDevInfoIntf::~spi_tclExtCmdMediaDevInfoIntf()
   ***************************************************************************/
   /*!
   * \fn      ~spi_tclExtCmdMediaDevInfoIntf()
   * \brief   Destructor
   * \sa
   **************************************************************************/
   virtual ~spi_tclExtCmdMediaDevInfoIntf(){}

   /***************************************************************************
    ** FUNCTION:  t_Bool spi_tclExtCmdMediaDevInfoIntf::bInitialize()
    ***************************************************************************/
   /*!
    * \fn      bInitialize()
    * \brief   Method to Initialize
    * \sa      bInitialize()
    **************************************************************************/
   virtual t_Bool bInitialize() = 0;

   /***************************************************************************
    ** FUNCTION:  t_Bool spi_tclExtCmdMediaDevInfoIntf::bUnInitialize()
    ***************************************************************************/
   /*!
    * \fn      bUnInitialize()
    * \brief   Method to UnInitialize
    * \sa      bInitialize()
    **************************************************************************/
   virtual t_Bool bUnInitialize() = 0;

   /***************************************************************************
    ** FUNCTION:  t_Bool spi_tclExtCmdMediaDevInfoIntf::vMediaDeviceInfoUpdate()
    ***************************************************************************/
   /*!
    * \fn      t_Void vMediaDeviceInfoUpdate(const trMediaDeviceInfo& corfrMediaDeviceInfo)
    * \brief   Method to send the MediaDeviceInfo update
	* \param   corfrMediaDeviceInfo : [IN] Media Device Info update
    * \sa      t_Bool
    **************************************************************************/
   virtual t_Void vMediaDeviceInfoUpdate(const trMediaDeviceInfo& corfrMediaDeviceInfo) = 0;

   /***************************************************************************
    ** FUNCTION:  spi_tclExtCmdMediaDevInfoIntf& operator=(const spi_tclExtCmdMediaDevInfoIntf&)
    ***************************************************************************/
   /*!
    * \fn      spi_tclExtCmdMediaDevInfoIntf& operator=(const spi_tclExtCmdMediaDevInfoIntf&)
    * \brief   Assignment operator overlaoding
    **************************************************************************/
   spi_tclExtCmdMediaDevInfoIntf& operator=(const spi_tclExtCmdMediaDevInfoIntf&)=delete;
   
   /***************************************************************************
    ** FUNCTION:  spi_tclExtCmdMediaDevInfoIntf& operator=(const spi_tclExtCmdMediaDevInfoIntf&&)
    ***************************************************************************/
   /*!
    * \fn      spi_tclExtCmdMediaDevInfoIntf& operator=(const spi_tclExtCmdMediaDevInfoIntf&)
    * \brief   Move assignment operator overlaoding
    **************************************************************************/
   spi_tclExtCmdMediaDevInfoIntf& operator=(const spi_tclExtCmdMediaDevInfoIntf&& corfrSrc)=delete;


   /*************************************************************************
   ****************************END OF PUBLIC*********************************
   *************************************************************************/

private:
   /***************************************************************************
   *********************************PRIVATE************************************
   ***************************************************************************/

   /***************************************************************************
   *! Data members
   ***************************************************************************/

   /*************************************************************************
   ****************************END OF PRIVATE********************************
   *************************************************************************/

};

#endif // #define _SPI_TCLCMDEXTCMDMEDIADEVINFOINTF_H_

