/***********************************************************************/
/*!
 * \file  spi_tclExtBluetoothDispatcher.h
 * \brief Message Dispatcher for Bluetooth Messages. implemented using
 *        double dispatch mechanism
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Message Dispatcher for Bluetooth Messages
 AUTHOR:         Dhiraj Asopa
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date        | Author                | Modification
 02.02.2017  | Dhiraj Asopa          | Initial Version

 \endverbatim
 *************************************************************************/
#ifndef _SPI_TCLEXTBLUETOOTHDISPATCHER_H_
#define _SPI_TCLEXTBLUETOOTHDISPATCHER_H_

/***************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |--------------------------------------------------------------------------*/
#include "SPITypes.h"
#include "ExtInterfacesTypes.h"
#include "RespRegister.h"
#include "spi_BluetoothTypedefs.h"

/**************Forward Declarations******************************************/
class spi_tclExtBluetoothDispatcher;

/****************************************************************************/
/*!
 * \class BluetoothMsgBase
 * \brief Base Message type for all Bluetooth messages
 ****************************************************************************/
class BluetoothMsgBase: public trMsgBase
{
   public:

   /***************************************************************************
    ** FUNCTION:  BluetoothMsgBase::BluetoothMsgBase
    ***************************************************************************/
   /*!
    * \fn      BluetoothMsgBase()
    * \brief   Default constructor
    **************************************************************************/
	BluetoothMsgBase();

   /***************************************************************************
    ** FUNCTION:  BluetoothMsgBase::vDispatchMsg
    ***************************************************************************/
   /*!
    * \fn      vDispatchMsg(spi_tclExtBluetoothDispatcher* poBluetoothDispatcher)
    * \brief   Pure virtual function to be overridden by inherited classes for
    *          dispatching the message
    * \param   poBluetoothDispatcher : pointer to Message dispatcher for Bluetooth
    **************************************************************************/
   virtual t_Void vDispatchMsg(spi_tclExtBluetoothDispatcher* poBluetoothDispatcher) = 0;

   /***************************************************************************
    ** FUNCTION:  BluetoothMsgBase::~BluetoothMsgBase
    ***************************************************************************/
   /*!
    * \fn      ~BluetoothMsgBase()
    * \brief   Destructor
    **************************************************************************/
   virtual ~BluetoothMsgBase()
   {

   }
};

/****************************************************************************/
/*!
 * \class BTPairingStatusMsg
 * \brief BT Pairing Status Msg
 ****************************************************************************/
class BTPairingStatusMsg: public BluetoothMsgBase
{
   public:

    tenBTSetPairingStatus m_enBTSetPairingStatus;
    t_String *m_poszBTDeviceAddress;

   /***************************************************************************
    ** FUNCTION:  BTPairingStatusMsg::BTPairingStatusMsg
    ***************************************************************************/
   /*!
    * \fn      BTPairingStatusMsg()
    * \brief   Parameterized constructor
    * \param   [IN] enBTSetPairingStatus : Bluetooth Pairing Status
    * \param   [IN] szBTDeviceAddress : Bluetooth MAC Address
    **************************************************************************/
    BTPairingStatusMsg(tenBTSetPairingStatus enBTSetPairingStatus, t_String szBTDeviceAddress);

   /***************************************************************************
    ** FUNCTION:  BTPairingStatusMsg::~BTPairingStatusMsg
    ***************************************************************************/
   /*!
    * \fn      ~BTPairingStatusMsg()
    * \brief   Destructor
    **************************************************************************/
   virtual ~BTPairingStatusMsg(){}

   /***************************************************************************
    ** FUNCTION:  BTPairingStatusMsg::vDispatchMsg
    ***************************************************************************/
   /*!
    * \fn      vDispatchMsg(spi_tclExtBluetoothDispatcher* poBluetoothDispatcher)
    * \brief   virtual function for dispatching the message of 'this' type
    * \param   poBluetoothDispatcher : pointer to Message dispatcher for Bluetooth
    **************************************************************************/
   t_Void vDispatchMsg(spi_tclExtBluetoothDispatcher* poBluetoothDispatcher);

   /***************************************************************************
    ** FUNCTION:  BTPairingStatusMsg::vAllocateMsg
    ***************************************************************************/
   /*!
    * \fn      vAllocateMsg()
    * \brief   Allocates memory for non trivial datatypes (ex STL containers)
    * \sa      vDeAllocateMsg
    **************************************************************************/
   t_Void vAllocateMsg();

   /***************************************************************************
    ** FUNCTION:  BTPairingStatusMsg::vDeAllocateMsg
    ***************************************************************************/
   /*!
    * \fn      vDeAllocateMsg()
    * \brief   Destroys memory allocated by vAllocateMsg()
    * \sa      vAllocateMsg
    **************************************************************************/
   t_Void vDeAllocateMsg();
};

/****************************************************************************/
/*!
 * \class BTConnectionChangedMsg
 * \brief BT Connection Changed Msg
 ****************************************************************************/
class BTConnectionChangedMsg: public BluetoothMsgBase
{
   public:

      t_String *m_poszBTDeviceAddress;
      tenBTConnectionResult m_enBTConnResult;

   /***************************************************************************
    ** FUNCTION:  BTConnectionChangedMsg::BTConnectionChangedMsg
    ***************************************************************************/
   /*!
    * \fn      BTConnectionChangedMsg()
    * \brief   Parameterized constructor
    * \param   [IN] szBTDeviceAddress: Bluetooth address of device
    * \param   [IN] enBTConnResult: Connection/Disconnection result.
    **************************************************************************/
    BTConnectionChangedMsg(t_String szBTDeviceAddress,tenBTConnectionResult m_enBTConnResult);

   /***************************************************************************
    ** FUNCTION:  BTConnectionChangedMsg::~BTConnectionChangedMsg
    ***************************************************************************/
   /*!
    * \fn      ~BTConnectionChangedMsg()
    * \brief   Destructor
    **************************************************************************/
   virtual ~BTConnectionChangedMsg(){}

   /***************************************************************************
    ** FUNCTION:  BTConnectionChangedMsg::vDispatchMsg
    ***************************************************************************/
   /*!
    * \fn      vDispatchMsg(spi_tclExtBluetoothDispatcher* poBluetoothDispatcher)
    * \brief   virtual function for dispatching the message of 'this' type
    * \param   poBluetoothDispatcher : pointer to Message dispatcher for Bluetooth
    **************************************************************************/
   t_Void vDispatchMsg(spi_tclExtBluetoothDispatcher* poBluetoothDispatcher);

   /***************************************************************************
    ** FUNCTION:  BTConnectionChangedMsg::vAllocateMsg
    ***************************************************************************/
   /*!
    * \fn      vAllocateMsg()
    * \brief   Allocates memory for non trivial datatypes (ex STL containers)
    * \sa      vDeAllocateMsg
    **************************************************************************/
   t_Void vAllocateMsg();

   /***************************************************************************
    ** FUNCTION:  BTConnectionChangedMsg::vDeAllocateMsg
    ***************************************************************************/
   /*!
    * \fn      vDeAllocateMsg()
    * \brief   Destroys memory allocated by vAllocateMsg()
    * \sa      vAllocateMsg
    **************************************************************************/
   t_Void vDeAllocateMsg();
};
/****************************************************************************/
/*!
 * \class BTServiceAvailabilityMsg
 * \brief BT Service Availability msg
 ****************************************************************************/
class BTServiceAvailabilityMsg: public BluetoothMsgBase
{
   public:
      t_Bool m_bServiceAvailable;

   /***************************************************************************
    ** FUNCTION:  BTServiceAvailabilityMsg::BTServiceAvailabilityMsg
    ***************************************************************************/
   /*!
    * \fn      BTServiceAvailabilityMsg()
    * \brief   Parameterized constructor
    **************************************************************************/
   BTServiceAvailabilityMsg(t_Bool bServiceAvailable);

   /***************************************************************************
    ** FUNCTION:  BTServiceAvailabilityMsg::~BTServiceAvailabilityMsg
    ***************************************************************************/
   /*!
    * \fn      ~BTServiceAvailabilityMsg()
    * \brief   Destructor
    **************************************************************************/
   virtual ~BTServiceAvailabilityMsg(){}

   /***************************************************************************
    ** FUNCTION:  BTServiceAvailabilityMsg::vDispatchMsg
    ***************************************************************************/
   /*!
    * \fn      vDispatchMsg(spi_tclExtBluetoothDispatcher* poBluetoothDispatcher)
    * \brief   virtual function for dispatching the message of 'this' type
    * \param   poBluetoothDispatcher : pointer to Message dispatcher for Bluetooth
    **************************************************************************/
   t_Void vDispatchMsg(spi_tclExtBluetoothDispatcher* poBluetoothDispatcher);

   /***************************************************************************
    ** FUNCTION:  BTServiceAvailabilityMsg::vAllocateMsg
    ***************************************************************************/
   /*!
    * \fn      vAllocateMsg()
    * \brief   Allocates memory for non trivial datatypes (ex STL containers)
    * \sa      vDeAllocateMsg
    **************************************************************************/
   t_Void vAllocateMsg();

   /***************************************************************************
    ** FUNCTION:  BTServiceAvailabilityMsg::vDeAllocateMsg
    ***************************************************************************/
   /*!
    * \fn      vDeAllocateMsg()
    * \brief   Destroys memory allocated by vAllocateMsg()
    * \sa      vAllocateMsg
    **************************************************************************/
   t_Void vDeAllocateMsg();
};
/****************************************************************************/
/*!
 * \class BTPairingInfoMsg
 * \brief BT Pairable Mode Msg
 ****************************************************************************/
class BTPairingInfoMsg: public BluetoothMsgBase
{
   public:
      trBTPairingRequestInfo *m_poBTPairingReqInfo;

   /***************************************************************************
    ** FUNCTION:  BTPairingInfoMsg::BTPairingInfoMsg
    ***************************************************************************/
   /*!
    * \fn      BTPairingInfoMsg()
    * \brief   Parameterized constructor
    **************************************************************************/
   BTPairingInfoMsg(trBTPairingRequestInfo rBTPairingReqInfo);

   /***************************************************************************
    ** FUNCTION:  BTPairingInfoMsg::~BTPairingInfoMsg
    ***************************************************************************/
   /*!
    * \fn      ~BTPairingInfoMsg()
    * \brief   Destructor
    **************************************************************************/
   virtual ~BTPairingInfoMsg(){}

   /***************************************************************************
    ** FUNCTION:  BTPairingInfoMsg::vDispatchMsg
    ***************************************************************************/
   /*!
    * \fn      vDispatchMsg(spi_tclExtBluetoothDispatcher* poBluetoothDispatcher)
    * \brief   virtual function for dispatching the message of 'this' type
    * \param   poBluetoothDispatcher : pointer to Message dispatcher for Bluetooth
    **************************************************************************/
   t_Void vDispatchMsg(spi_tclExtBluetoothDispatcher* poBluetoothDispatcher);

   /***************************************************************************
    ** FUNCTION:  BTPairingInfoMsg::vAllocateMsg
    ***************************************************************************/
   /*!
    * \fn      vAllocateMsg()
    * \brief   Allocates memory for non trivial datatypes (ex STL containers)
    * \sa      vDeAllocateMsg
    **************************************************************************/
   t_Void vAllocateMsg();

   /***************************************************************************
    ** FUNCTION:  BTPairingInfoMsg::vDeAllocateMsg
    ***************************************************************************/
   /*!
    * \fn      vDeAllocateMsg()
    * \brief   Destroys memory allocated by vAllocateMsg()
    * \sa      vAllocateMsg
    **************************************************************************/
   t_Void vDeAllocateMsg();
};

/****************************************************************************/
/*!
 * \class BTLimitationModeMsg
 * \brief BT Limitation Mode Msg
 ****************************************************************************/
class BTLimitationModeMsg: public BluetoothMsgBase
{
   public:
      trBTLimitationModeInfo *m_poBTLimitationModeInfo;

   /***************************************************************************
    ** FUNCTION:  BTLimitationModeMsg::BTLimitationModeMsg
    ***************************************************************************/
   /*!
    * \fn      BTLimitationModeMsg()
    * \brief   Parameterized constructor
    **************************************************************************/
   BTLimitationModeMsg(trBTLimitationModeInfo rBTLimitationModeInfo);

   /***************************************************************************
    ** FUNCTION:  BTLimitationModeMsg::~BTLimitationModeMsg
    ***************************************************************************/
   /*!
    * \fn      ~BTLimitationModeMsg()
    * \brief   Destructor
    **************************************************************************/
   virtual ~BTLimitationModeMsg(){}

   /***************************************************************************
    ** FUNCTION:  BTLimitationModeMsg::vDispatchMsg
    ***************************************************************************/
   /*!
    * \fn      vDispatchMsg(spi_tclExtBluetoothDispatcher* poBluetoothDispatcher)
    * \brief   virtual function for dispatching the message of 'this' type
    * \param   poBluetoothDispatcher : pointer to Message dispatcher for Bluetooth
    **************************************************************************/
   t_Void vDispatchMsg(spi_tclExtBluetoothDispatcher* poBluetoothDispatcher);

   /***************************************************************************
    ** FUNCTION:  BTLimitationModeMsg::vAllocateMsg
    ***************************************************************************/
   /*!
    * \fn      vAllocateMsg()
    * \brief   Allocates memory for non trivial datatypes (ex STL containers)
    * \sa      vDeAllocateMsg
    **************************************************************************/
   t_Void vAllocateMsg();

   /***************************************************************************
    ** FUNCTION:  BTLimitationModeMsg::vDeAllocateMsg
    ***************************************************************************/
   /*!
    * \fn      vDeAllocateMsg()
    * \brief   Destroys memory allocated by vAllocateMsg()
    * \sa      vAllocateMsg
    **************************************************************************/
   t_Void vDeAllocateMsg();
};

/****************************************************************************/
/*!
 * \class BTDeviceNameUpdateMsg
 * \brief BT Limitation Mode Msg
 ****************************************************************************/
class BTDeviceNameUpdateMsg: public BluetoothMsgBase
{
   public:
      t_String *m_poszBTDeviceAddress;
      t_String *m_poszBTDeviceName;

   /***************************************************************************
    ** FUNCTION:  BTDeviceNameUpdateMsg::BTDeviceNameUpdateMsg
    ***************************************************************************/
   /*!
    * \fn      BTDeviceNameUpdateMsg()
    * \brief   Parameterized constructor
    **************************************************************************/
   BTDeviceNameUpdateMsg(t_String szBTDeviceAddress,t_String szBTDeviceName);

   /***************************************************************************
    ** FUNCTION:  BTDeviceNameUpdateMsg::~BTDeviceNameUpdateMsg
    ***************************************************************************/
   /*!
    * \fn      ~BTLimitationModeMsg()
    * \brief   Destructor
    **************************************************************************/
   virtual ~BTDeviceNameUpdateMsg(){}

   /***************************************************************************
    ** FUNCTION:  BTDeviceNameUpdateMsg::vDispatchMsg
    ***************************************************************************/
   /*!
    * \fn      vDispatchMsg(spi_tclExtBluetoothDispatcher* poBluetoothDispatcher)
    * \brief   virtual function for dispatching the message of 'this' type
    * \param   poBluetoothDispatcher : pointer to Message dispatcher for Bluetooth
    **************************************************************************/
   t_Void vDispatchMsg(spi_tclExtBluetoothDispatcher* poBluetoothDispatcher);

   /***************************************************************************
    ** FUNCTION:  BTDeviceNameUpdateMsg::vAllocateMsg
    ***************************************************************************/
   /*!
    * \fn      vAllocateMsg()
    * \brief   Allocates memory for non trivial datatypes (ex STL containers)
    * \sa      vDeAllocateMsg
    **************************************************************************/
   t_Void vAllocateMsg();

   /***************************************************************************
    ** FUNCTION:  BTDeviceNameUpdateMsg::vDeAllocateMsg
    ***************************************************************************/
   /*!
    * \fn      vDeAllocateMsg()
    * \brief   Destroys memory allocated by vAllocateMsg()
    * \sa      vAllocateMsg
    **************************************************************************/
   t_Void vDeAllocateMsg();
};

/****************************************************************************/
/*!
 * \class BTProfileStatusUpdateMsg
 * \brief BT profile status Msg
 ****************************************************************************/
class BTProfileStatusUpdateMsg: public BluetoothMsgBase
{
   public:
      
   /***************************************************************************
    ** FUNCTION:  BTProfileStatusUpdateMsg::BTProfileStatusUpdateMsg
    ***************************************************************************/
   /*!
    * \fn      BTProfileStatusUpdateMsg()
    * \brief   Parameterized constructor
    **************************************************************************/
   BTProfileStatusUpdateMsg();

   /***************************************************************************
    ** FUNCTION:  BTProfileStatusUpdateMsg::~BTProfileStatusUpdateMsg
    ***************************************************************************/
   /*!
    * \fn      ~BTLimitationModeMsg()
    * \brief   Destructor
    **************************************************************************/
   virtual ~BTProfileStatusUpdateMsg(){}

   /***************************************************************************
    ** FUNCTION:  BTProfileStatusUpdateMsg::vDispatchMsg
    ***************************************************************************/
   /*!
    * \fn      vDispatchMsg(spi_tclExtBluetoothDispatcher* poBluetoothDispatcher)
    * \brief   virtual function for dispatching the message of 'this' type
    * \param   poBluetoothDispatcher : pointer to Message dispatcher for Bluetooth
    **************************************************************************/
   t_Void vDispatchMsg(spi_tclExtBluetoothDispatcher* poBluetoothDispatcher);

   /***************************************************************************
    ** FUNCTION:  BTProfileStatusUpdateMsg::vAllocateMsg
    ***************************************************************************/
   /*!
    * \fn      vAllocateMsg()
    * \brief   Allocates memory for non trivial datatypes (ex STL containers)
    * \sa      vDeAllocateMsg
    **************************************************************************/
   t_Void vAllocateMsg();

   /***************************************************************************
    ** FUNCTION:  BTProfileStatusUpdateMsg::vDeAllocateMsg
    ***************************************************************************/
   /*!
    * \fn      vDeAllocateMsg()
    * \brief   Destroys memory allocated by vAllocateMsg()
    * \sa      vAllocateMsg
    **************************************************************************/
   t_Void vDeAllocateMsg();
};

/****************************************************************************/
/*!
 * \class SetBTLimitationModeResultMsg
 * \brief Set  BT Limitation Mode Result Msg
 ****************************************************************************/
class SetBTLimitationModeResultMsg: public BluetoothMsgBase
{
   public:
      t_Bool m_bSetBTLimitationModeResult;

   /***************************************************************************
    ** FUNCTION:  SetBTLimitationModeResultMsg::SetBTLimitationModeResultMsg
    ***************************************************************************/
   /*!
    * \fn      SetBTLimitationModeResultMsg()
    * \brief   Parameterized constructor
    **************************************************************************/
      SetBTLimitationModeResultMsg(t_Bool bSetBTLimitationModeResult);

   /***************************************************************************
    ** FUNCTION:  SetBTLimitationModeResultMsg::~SetBTLimitationModeResultMsg
    ***************************************************************************/
   /*!
    * \fn      ~SetBTLimitationModeResultMsg()
    * \brief   Destructor
    **************************************************************************/
   virtual ~SetBTLimitationModeResultMsg(){}

   /***************************************************************************
    ** FUNCTION:  SetBTLimitationModeResultMsg::vDispatchMsg
    ***************************************************************************/
   /*!
    * \fn      vDispatchMsg(spi_tclExtBluetoothDispatcher* poBluetoothDispatcher)
    * \brief   virtual function for dispatching the message of 'this' type
    * \param   poBluetoothDispatcher : pointer to Message dispatcher for Bluetooth
    **************************************************************************/
   t_Void vDispatchMsg(spi_tclExtBluetoothDispatcher* poBluetoothDispatcher);


   /***************************************************************************
    ** FUNCTION:  SetBTLimitationModeResultMsg::vAllocateMsg
    ***************************************************************************/
   /*!
    * \fn      vAllocateMsg()
    * \brief   Allocates memory for non trivial datatypes (ex STL containers)
    * \sa      vDeAllocateMsg
    **************************************************************************/
   t_Void vAllocateMsg();

   /***************************************************************************
    ** FUNCTION:  SetBTLimitationModeResultMsg::vDeAllocateMsg
    ***************************************************************************/
   /*!
    * \fn      vDeAllocateMsg()
    * \brief   Destroys memory allocated by vAllocateMsg()
    * \sa      vAllocateMsg
    **************************************************************************/
   t_Void vDeAllocateMsg();

};

/****************************************************************************/
/*!
 * \class spi_tclExtBluetoothDispatcher
 * \brief Message Dispatcher for Bluetooth Messages
 ****************************************************************************/
class spi_tclExtBluetoothDispatcher
{
   public:
   /***************************************************************************
    ** FUNCTION:  spi_tclExtBluetoothDispatcher::spi_tclExtBluetoothDispatcher
    ***************************************************************************/
   /*!
    * \fn      spi_tclExtBluetoothDispatcher()
    * \brief   Default constructor
    **************************************************************************/
	spi_tclExtBluetoothDispatcher();

   /***************************************************************************
    ** FUNCTION:  spi_tclExtBluetoothDispatcher::~spi_tclExtBluetoothDispatcher
    ***************************************************************************/
   /*!
    * \fn      ~spi_tclExtBluetoothDispatcher()
    * \brief   Destructor
    **************************************************************************/
   ~spi_tclExtBluetoothDispatcher();
   /***************************************************************************
    ** FUNCTION:  spi_tclExtBluetoothDispatcher::vHandleBluetoothMsg(BluetoothActiveBluetoothSetupMsg*...)
    ***************************************************************************/
   /*!
    * \fn      vHandleBluetoothMsg(BTConnectionChangedMsg* poBTConnectionChangedMsg)
    * \brief   Handles Messages of BTConnectionChangedMsg type
    * \param   poBTConnectionChangedMsg : pointer to BTConnectionChangedMsg.
    **************************************************************************/
   t_Void vHandleBluetoothMsg(BTConnectionChangedMsg* poBTConnectionChangedMsg) const;
   /***************************************************************************
    ** FUNCTION:  spi_tclExtBluetoothDispatcher::vHandleBluetoothMsg(BTServiceAvailabilityMsg*...)
    ***************************************************************************/
   /*!
    * \fn      vHandleBluetoothMsg(BTServiceAvailabilityMsg* poBTServiceAvailabilityMsg)
    * \brief   Handles Messages of BTServiceAvailabilityMsg type
    * \param   poBTServiceAvailabilityMsg : pointer to BTServiceAvailabilityMsg.
    **************************************************************************/
   t_Void vHandleBluetoothMsg(BTServiceAvailabilityMsg* poBTServiceAvailabilityMsg) const;
   /***************************************************************************
    ** FUNCTION:  spi_tclExtBluetoothDispatcher::vHandleBluetoothMsg(BTPairingInfoMsg*...)
    ***************************************************************************/
   /*!
    * \fn      vHandleBluetoothMsg(BTPairingInfoMsg* poBTPairingInfoMsg)
    * \brief   Handles Messages of BTPairingInfoMsg type
    * \param   poBTPairingInfoMsg : pointer to BTPairingInfoMsg.
    **************************************************************************/
   t_Void vHandleBluetoothMsg(BTPairingInfoMsg* poBTPairingInfoMsg) const;

   /***************************************************************************
    ** FUNCTION:  spi_tclExtBluetoothDispatcher::vHandleBluetoothMsg(BTPairingStatusMsg*...)
    ***************************************************************************/
   /*!
    * \fn      vHandleBluetoothMsg(BTPairingStatusMsg* poBTPairingStatusMsg)
    * \brief   Handles Messages of BTPairingStatusMsg type
    * \param   poBTPairingInfoMsg : pointer to BTPairingStatusMsg.
    **************************************************************************/
   t_Void vHandleBluetoothMsg(BTPairingStatusMsg* poBTPairingStatusMsg) const;

   /***************************************************************************
    ** FUNCTION:  spi_tclExtBluetoothDispatcher::vHandleBluetoothMsg(BTLimitationModeMsg*...)
    ***************************************************************************/
   /*!
    * \fn      vHandleBluetoothMsg(BTLimitationModeMsg* poBTLimitationModeMsg)
    * \brief   Handles Messages of BTLimitationModeMsg type
    * \param   poBTLimitationModeMsg : pointer to BTLimitationModeMsg.
    **************************************************************************/
   t_Void vHandleBluetoothMsg(BTLimitationModeMsg* poBTLimitationModeMsg) const;

   /***************************************************************************
    ** FUNCTION:  spi_tclExtBluetoothDispatcher::vHandleBluetoothMsg(BTDeviceNameUpdateMsg*...)
    ***************************************************************************/
   /*!
    * \fn      vHandleBluetoothMsg(BTDeviceNameUpdateMsg* poBTDeviceNameUpdateMsg)
    * \brief   Handles Messages of BTDeviceNameUpdateMsg type
    * \param   poBTDeviceNameUpdateMsg : pointer to BTDeviceNameUpdateMsg.
    **************************************************************************/
   t_Void vHandleBluetoothMsg(BTDeviceNameUpdateMsg* poBTDeviceNameUpdateMsg) const;

   /***************************************************************************
    ** FUNCTION:  spi_tclExtBluetoothDispatcher::vHandleBluetoothMsg(SetBTLimitationModeResultMsg*...)
    ***************************************************************************/
   /*!
    * \fn      vHandleBluetoothMsg(SetBTLimitationModeResultMsg* poSetBTLimitationModeResultMsg)
    * \brief   Handles Messages of SetBTLimitationModeResultMsg type
    * \param   poSetBTLimitationModeResultMsg : pointer to SetBTLimitationModeResultMsg.
    **************************************************************************/
   t_Void vHandleBluetoothMsg(SetBTLimitationModeResultMsg* poSetBTLimitationModeResultMsg) const;
   
      /***************************************************************************
    ** FUNCTION:  spi_tclExtBluetoothDispatcher::vHandleBluetoothMsg(BTProfileStatusUpdateMsg*...)
    ***************************************************************************/
   /*!
    * \fn      vHandleBluetoothMsg(BTProfileStatusUpdateMsg* poBTProfileStatusUpdateMsg)
    * \brief   Handles Messages of BTProfileStatusUpdateMsg type
    * \param   poBTProfileStatusUpdateMsg : pointer to BTProfileStatusUpdateMsg.
    **************************************************************************/
   t_Void vHandleBluetoothMsg(BTProfileStatusUpdateMsg* poBTProfileStatusUpdateMsg) const;

};

#endif /* _SPI_TCLEXTBLUETOOTHDISPATCHER_H_ */
