/*!
*******************************************************************************
* \file              spi_tclExtCmdAppleDiscoverer.cpp
* \brief             Apple Discoverer Adapter Implementation Class
*******************************************************************************
\verbatim
PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Apple Discoverer Adapter Implementation Class
COPYRIGHT:      &copy; RBEI

HISTORY:
Date        |  Author                       | Modifications
19.01.2017  |  Unmukt Jain                  | Initial Version

\endverbatim
******************************************************************************/

/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/

#include "spi_tclExtCmdAppleDiscoverer.h"
#include "Trace.h"
#include "spi_tclMPlayClientHandler.h"
#include "spi_tclExtClientFactory.h"
#include "spi_tclExtCompMsgQInterface.h"
#include "spi_tclExtAppleDiscovererDispatcher.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_EXTINTERFACE
#include "trcGenProj/Header/spi_tclExtCmdAppleDiscoverer.cpp.trc.h"
#endif
//lint -save -e1055 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e1013 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e1401 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e601 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e19 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e10 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e55 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e58 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e48 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e808 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e63 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e40 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e64 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e746 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e515 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e516 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported
//lint -save -e601 PQM_authorized_multi_492_to_494   Reason: C++11 not fully supported

/*******************************************************************************
* FUNCTION: spi_tclExtCmdAppleDiscoverer:: spi_tclExtCmdAppleDiscoverer(t_Void)
*******************************************************************************/

spi_tclExtCmdAppleDiscoverer::spi_tclExtCmdAppleDiscoverer() : m_poMPlayClientHandler(NULL)
{
}

/*******************************************************************************
* FUNCTION: spi_tclExtCmdAppleDiscoverer::~spi_tclExtCmdAppleDiscoverer(t_Void)
*******************************************************************************/
spi_tclExtCmdAppleDiscoverer::~spi_tclExtCmdAppleDiscoverer()
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdAppleDiscoverer::~spi_tclExtCmdAppleDiscoverer destructor entered "));
   m_poMPlayClientHandler  = NULL;
}

/*******************************************************************************
* FUNCTION: spi_tclExtCmdAppleDiscoverer::bInitialize()
*******************************************************************************/
t_Bool spi_tclExtCmdAppleDiscoverer::bInitialize()
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdAppleDiscoverer::bInitialize entered "));
   t_Bool bInit = false;
   spi_tclExtClientFactory *poExtClientFactory = spi_tclExtClientFactory::getInstance();
   if(NULL != poExtClientFactory)
   {
      m_poMPlayClientHandler = poExtClientFactory->poGetMPlayClientHandlerInstance();
      SPI_NORMAL_ASSERT(NULL == m_poMPlayClientHandler);
   }
   bInit = (NULL != m_poMPlayClientHandler);
   vRegisterDiscovererCallbacks();
   ETG_TRACE_USR1(("[DESC]spi_tclExtCmdAppleDiscoverer::bInitialize() status = %d",ETG_ENUM(BOOL,bInit)));
   return bInit;
}

/*******************************************************************************
* FUNCTION: spi_tclExtCmdAppleDiscoverer::bUnInitialize()
*******************************************************************************/
t_Bool spi_tclExtCmdAppleDiscoverer::bUnInitialize()
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdAppleDiscoverer::bUnInitialize entered "));
   t_Bool bUninitSuccess = true;
   m_poMPlayClientHandler = NULL;
   ETG_TRACE_USR2(("[DESC]spi_tclExtCmdAppleDiscoverer::bUnInitialize() status = %d ", ETG_ENUM(BOOL,bUninitSuccess)));
   return bUninitSuccess;
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclExtCmdAppleDiscoverer::vRegisterWiFiCallbacks()
***************************************************************************/
t_Void spi_tclExtCmdAppleDiscoverer::vRegisterDiscovererCallbacks()
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdAppleDiscoverer::vRegisterDiscovererCallbacks() entered "));
   trDiscovererCbs rDiscovererCbs;
   rDiscovererCbs.fvDeviceConnectionCb = std::bind(&spi_tclExtCmdAppleDiscoverer::vOnDeviceConnectionCb,
            this,
            SPI_FUNC_PLACEHOLDERS_2);
   rDiscovererCbs.fvDeviceDisconnectionCb = std::bind(&spi_tclExtCmdAppleDiscoverer::vOnDeviceDisconnectionCb,
            this,
            SPI_FUNC_PLACEHOLDERS_4);
   tfvDeviceListUpdate fvDevicelistUpdate = std::bind(&spi_tclExtCmdAppleDiscoverer::vOnDeviceListMsg, this, SPI_FUNC_PLACEHOLDERS_2);
   if(NULL != m_poMPlayClientHandler)
   {
      m_poMPlayClientHandler->vRegisterCallbacks(rDiscovererCbs);
      m_poMPlayClientHandler->vRegisterCallbacks(fvDevicelistUpdate);
   }
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclExtCmdAppleDiscoverer::vOnDeviceConnectionCb()
***************************************************************************/
t_Void spi_tclExtCmdAppleDiscoverer::vOnDeviceConnectionCb(const trDeviceInfo& corfrDeviceInfo,
                                                           tenDiscovererType enDiscovererType)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdAppleDiscoverer::vOnDeviceConnectionCb() entered "));
   ETG_TRACE_USR1(("[DESC] spi_tclExtCmdAppleDiscoverer::vOnDeviceConnectionCb-BTMAC:%s",
            corfrDeviceInfo.szBTAddress.c_str()));
   ETG_TRACE_USR1(("[DESC] spi_tclExtCmdAppleDiscoverer::DeviceID-%d",
            corfrDeviceInfo.u32DeviceHandle));
   DeviceConnectedMsg oDeviceConnectedMsg(corfrDeviceInfo, enDiscovererType);
   spi_tclExtCompMsgQInterface *poExtMsgQinterface = spi_tclExtCompMsgQInterface::getInstance();
   if (NULL != poExtMsgQinterface)
   {
	   poExtMsgQinterface->bWriteMsgToQ(&oDeviceConnectedMsg,sizeof(oDeviceConnectedMsg));
   }//if (NULL != poExtMsgQinterface)
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclExtCmdAppleDiscoverer::vOnDeviceDisconnectionCb()
***************************************************************************/
t_Void spi_tclExtCmdAppleDiscoverer::vOnDeviceDisconnectionCb(const t_U32 cou32DeviceHandle,
                                                              tenDiscovererType enDiscovererType,
                                                              tenDeviceConnectionType enDeviceConnectionType,
                                                              tenSPISupport enCarplaySupport)
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdAppleDiscoverer::vOnDeviceDisconnectionCb() entered "));
   DeviceDisconnectedMsg oDeviceDisconnectedMsg(cou32DeviceHandle, enDiscovererType, enDeviceConnectionType, enCarplaySupport);
   spi_tclExtCompMsgQInterface *poExtMsgQinterface = spi_tclExtCompMsgQInterface::getInstance();
   if (NULL != poExtMsgQinterface)
   {
	   poExtMsgQinterface->bWriteMsgToQ(&oDeviceDisconnectedMsg,sizeof(oDeviceDisconnectedMsg));
   }//if (NULL != poExtMsgQinterface)
}
/***************************************************************************
** FUNCTION:  t_Void spi_tclExtCmdAppleDiscoverer::vOnDeviceListMsg(...)
***************************************************************************/
t_Void spi_tclExtCmdAppleDiscoverer::vOnDeviceListMsg(t_U32 u32DeviceID, const trDeviceInfo &rfcoDeviceInfo)
{
   SPI_INTENTIONALLY_UNUSED(u32DeviceID);

   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdAppleDiscoverer::vOnDeviceListMsg() entered "));
   DeviceListMsg oDeviceListMsg(rfcoDeviceInfo);
   spi_tclExtCompMsgQInterface *poExtMsgQinterface = spi_tclExtCompMsgQInterface::getInstance();
   if (NULL != poExtMsgQinterface)
   {
      poExtMsgQinterface->bWriteMsgToQ(&oDeviceListMsg,sizeof(oDeviceListMsg));
   }//if (NULL != poExtMsgQinterface)
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclExtCmdAppleDiscoverer::vStartiAP2OverCarPlay()
***************************************************************************/

t_Void spi_tclExtCmdAppleDiscoverer::vStartiAP2OverCarPlay(t_String szBTMACAddress)
{

   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdAppleDiscoverer::vStartiAP2OverCarPlay():%s ", szBTMACAddress.c_str()));

   if (NULL != m_poMPlayClientHandler)
   {
      m_poMPlayClientHandler->vStartiAP2OverCarPlay(szBTMACAddress);
   }

}
/***************************************************************************
 ** FUNCTION:  t_Bool spi_tclExtCmdAppleDiscoverer::vStartDeviceDetection()
 ***************************************************************************/
t_Void spi_tclExtCmdAppleDiscoverer::vStartDeviceDetection()
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtCmdAppleDiscoverer::vStartDeviceDetection()"));
   if(NULL != m_poMPlayClientHandler)
   {
       m_poMPlayClientHandler->vRegisterForDiscovererProperties();
   }
}

/**************************************************************************
** FUNCTION   : tVoid spi_tclExtCmdAppleDiscoverer:: vClearDeviceDetails()
***************************************************************************/
t_Void spi_tclExtCmdAppleDiscoverer::vClearDeviceDetails(const std::vector<t_U32> &corfrvecDeletedDevices)
{

   ETG_TRACE_USR1(("spi_tclExtCmdAppleDiscoverer::vClearDeviceDetails Entered"));

   if (nullptr != m_poMPlayClientHandler)
   {
      m_poMPlayClientHandler->vDeleteDevices(corfrvecDeletedDevices);
   }//if (nullptr != m_pSpiCmdIntf)
}

//lint -restore

