/***********************************************************************/
/*!
 * \file  spi_tclExtAppleDiscovererDispatcher.cpp
 * \brief Message Dispatcher for Apple Discoverer Messages. implemented using
 *        double dispatch mechanism
 *************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Message Dispatcher for Apple Discoverer Messages
 AUTHOR:         Unmukt Jain
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date        | Author                | Modification
 19.01.2017  | Unmukt Jain           | Initial Version

 \endverbatim
 *************************************************************************/

/***************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |--------------------------------------------------------------------------*/
#include "spi_tclExtAppleDiscovererDispatcher.h"
#include "spi_tclExtRespAppleDiscoverer.h"

//! Includes for Trace files
#include "Trace.h"
   #ifdef TARGET_BUILD
      #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
      #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_EXTINTERFACE
      #include "trcGenProj/Header/spi_tclExtAppleDiscovererDispatcher.cpp.trc.h"
   #endif
#endif

//! Macro to define message dispatch function
#define DEFINE_DISPATCH_MESSAGE_FUNCTION(COMMAND,DISPATCHER)\
t_Void COMMAND::vDispatchMsg(                               \
         DISPATCHER* poDispatcher)                          \
{                                                           \
   if (NULL != poDispatcher)                                \
   {                                                        \
      poDispatcher->vHandleAppleDiscovererMsg(this);             \
   }                                                        \
   vDeAllocateMsg();                                        \
}

/***************************************************************************
 ** FUNCTION:  AppleDiscovererMsgBase::AppleDiscovererMsgBase
 ***************************************************************************/
AppleDiscovererMsgBase::AppleDiscovererMsgBase()
{
   ETG_TRACE_USR1(("AppleDiscovererMsgBase::AppleDiscovererMsgBase entered\n"));
   vSetServiceID(e32MODULEID_APPLEDISCOVERER);
}

//!class DeviceConnectedMsg
/***************************************************************************
 ** FUNCTION:  DeviceConnectedMsg::DeviceConnectedMsg
 ***************************************************************************/
DeviceConnectedMsg::DeviceConnectedMsg(const trDeviceInfo &rfcoDeviceInfo, tenDiscovererType enDiscovererType):
		m_prDeviceInfo(NULL),
		m_enDiscovererType(enDiscovererType)
{
   vAllocateMsg();
   if(NULL != m_prDeviceInfo)
   {
	   (*m_prDeviceInfo) = rfcoDeviceInfo;
   }
}

/***************************************************************************
 ** FUNCTION:  DeviceConnectedMsg::vDispatchMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(DeviceConnectedMsg, spi_tclExtAppleDiscovererDispatcher);

/***************************************************************************
 ** FUNCTION:  DeviceConnectedMsg::vAllocateMsg
 ***************************************************************************/
t_Void DeviceConnectedMsg::vAllocateMsg()
{
   ETG_TRACE_USR1(("[FUNC]DeviceConnectedMsg::vAllocateMsg entered\n"));
   m_prDeviceInfo = new trDeviceInfo();
}

/***************************************************************************
 ** FUNCTION:  DeviceConnectedMsg::vDeAllocateMsg
 ***************************************************************************/
t_Void DeviceConnectedMsg::vDeAllocateMsg()
{
   ETG_TRACE_USR1(("[FUNC]DeviceConnectedMsg::vDeAllocateMsg entered\n"));
   RELEASE_MEM(m_prDeviceInfo);
}

//!class DeviceDisconnectedMsg
/***************************************************************************
 ** FUNCTION:  DeviceDisconnectedMsg::DeviceDisconnectedMsg
 ***************************************************************************/
DeviceDisconnectedMsg::DeviceDisconnectedMsg(t_U32 u32DeviceHandle, tenDiscovererType enDiscovererType,
         tenDeviceConnectionType enDeviceConnectionType, tenSPISupport enCarplaySupport) :
                  m_u32DeviceHandle(u32DeviceHandle),
                  m_enDiscovererType(enDiscovererType),
                  m_enDeviceConnectionType(enDeviceConnectionType),
                  m_enCarplaySupport(enCarplaySupport)
{
   vAllocateMsg();
}

/***************************************************************************
 ** FUNCTION:  DeviceDisconnectedMsg::vDispatchMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(DeviceDisconnectedMsg, spi_tclExtAppleDiscovererDispatcher);

/***************************************************************************
 ** FUNCTION:  DeviceDisconnectedMsg::vAllocateMsg
 ***************************************************************************/
t_Void DeviceDisconnectedMsg::vAllocateMsg()
{
   ETG_TRACE_USR1(("[FUNC]DeviceDisconnectedMsg::vAllocateMsg entered\n"));
}

/***************************************************************************
 ** FUNCTION:  DeviceDisconnectedMsg::vDeAllocateMsg
 ***************************************************************************/
t_Void DeviceDisconnectedMsg::vDeAllocateMsg()
{
   ETG_TRACE_USR1(("[FUNC]DeviceDisconnectedMsg::vDeAllocateMsg entered\n"));
}


//!class DeviceListMsg
/***************************************************************************
 ** FUNCTION:  DeviceListMsg::DeviceListMsg
 ***************************************************************************/
DeviceListMsg::DeviceListMsg(const trDeviceInfo &rfcoDeviceInfo):
      m_prDeviceInfo(NULL)
{
   vAllocateMsg();
   if(NULL != m_prDeviceInfo)
   {
      (*m_prDeviceInfo) = rfcoDeviceInfo;
   }
}

/***************************************************************************
 ** FUNCTION:  DeviceListMsg::vDispatchMsg
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(DeviceListMsg, spi_tclExtAppleDiscovererDispatcher);

/***************************************************************************
 ** FUNCTION:  DeviceListMsg::vAllocateMsg
 ***************************************************************************/
t_Void DeviceListMsg::vAllocateMsg()
{
   ETG_TRACE_USR1(("[FUNC]DeviceListMsg::vAllocateMsg entered\n"));
   m_prDeviceInfo = new trDeviceInfo();
}

/***************************************************************************
 ** FUNCTION:  DeviceListMsg::vDeAllocateMsg
 ***************************************************************************/
t_Void DeviceListMsg::vDeAllocateMsg()
{
   ETG_TRACE_USR1(("[FUNC]DeviceListMsg::vDeAllocateMsg entered\n"));
   RELEASE_MEM(m_prDeviceInfo);
}


//!class spi_tclExtAppleDiscovererDispatcher
/***************************************************************************
 ** FUNCTION:  spi_tclExtAppleDiscovererDispatcher::spi_tclExtAppleDiscovererDispatcher
 ***************************************************************************/
spi_tclExtAppleDiscovererDispatcher::spi_tclExtAppleDiscovererDispatcher()
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtAppleDiscovererDispatcher::spi_tclExtAppleDiscovererDispatcher entered "));
}

/***************************************************************************
 ** FUNCTION:  spi_tclExtAppleDiscovererDispatcher::~spi_tclExtAppleDiscovererDispatcher
 ***************************************************************************/
spi_tclExtAppleDiscovererDispatcher::~spi_tclExtAppleDiscovererDispatcher()
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtAppleDiscovererDispatcher::~spi_tclExtAppleDiscovererDispatcher entered "));
}

/***************************************************************************
 ** FUNCTION:  spi_tclExtAppleDiscovererDispatcher::vHandleAppleDiscovererMsg(DeviceConnectedMsg...)
 ***************************************************************************/
t_Void spi_tclExtAppleDiscovererDispatcher::
       vHandleAppleDiscovererMsg(DeviceConnectedMsg *poDeviceConnectedMsg)const
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtAppleDiscovererDispatcher::vHandleAppleDiscovererMsg entered "));
   if (NULL != poDeviceConnectedMsg && NULL != poDeviceConnectedMsg->m_prDeviceInfo)
   {
      CALL_REG_OBJECTS(spi_tclExtRespAppleDiscoverer,
    		  e16EXT_APPLEDISCOVERER_REGID,
    		  vPostDeviceConnectedMsg(*(poDeviceConnectedMsg->m_prDeviceInfo),
    				                    poDeviceConnectedMsg->m_enDiscovererType
    				                  ));
   }
}
/***************************************************************************
 ** FUNCTION:  spi_tclExtAppleDiscovererDispatcher::vHandleAppleDiscovererMsg(DeviceListMsg...)
 ***************************************************************************/
t_Void spi_tclExtAppleDiscovererDispatcher::
       vHandleAppleDiscovererMsg(DeviceListMsg *poDeviceListMsg)const
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtAppleDiscovererDispatcher::vHandleAppleDiscovererMsg entered "));
   if (NULL != poDeviceListMsg && NULL != poDeviceListMsg->m_prDeviceInfo)
   {
      CALL_REG_OBJECTS(spi_tclExtRespAppleDiscoverer,
           e16EXT_APPLEDISCOVERER_REGID,
           vPostDeviceListMsg(*(poDeviceListMsg->m_prDeviceInfo)));
   }
}
/***************************************************************************
 ** FUNCTION:  spi_tclExtAppleDiscovererDispatcher::vHandleAppleDiscovererMsg(DeviceDisconnectedMsg...)
 ***************************************************************************/
t_Void spi_tclExtAppleDiscovererDispatcher::
       vHandleAppleDiscovererMsg(DeviceDisconnectedMsg *poDeviceDisconnectedMsg) const
{
   ETG_TRACE_USR1(("[FUNC]spi_tclExtAppleDiscovererDispatcher::vHandleAppleDiscovererMsg entered "));
   if (NULL != poDeviceDisconnectedMsg)
   {
      CALL_REG_OBJECTS(spi_tclExtRespAppleDiscoverer,
               e16EXT_APPLEDISCOVERER_REGID,
               vPostDeviceDisconnectedMsg( poDeviceDisconnectedMsg->m_u32DeviceHandle,
                        poDeviceDisconnectedMsg->m_enDiscovererType,
                        poDeviceDisconnectedMsg->m_enDeviceConnectionType,
                        poDeviceDisconnectedMsg->m_enCarplaySupport));
   }
}

///////////////////////////////////////////////////////////////////////////////
// <EOF>
