/*!
 *******************************************************************************
 * \file              spi_tclExtRespAppleDiscoverer.h
 * \brief             External Interfaces Wrapper Response class for Apple Discoverer
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:   External Interfaces Wrapper Response class for Apple Discoverer
 COPYRIGHT:     &copy; RBEI

 HISTORY:
 Date       |  Author               | Modifications
 20.01.2017 | Unmukt Jain           | Initial Version

 \endverbatim
 ******************************************************************************/
#ifndef _SPI_TCLEEXTRESPAPPLEDISCOVERER_H_
#define _SPI_TCLEEXTRESPAPPLEDISCOVERER_H_

#include "ExtInterfacesTypes.h"
#include "RespBase.h"
#include "SPITypes.h"

class spi_tclExtRespAppleDiscoverer: public RespBase
{

public:

   /***************************************************************************
    ** FUNCTION:  virtual spi_tclExtRespAppleDiscoverer::spi_tclExtRespAppleDiscoverer()
    ***************************************************************************/
   /*!
    * \fn      spi_tclExtRespAppleDiscoverer()
    * \brief   Constructor
    * \sa      spi_tclExtRespAppleDiscoverer()
    **************************************************************************/
	spi_tclExtRespAppleDiscoverer(): RespBase(e16EXT_APPLEDISCOVERER_REGID) {}

   /***************************************************************************
    ** FUNCTION:  virtual spi_tclExtRespAppleDiscoverer::~spi_tclExtRespAppleDiscoverer()
    ***************************************************************************/
   /*!
    * \fn      virtual ~spi_tclExtRespAppleDiscoverer()
    * \brief   Destructor
    * \sa      spi_tclExtRespAppleDiscoverer()
    **************************************************************************/
   virtual ~spi_tclExtRespAppleDiscoverer() {}

   /***************************************************************************
    ** FUNCTION:  t_Void spi_tclExtRespAppleDiscoverer::vPostDeviceConnectedMsg()
    ***************************************************************************/
   /*!
    * \fn      t_Void vPostDeviceConnectedMsg()
    * \brief   Called when new USB device is detected
    * \param   corfrDeviceInfo: a trDeviceInfo type structure
    * \param   enDiscovererType: Discoverer type
    * \sa      None
    **************************************************************************/
   virtual t_Void vPostDeviceConnectedMsg(const trDeviceInfo & /*rfcoDeviceInfo*/,
                                          tenDiscovererType /*enDiscovererType*/) {};

   /***************************************************************************
    ** FUNCTION:  t_Void spi_tclExtRespAppleDiscoverer::vPostDeviceListMsg()
    ***************************************************************************/
   /*!
    * \fn      t_Void vPostDeviceListMsg()
    * \brief   Called on devicelist update
    * \param   corfrDeviceInfo: a trDeviceInfo type structure
    * \sa      None
    **************************************************************************/
   virtual t_Void vPostDeviceListMsg(const trDeviceInfo & /*rfcoDeviceInfo*/) {};

   /***************************************************************************
    ** FUNCTION:  t_Void spi_tclExtRespAppleDiscoverer::vPostDeviceDisconnectedMsg()
    ***************************************************************************/
   /*!
    * \fn      t_Void vPostDeviceDisconnectedMsg()
    * \brief   Called when USB device is disconnected
    * \param   cou32DeviceHandle: device handle
    * \param   enDiscovererType: Discoverer type
    * \param   enCarplaySupport: Carplay support
    * \sa      None
    **************************************************************************/
   virtual t_Void vPostDeviceDisconnectedMsg(const t_U32 /*cou32DeviceHandle*/,
            tenDiscovererType /*enDiscovererType*/,
            tenDeviceConnectionType /*enDevConnType*/,
            tenSPISupport /*enCarplaySupport*/) {};

};

#endif /* _SPI_TCLEEXTRESPAPPLEDISCOVERER_H_ */
