/*!
*******************************************************************************
* \file              spi_tclExtCmdAppleDiscoverer.h
* \brief             Apple Discoverer Adapter Implementation class
*******************************************************************************
\verbatim
PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Apple Discoverer Adapter Implementation class
COPYRIGHT:      &copy; RBEI

HISTORY:
Date       |  Author                      | Modifications
19.01.2017 |  Unmukt Jain                 | Initial Version
\endverbatim
******************************************************************************/

#ifndef SPI_TCLEXTCMDAPPLEDISCOVERER_H_
#define SPI_TCLEXTCMDAPPLEDISCOVERER_H_


/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/

#include "SPITypes.h"
#include "spi_tclExtCmdAppleDiscovererIntf.h"
#include "spi_ConnMngrTypeDefines.h"

class spi_tclMPlayClientHandler;

class spi_tclExtCmdAppleDiscoverer: public spi_tclExtCmdAppleDiscovererIntf
{
public:
   /***************************************************************************
   *********************************PUBLIC*************************************
   ***************************************************************************/
   /***************************************************************************
   ** FUNCTION:  spi_tclExtCmdAppleDiscoverer::spi_tclExtCmdAppleDiscoverer()
   ***************************************************************************/
  /*!
   * \fn      spi_tclExtCmdAppleDiscoverer()
   * \brief   Default constructor
   * \sa
   **************************************************************************/
	spi_tclExtCmdAppleDiscoverer();

   /***************************************************************************
   ** FUNCTION:  virtual spi_tclExtCmdAppleDiscoverer::
   **                       ~spi_tclExtCmdAppleDiscoverer()
   ***************************************************************************/
   /*!
   * \fn      ~spi_tclExtCmdAppleDiscoverer()
   * \brief   Destructor
   * \sa
   **************************************************************************/
   virtual ~spi_tclExtCmdAppleDiscoverer();

   /***************************************************************************
    ** FUNCTION:  t_Bool spi_tclExtCmdAppleDiscoverer::bInitialize()
    ***************************************************************************/
   /*!
    * \fn      bInitialize()
    * \brief   Method to Initialize
    * \sa      bInitialize()
    **************************************************************************/
   t_Bool bInitialize();

   /***************************************************************************
    ** FUNCTION:  t_Bool spi_tclExtCmdAppleDiscoverer::bUnInitialize()
    ***************************************************************************/
   /*!
    * \fn      bUnInitialize()
    * \brief   Method to UnInitialize
    * \sa      bInitialize()
    **************************************************************************/
   t_Bool bUnInitialize();

   t_Void vStartiAP2OverCarPlay(t_String szBTMACAddress);

   /***************************************************************************
    ** FUNCTION:  t_Void spi_tclExtCmdAppleDiscoverer::vStartDeviceDetection()
    ***************************************************************************/
   /*!
    * \fn      bInitialize()
    * \brief   Starts detecting Apple Devices
    **************************************************************************/
   t_Void vStartDeviceDetection();


   /*************************************************************************
   ****************************END OF PUBLIC*********************************
   *************************************************************************/

protected:

   /***************************************************************************
   *********************************PROTECTED**********************************s
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclExtCmdAppleDiscoverer::vOnDeviceConnectionCb(...)
   ***************************************************************************/
   /*!
   * \fn      vOnDeviceConnectionCb()
   * \brief   Called when new USB device is detected
   * \param   corfrDeviceInfo: a trDeviceInfo type structure
   * \param   enDiscovererType: Discoverer type
   * \retval  None
   **************************************************************************/
   t_Void vOnDeviceConnectionCb(const trDeviceInfo& corfrDeviceInfo, tenDiscovererType enDiscovererType);

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclExtCmdAppleDiscoverer::vOnDeviceDisconnectionCb(...)
   ***************************************************************************/
   /*!
   * \fn      vOnDeviceDisconnectionCb()
   * \brief   Called when USB device is disconnected
   * \param   cou32DeviceHandle: device handle
   * \param   enDiscovererType: Discoverer type
   * \retval  None
   **************************************************************************/
   t_Void vOnDeviceDisconnectionCb(const t_U32 cou32DeviceHandle, tenDiscovererType enDiscovererType,
            tenDeviceConnectionType enDeviceConnectionType, tenSPISupport enCarplaySupport);

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclExtCmdAppleDiscoverer::vOnDeviceListMsg(...)
   ***************************************************************************/
   /*!
   * \fn      vOnDeviceListMsg()
   * \brief   called when Devicelist message is received
   * \param   u32DeviceID: device handle
   * \param   rfcoDeviceInfo: Discoverer Info
   * \retval  None
   **************************************************************************/
   t_Void vOnDeviceListMsg(t_U32 u32DeviceID, const trDeviceInfo &rfcoDeviceInfo);

   /***************************************************************************
    ** FUNCTION: t_Void spi_tclExtCmdAppleDiscoverer::vClearDeviceDetails
    ***************************************************************************/
   /*!
    * \fn     vDeleteDevicesvClearDeviceDetails
    * \brief  Deleting the Device
    * \param  corfrvecDeletedDevices : List of Devices to be Deleted
    **************************************************************************/
   t_Void vClearDeviceDetails(const std::vector<t_U32> &corfrvecDeletedDevices);

   /***************************************************************************
   ******************************END OF PROTECTED******************************
   ***************************************************************************/

private:
   /***************************************************************************
   *********************************PRIVATE************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclExtCmdAppleDiscoverer::vRegisterDiscovererCallbacks()
   ***************************************************************************/
   /*!
   * \fn      vRegisterDiscovererCallbacks()
   * \brief   Registers Discoverer callbacks to MediaPlayer client.
   * \retval  None
   **************************************************************************/
   t_Void vRegisterDiscovererCallbacks();

   /***************************************************************************
   *! Data members
   ***************************************************************************/

   //! MediaPlayer client handler pointer
   spi_tclMPlayClientHandler *m_poMPlayClientHandler;

   /*************************************************************************
   ****************************END OF PRIVATE********************************
   *************************************************************************/

};
#endif // #define SPI_TCLEXTCMDAPPLEDISCOVERER_H_


