/***********************************************************************/
/*!
* \file  spi_tclDiPOVideoDispatcher.h
* \brief Message Dispatcher for Video Messages.
*************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Message Dispatcher for Video Messages.
AUTHOR:         Shiva Kumar Gurija
COPYRIGHT:      &copy; RBEI

HISTORY:
Date        | Author                | Modification
21.06.2017  | Shiva Kumar Gurija    | Initial Version

\endverbatim
*************************************************************************/
#ifndef _SPI_TCLDIPOVIDEODISPATCHER_H_
#define _SPI_TCLDIPOVIDEODISPATCHER_H_

/***************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|--------------------------------------------------------------------------*/
#include "DiPOTypes.h"
#include "DiPOWrapperTypes.h"
class spi_tclDiPOVideoDispatcher;

/******************************************************************************
| typedefs (scope: module-global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/

/****************************************************************************/
/*!
 * \class DiPOVideoMsgBase
 * \brief Base Message type for all Video messages
 ****************************************************************************/
class DiPOVideoMsgBase: public trMsgBase
{
   public:
      /***************************************************************************
       ** FUNCTION:  DiPOVideoMsgBase::DiPOVideoMsgBase
       ***************************************************************************/
      /*!
       * \fn      DiPOVideoMsgBase()
       * \brief   Default constructor
       **************************************************************************/
       DiPOVideoMsgBase();

      /***************************************************************************
       ** FUNCTION:  DiPOVideoMsgBase::vDispatchMsg
       ***************************************************************************/
      /*!
       * \fn      vDispatchMsg(spi_tclDiPODiscovererDispatcher* poDiscDispatcher)
       * \brief   Pure virtual function to be overridden by inherited classes for
       *          dispatching the message
       * \param poDiscDispatcher: pointer to Discoverer Message Dispatcher
       **************************************************************************/
      virtual t_Void vDispatchMsg(spi_tclDiPOVideoDispatcher* poDiscDispatcher) = 0;

      /***************************************************************************
       ** FUNCTION:  DiPOVideoMsgBase::~DiPOVideoMsgBase
       ***************************************************************************/
      /*!
       * \fn      ~DiPOVideoMsgBase()
       * \brief   Destructor
       **************************************************************************/
      virtual ~DiPOVideoMsgBase()
      {

      }

      /***************************************************************************
       ** FUNCTION:  DiPOVideoMsgBase::u32GetDeviceHandle
       ***************************************************************************/
      /*!
       * \fn      u32GetDeviceHandle()
       * \brief   returns the device handle
       **************************************************************************/
      virtual t_U32 u32GetDeviceHandle();

      /***************************************************************************
       ** FUNCTION:  DiPOVideoMsgBase::vSetDeviceHandle
       ***************************************************************************/
      /*!
       * \fn      vSetDeviceHandle()
       * \brief   sets the device handle
       **************************************************************************/
      virtual t_Void vSetDeviceHandle(t_U32 u32DevHndle);

   private:
      t_U32 m_u32DeviceHandle;
};

/****************************************************************************/
/*!
 * \class OnRequestUIMsg
 * \brief On Request UI update from Phone
 ****************************************************************************/
class OnRequestUIMsg: public DiPOVideoMsgBase
{
   public:   
      
      t_Char cRequestUIURL[DIPO_MAX_STR_LEN];

      /***************************************************************************
       ** FUNCTION:  OnRequestUIMsg::OnRequestUIMsg()
       ***************************************************************************/
      /*!
       * \fn      OnRequestUIMsg()
       * \brief   Default constructor
       **************************************************************************/
       OnRequestUIMsg();

      /***************************************************************************
       ** FUNCTION:  OnRequestUIMsg::~OnRequestUIMsg()
       ***************************************************************************/
      /*!
       * \fn      ~OnRequestUIMsg()
       * \brief   OnRequestUIMsg
       **************************************************************************/
       virtual ~OnRequestUIMsg() {}

      /***************************************************************************
       ** FUNCTION:  OnRequestUIMsg::vDispatchMsg()
       ***************************************************************************/
      /*!
       * \fn      vDispatchMsg(spi_tclDiPOVideoDispatcher* poVideoDispatcher)
       * \brief   virtual function for dispatching the message of 'this' type
       * \param   poVideoDispatcher: pointer to Video Message Dispatcher
       **************************************************************************/
       t_Void vDispatchMsg(spi_tclDiPOVideoDispatcher* poDiscDispatcher);

      /***************************************************************************
       ** FUNCTION:  OnRequestUIMsg::vAllocateMsg()
       ***************************************************************************/
      /*!
       * \fn      vAllocateMsg()
       * \brief   Allocates memory for non trivial datatypes (ex STL containers)
       * \sa      vDeAllocateMsg
       **************************************************************************/
       t_Void vAllocateMsg();

      /***************************************************************************
       ** FUNCTION:  OnRequestUIMsg::vDeAllocateMsg()
       ***************************************************************************/
      /*!
       * \fn      vDeAllocateMsg()
       * \brief   Destroys memory allocated by vAllocateMsg()
       * \sa      vAllocateMsg
       **************************************************************************/
       t_Void vDeAllocateMsg();
};


/****************************************************************************/
/*!
* \class ProjVideoRenderingStatusMsg
* \brief Projection Video Rendering Status Msg
****************************************************************************/
class ProjVideoRenderingStatusMsg : public DiPOVideoMsgBase
{
public:
	tenProjVideoRenderingStatus enProjRenderingStatus;


   /***************************************************************************
   ** FUNCTION:  ProjVideoRenderingStatusMsg::ProjVideoRenderingStatusMsg()
   ***************************************************************************/
   /*!
   * \fn      ProjVideoRenderingStatusMsg()
   * \brief   Default constructor
   **************************************************************************/
   ProjVideoRenderingStatusMsg();

   /***************************************************************************
   ** FUNCTION:  ProjVideoRenderingStatusMsg::~ProjVideoRenderingStatusMsg()
   ***************************************************************************/
   /*!
   * \fn      ~ProjVideoRenderingStatusMsg()
   * \brief   ProjVideoRenderingStatusMsg
   **************************************************************************/
   virtual ~ProjVideoRenderingStatusMsg() {}

   /***************************************************************************
   ** FUNCTION:  ProjVideoRenderingStatusMsg::vDispatchMsg()
   ***************************************************************************/
   /*!
   * \fn      vDispatchMsg(spi_tclDiPOVideoDispatcher* poVideoDispatcher)
   * \brief   virtual function for dispatching the message of 'this' type
   * \param   poVideoDispatcher: pointer to Video Message Dispatcher
   **************************************************************************/
   t_Void vDispatchMsg(spi_tclDiPOVideoDispatcher* poVideoDispatcher);

   /***************************************************************************
   ** FUNCTION:  ProjVideoRenderingStatusMsg::vAllocateMsg()
   ***************************************************************************/
   /*!
   * \fn      vAllocateMsg()
   * \brief   Allocates memory for non trivial datatypes (ex STL containers)
   * \sa      vDeAllocateMsg
   **************************************************************************/
   t_Void vAllocateMsg();

   /***************************************************************************
   ** FUNCTION:  ProjVideoRenderingStatusMsg::vDeAllocateMsg()
   ***************************************************************************/
   /*!
   * \fn      vDeAllocateMsg()
   * \brief   Destroys memory allocated by vAllocateMsg()
   * \sa      vAllocateMsg
   **************************************************************************/
   t_Void vDeAllocateMsg();

};

/****************************************************************************/
/*!
* \class VideoPlaybackStatusMsg
* \brief Video Playback status msg
****************************************************************************/
class VideoPlaybackStatusMsg : public DiPOVideoMsgBase
{
public:
   t_Bool bIsPlaybackStarted;

   /***************************************************************************
   ** FUNCTION:  VideoPlaybackStatusMsg::VideoPlaybackStatusMsg()
   ***************************************************************************/
   /*!
   * \fn      VideoPlaybackStatusMsg()
   * \brief   Default constructor
   **************************************************************************/
	VideoPlaybackStatusMsg();

   /***************************************************************************
   ** FUNCTION:  VideoPlaybackStatusMsg::~VideoPlaybackStatusMsg()
   ***************************************************************************/
   /*!
   * \fn      ~VideoPlaybackStatusMsg()
   * \brief   VideoPlaybackStatusMsg
   **************************************************************************/
   virtual ~VideoPlaybackStatusMsg() {}

   /***************************************************************************
   ** FUNCTION:  VideoPlaybackStatusMsg::vDispatchMsg()
   ***************************************************************************/
   /*!
   * \fn      vDispatchMsg(spi_tclDiPOVideoDispatcher* poVideoDispatcher)
   * \brief   virtual function for dispatching the message of 'this' type
   * \param   poVideoDispatcher: pointer to Video Message Dispatcher
   **************************************************************************/
   t_Void vDispatchMsg(spi_tclDiPOVideoDispatcher* poVideoDispatcher);

   /***************************************************************************
   ** FUNCTION:  VideoPlaybackStatusMsg::vAllocateMsg()
   ***************************************************************************/
   /*!
   * \fn      vAllocateMsg()
   * \brief   Allocates memory for non trivial datatypes (ex STL containers)
   * \sa      vDeAllocateMsg
   **************************************************************************/
   t_Void vAllocateMsg();

   /***************************************************************************
   ** FUNCTION:  VideoPlaybackStatusMsg::vDeAllocateMsg()
   ***************************************************************************/
   /*!
   * \fn      vDeAllocateMsg()
   * \brief   Destroys memory allocated by vAllocateMsg()
   * \sa      vAllocateMsg
   **************************************************************************/
   t_Void vDeAllocateMsg();

};

/****************************************************************************/
/*!
 * \class spi_tclDiPOVideoDispatcher
 * \brief Message Dispatcher for Video Messages.implemented using
 *        double dispatch mechanism
 ****************************************************************************/
class spi_tclDiPOVideoDispatcher
{
   public:
      /***************************************************************************
       ** FUNCTION:  spi_tclDiPOVideoDispatcher::spi_tclDiPOVideoDispatcher
       ***************************************************************************/
      /*!
       * \fn      spi_tclDiPOVideoDispatcher()
       * \brief   Default constructor
       **************************************************************************/
      spi_tclDiPOVideoDispatcher();

      /***************************************************************************
       ** FUNCTION:  spi_tclDiPOVideoDispatcher::~spi_tclDiPOVideoDispatcher
       ***************************************************************************/
      /*!
       * \fn      ~spi_tclDiPOVideoDispatcher()
       * \brief   Destructor
       **************************************************************************/
      ~spi_tclDiPOVideoDispatcher();

      /***************************************************************************
       ** FUNCTION:  spi_tclDiPOVideoDispatcher::vHandleVideoMsg(...
       ***************************************************************************/
      /*!
       * \fn      vHandleVideoMsg(OnRequestUIMsg* poOnRequestUIMsg) const
       * \brief   Handles Messages of OnRequestUIMsg type
       * \param   poDeviceListMsg : pointer to DiPODeviceInfoMsg
       **************************************************************************/
      t_Void vHandleVideoMsg(OnRequestUIMsg* poOnRequestUIMsg)const;

      /***************************************************************************
      ** FUNCTION:  spi_tclDiPOVideoDispatcher::vHandleVideoMsg(....
       ***************************************************************************/
      /*!
      * \fn      vHandleVideoMsg(ProjVideoRenderingStatusMsg* poProjVideoRenderingStatusMsg) const
      * \brief   Handles Messages of ProjVideoRenderingStatusMsg type
      * \param   poProjVideoRenderingStatusMsg : pointer to ProjVideoRenderingStatusMsg
      **************************************************************************/
      t_Void vHandleVideoMsg(ProjVideoRenderingStatusMsg* poProjVideoRenderingStatusMsg)const;

      /***************************************************************************
      ** FUNCTION:  spi_tclDiPOVideoDispatcher::vHandleVideoMsg(...
      ***************************************************************************/
      /*!
      * \fn      vHandleVideoMsg(VideoPlaybackStatusMsg* poVideoPlaybackStatusMsg const
      * \brief   Handles Messages of VideoPlaybackStatusMsg type
      * \param   poVideoPlaybackStatusMsg : pointer to DisconnectDeviceRespMsg
      **************************************************************************/
      t_Void vHandleVideoMsg(VideoPlaybackStatusMsg* poVideoPlaybackStatusMsg)const;
      
};

#endif // _SPI_TCLDIPOVIDEODISPATCHER_H_

/////////////////////////////////////<EOF>//////////////////////////////////////////
