/***********************************************************************/
/*!
* \file  spi_tclDiPOSessionDispatcher.cpp
* \brief Message Dispatcher for Session Messages.
*************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Message Dispatcher for Session Messages.   
AUTHOR:         Shiva Kumar Gurija
COPYRIGHT:      &copy; RBEI

HISTORY:
Date        | Author                | Modification
09.12.2016  | Shiva Kumar Gurija    | Initial Version

\endverbatim
*************************************************************************/


/***************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |--------------------------------------------------------------------------*/
#include "SPITypes.h"
#include "DiPOTypes.h"
#include "StringHandler.h"
#include "RespRegister.h"
#include "spi_tclDiPOSessionDispatcher.h"
#include "spi_tclDiPORespSession.h"

//! Includes for Trace files
#include "Trace.h"
#ifdef TARGET_BUILD
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_MSGQTHREADER
#include "trcGenProj/Header/spi_tclDiPOSessionDispatcher.cpp.trc.h"
#endif
#endif

/******************************************************************************
| typedefs (scope: module-global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: local)
|----------------------------------------------------------------------------*/
#define DEFINE_DISPATCH_MESSAGE_FUNCTION(COMMAND,DISPATCHER)\
t_Void COMMAND::vDispatchMsg(DISPATCHER* poDispatcher)      \
{                                                           \
   if (NULL != poDispatcher)                                \
   {                                                        \
      poDispatcher->vHandleSessionMsg(this);                \
   }                                                        \
   vDeAllocateMsg();                                        \
}                                                           \

/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/

/***************************************************************************
 ** FUNCTION:  DiPOSessionMsgBase::DiPOSessionMsgBase()
 ***************************************************************************/
DiPOSessionMsgBase::DiPOSessionMsgBase(): m_u32DeviceHandle(0)
{
	vSetServiceID(e8_DIPO_WRAPPER_SESSION);
}

/***************************************************************************
 ** FUNCTION:  DiPOSessionMsgBase::u32GetDeviceHandle()
 ***************************************************************************/
t_U32 DiPOSessionMsgBase::u32GetDeviceHandle()
{
   return m_u32DeviceHandle;
}
/***************************************************************************
 ** FUNCTION:  DiPOSessionMsgBase::vSetDeviceHandle()
 ***************************************************************************/
t_Void DiPOSessionMsgBase::vSetDeviceHandle(t_U32 u32DevHndle)
{
   m_u32DeviceHandle = u32DevHndle;
}

/***************************************************************************
 ** FUNCTION:  DiPOSessionMsg::DiPOSessionMsg()
 ***************************************************************************/
DiPOSessionMsg::DiPOSessionMsg() :enDiPOSessionState(e8DIPO_SESSION_UNKNOWN), enSessionTransport(e8_DIPO_SESSION_TRANSPORT_USB)
{
   memset(szSessionIPAddress,'\0',DIPO_MAX_STR_LEN);
   vAllocateMsg();
}

/***************************************************************************
 ** FUNCTION:  DiPOSessionMsg::vDispatchMsg()
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(DiPOSessionMsg, spi_tclDiPOSessionDispatcher)

/***************************************************************************
 ** FUNCTION:  DiPOSessionMsg::vAllocateMsg()
 ***************************************************************************/
t_Void DiPOSessionMsg::vAllocateMsg(){}

/***************************************************************************
 ** FUNCTION:  DiPOSessionMsg::vDeAllocateMsg()
 ***************************************************************************/
t_Void DiPOSessionMsg::vDeAllocateMsg(){}

/***************************************************************************
 ** FUNCTION:  spi_tclDiPOSessionDispatcher::spi_tclDiPOSessionDispatcher()
 ***************************************************************************/
spi_tclDiPOSessionDispatcher::spi_tclDiPOSessionDispatcher()
{
   ETG_TRACE_USR1((" spi_tclDiPOSessionDispatcher::spi_tclDiPOSessionDispatcher()"));
}

/***************************************************************************
 ** FUNCTION:  spi_tclDiPOSessionDispatcher::~spi_tclDiPOSessionDispatcher()
 ***************************************************************************/
spi_tclDiPOSessionDispatcher::~spi_tclDiPOSessionDispatcher()
{
   ETG_TRACE_USR1((" spi_tclDiPOSessionDispatcher::~spi_tclDiPOSessionDispatcher()"));
}

/***************************************************************************
 ** FUNCTION:  spi_tclDiPOSessionDispatcher::vHandleSessionMsg(DiPOSessionMsg* poSessionMsg)
 ***************************************************************************/
t_Void spi_tclDiPOSessionDispatcher::vHandleSessionMsg(DiPOSessionMsg* poSessionMsg)const
{
   ETG_TRACE_USR1((" spi_tclDiPOSessionDispatcher::vHandleSessionMsg(DiPOSessionMsg* poSessionMsg)"));
   if (NULL != poSessionMsg) 
   {
      CALL_REG_OBJECTS(spi_tclDiPORespSession,
               e16DIPO_SESSION_REGID,
			   vOnSessionMsg(poSessionMsg->enDiPOSessionState,
			   poSessionMsg->enSessionTransport,
			   poSessionMsg->szSessionIPAddress));
   } // if (NULL != poSessionMsg)
}

/////////////////////////////////////<EOF>//////////////////////////////////////////
