
/***********************************************************************/
/*!
* \file  spi_tclDiPOCmdSession.h
* \brief Adapter class to send session data to CarPlayd process.
*************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Adapter class to send session data to CarPlayd process.
AUTHOR:         Rachana L Achar
COPYRIGHT:      &copy; RBEI

HISTORY:
Date        | Author                | Modification
16.02.2018  | Rachana L Achar       | Initial Version

\endverbatim
*************************************************************************/
#ifndef _SPI_TCLDIPOCMDSESSION_H_
#define _SPI_TCLDIPOCMDSESSION_H_


/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/

/******************************************************************************
| typedefs (scope: module-global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/

/****************************************************************************/
/*!
* \class spi_tclDiPOCmdSession
* \brief Adapter class to send Session data to CarPlayd  process
****************************************************************************/
class spi_tclDiPOCmdSession
{

public:

    /***************************************************************************
    *********************************PUBLIC*************************************
    ***************************************************************************/

    /***************************************************************************
    ** FUNCTION:  spi_tclDiPOCmdSession::spi_tclDiPOCmdSession()
    ***************************************************************************/
    /*!
    * \fn      spi_tclDiPOCmdSession()
    * \brief   Default Constructor
    * \param   t_Void
    * \sa      ~spi_tclDiPOCmdSession()
    **************************************************************************/
      spi_tclDiPOCmdSession();

    /***************************************************************************
    ** FUNCTION:  spi_tclDiPOCmdSession::~spi_tclDiPOCmdSession()
    ***************************************************************************/
    /*!
    * \fn      ~spi_tclDiPOCmdSession()
    * \brief   Destructor
    * \param   t_Void
    * \sa      spi_tclDiPOCmdSession()
    **************************************************************************/
    ~spi_tclDiPOCmdSession();

    /***************************************************************************
    ** FUNCTION:  t_Void spi_tclDiPOCmdSession::vSendLastModeData()
    ***************************************************************************/
    /*!
    * \fn      t_Void vSendLastModeData()
    * \brief   Adapter Interface to send last mode data to CarPlayd process
    * \retval  t_Void
    **************************************************************************/
    t_Void vSendLastModeData(t_Bool bAudioLastMode, t_Bool bDisplayLastMode);

    /***************************************************************************
    ** FUNCTION:  t_Void spi_tclDiPOCmdSession::vSetKeySupported()
    ***************************************************************************/
    /*!
    * \fn      t_Void vSetKeySupported()
    * \brief   Adapter Interface to send supported keys
    * \retval  t_Void
    **************************************************************************/
    t_Void vSetKeySupported(std::vector<t_U8> enConsumerKey,
                            std::vector<t_U8> enPhoneKey,
                            std::vector<t_U8> enKnobKey,
                            std::vector<t_U8> u8KeyMapBitValues,
                            std::vector<t_U8> u8TelKeyMapBitValues,
                            std::vector<t_U8> u8KnobKeyMapBitValues,
                            t_Bool bIsKnobDirectionalPadEnabled,
                            t_Bool bIsRotaryKnobSupported);

    /***************************************************************************
    ** FUNCTION:  t_Void spi_tclDiPOCmdSession::vOnLoadSettings()
    ***************************************************************************/
    /*!
    * \fn      t_Void vOnLoadSettings()
    * \brief   start carplayd settings on load
    * \retval  t_Void
    **************************************************************************/
    t_Void vOnLoadSettings();

    /***************************************************************************
    ** FUNCTION:  t_Void spi_tclDiPOCmdSession::vOnLoadSettingsCompleted()
    ***************************************************************************/
    /*!
    * \fn      t_Void vOnLoadSettingsCompleted()
    * \brief   start carplayd on load settings completed
    * \retval  t_Void
    **************************************************************************/
    t_Void vOnLoadSettingsCompleted();

    /***************************************************************************
    ** FUNCTION:  t_Void spi_tclDiPOCmdSession::vOnSaveSettings()
    ***************************************************************************/
    /*!
    * \fn      t_Void vOnSaveSettings()
    * \brief   stop carplayd settings on load
    * \retval  t_Void
    **************************************************************************/
    t_Void vOnSaveSettings();


    /***************************************************************************
    ****************************END OF PUBLIC***********************************
    ***************************************************************************/

protected:

    /***************************************************************************
    *********************************PROTECTED**********************************
    ***************************************************************************/

    /***************************************************************************
    ** FUNCTION:  spi_tclDiPOCmdSession(const spi_tclDiPOCmdInput...
    ***************************************************************************/
    /*!
    * \fn      spi_tclDiPOCmdSession(const spi_tclDiPOCmdInput& corfoSrc)
    * \brief   Copy constructor - Do not allow the creation of copy constructor
    * \param   corfoSrc : [IN] reference to source data interface object
    * \sa      spi_tclDiPOCmdSession()
    ***************************************************************************/
    spi_tclDiPOCmdSession(const spi_tclDiPOCmdSession& corfoSrc);


    /***************************************************************************
    ** FUNCTION:  spi_tclDiPOCmdSession& operator=( const spi_tclDiP...
    ***************************************************************************/
    /*!
    * \fn      spi_tclDiPOCmdSession& operator=(const spi_tclDiPOCmdInput& corfoSrc))
    * \brief   Assignment operator
    * \param   corfoSrc : [IN] reference to source data interface object
    * \sa      spi_tclDiPOCmdSession(const spi_tclDiPOCmdInput& otrSrc)
    ***************************************************************************/
    spi_tclDiPOCmdSession& operator=(const spi_tclDiPOCmdSession& corfoSrc);


    /***************************************************************************
    ****************************END OF PROTECTED********************************
    ***************************************************************************/

private:

    /***************************************************************************
    *********************************PRIVATE************************************
    ***************************************************************************/
    //! carplayd thread running status - true if CP thread is active, false otherwise
    t_Bool m_bIsCarPlayMainThreadActive;

    /***************************************************************************
    ****************************END OF PRIVATE *********************************
    ***************************************************************************/


}; //class spi_tclDiPOCmdSession

#endif //_SPI_TCLDIPOCMDSESSION_H_

/////////////////////////////////////<EOF>//////////////////////////////////////////
