/***********************************************************************/
/*!
* \file  spi_tclDiPORsrcMngrDispatcher.cpp
* \brief Message Dispatcher for Resource Manager Messages. 
*************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Message Dispatcher for Resource Manager Messages. 
AUTHOR:         Shiva Kumar Gurija
COPYRIGHT:      &copy; RBEI

HISTORY:
Date        | Author                | Modification
27.06.2017  | Shiva Kumar Gurija    | Initial Version

\endverbatim
*************************************************************************/


/***************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |--------------------------------------------------------------------------*/
#include "SPITypes.h"
#include "DiPOTypes.h"
#include "RespRegister.h"
#include "spi_tclDiPORsrcMngrDispatcher.h"
#include "spi_tclDiPORespRsrcMngr.h"

//! Includes for Trace files
#include "Trace.h"
#ifdef TARGET_BUILD
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_MSGQTHREADER
#include "trcGenProj/Header/spi_tclDiPORsrcMngrDispatcher.cpp.trc.h"
#endif
#endif

/******************************************************************************
| typedefs (scope: module-global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: local)
|----------------------------------------------------------------------------*/
#define DEFINE_DISPATCH_MESSAGE_FUNCTION(COMMAND,DISPATCHER)\
t_Void COMMAND::vDispatchMsg(DISPATCHER* poDispatcher)      \
{                                                           \
   if (NULL != poDispatcher)                                \
   {                                                        \
      poDispatcher->vHandleRsrcMngrMsg(this);              \
   }                                                        \
   vDeAllocateMsg();                                        \
}                                                           \

/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/

/***************************************************************************
 ** FUNCTION:  DiPORsrcMngrMsgBase::DiPORsrcMngrMsgBase()
 ***************************************************************************/
DiPORsrcMngrMsgBase::DiPORsrcMngrMsgBase(): m_u32DeviceHandle(0)
{
	vSetServiceID(e8_DIPO_WRAPPER_RSRCMNGR);
}

/***************************************************************************
 ** FUNCTION:  DiPORsrcMngrMsgBase::u32GetDeviceHandle()
 ***************************************************************************/
t_U32 DiPORsrcMngrMsgBase::u32GetDeviceHandle()
{
   return m_u32DeviceHandle;
}
/***************************************************************************
 ** FUNCTION:  DiPORsrcMngrMsgBase::vSetDeviceHandle()
 ***************************************************************************/
t_Void DiPORsrcMngrMsgBase::vSetDeviceHandle(t_U32 u32DevHndle)
{
   m_u32DeviceHandle = u32DevHndle;
}

/***************************************************************************
 ** FUNCTION:  DiPODeviceInfoMsg::DiPODeviceInfoMsg()
 ***************************************************************************/
ModesChangedMsg::ModesChangedMsg():prDiPOModeState(NULL)
{
   vAllocateMsg();
}

/***************************************************************************
 ** FUNCTION:  ModesChangedMsg::vDispatchMsg()
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(ModesChangedMsg, spi_tclDiPORsrcMngrDispatcher)

/***************************************************************************
 ** FUNCTION:  ModesChangedMsg::vAllocateMsg()
 ***************************************************************************/
t_Void ModesChangedMsg::vAllocateMsg()
{
   prDiPOModeState = new trDiPOModeState;
   SPI_NORMAL_ASSERT(NULL == prDiPOModeState);
}

/***************************************************************************
 ** FUNCTION:  ModesChangedMsg::vDeAllocateMsg()
 ***************************************************************************/
t_Void ModesChangedMsg::vDeAllocateMsg()
{
   RELEASE_MEM(prDiPOModeState);
}

/***************************************************************************
 ** FUNCTION:  spi_tclDiPORsrcMngrDispatcher::spi_tclDiPORsrcMngrDispatcher()
 ***************************************************************************/
spi_tclDiPORsrcMngrDispatcher::spi_tclDiPORsrcMngrDispatcher()
{
   ETG_TRACE_USR1((" spi_tclDiPORsrcMngrDispatcher::spi_tclDiPORsrcMngrDispatcher()"));
}

/***************************************************************************
 ** FUNCTION:  spi_tclDiPORsrcMngrDispatcher::~spi_tclDiPORsrcMngrDispatcher()
 ***************************************************************************/
spi_tclDiPORsrcMngrDispatcher::~spi_tclDiPORsrcMngrDispatcher()
{
   ETG_TRACE_USR1((" spi_tclDiPORsrcMngrDispatcher::~spi_tclDiPORsrcMngrDispatcher()"));
}

/***************************************************************************
 ** FUNCTION:  spi_tclDiPORsrcMngrDispatcher::vHandleDiscoveryMsg(ModesChangedMsg* poModesChangedMsg)
 ***************************************************************************/
t_Void spi_tclDiPORsrcMngrDispatcher::vHandleRsrcMngrMsg(ModesChangedMsg* poModesChangedMsg)const
{
   ETG_TRACE_USR1((" spi_tclDiPORsrcMngrDispatcher::vHandleRsrcMngrMsg(ModesChangedMsg* poModesChangedMsg)"));
   if ((NULL != poModesChangedMsg) && (NULL != poModesChangedMsg->prDiPOModeState))
   {
      CALL_REG_OBJECTS(spi_tclDiPORespRsrcMngr,
               e16DIPO_RSRCMNGR_REGID,
               vOnModesChangedUpdate(*(poModesChangedMsg->prDiPOModeState)));
   } // if (NULL != poDeviceListMsg)
}

/////////////////////////////////////<EOF>//////////////////////////////////////////
