/***********************************************************************/
/*!
* \file  spi_tclDiPOCmdRsrcMngr.h
* \brief Adapter class to send resource manager related events to CarPlayd process.
*************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Adapter class to send resource manager related events to CarPlayd process.
AUTHOR:         Shiva Kumar Gurija
COPYRIGHT:      &copy; RBEI

HISTORY:
Date        | Author                | Modification
26.06.2017  | Shiva Kumar Gurija    | Initial Version

\endverbatim
*************************************************************************/


/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/
#include "BaseTypes.h"
#include "IPCMessageQueue.h"
#include "SPITypes.h"
#include "DiPOTypes.h"
#include "DiPOWrapperTypes.h"
#include "spi_tclDiPOCmdRsrcMngr.h"

#include "spi_tclDiPOWrapperMsgQInterface.h"

//! Includes for Trace files
#include "Trace.h"
#ifdef TARGET_BUILD
   #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
      #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_DIPO
      #include "trcGenProj/Header/spi_tclDiPOCmdRsrcMngr.cpp.trc.h"
   #endif
#endif

/******************************************************************************
| typedefs (scope: module-global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/

/***************************************************************************
** FUNCTION:  spi_tclDiPOCmdRsrcMngr::spi_tclDiPOCmdRsrcMngr()
***************************************************************************/
spi_tclDiPOCmdRsrcMngr::spi_tclDiPOCmdRsrcMngr():m_bAudioCtxtRequestedbyCar(false)
{
   ETG_TRACE_USR1(("spi_tclDiPOCmdRsrcMngr::spi_tclDiPOCmdRsrcMngr()"));
}

/***************************************************************************
** FUNCTION:  spi_tclDiPOCmdRsrcMngr::~spi_tclDiPOCmdRsrcMngr()
***************************************************************************/
spi_tclDiPOCmdRsrcMngr::~spi_tclDiPOCmdRsrcMngr()
{
   ETG_TRACE_USR1(("spi_tclDiPOCmdRsrcMngr::~spi_tclDiPOCmdRsrcMngr()"));
}

/***************************************************************************
** FUNCTION:  t_Bool spi_tclDiPOCmdRsrcMngr::bSetAccDisplayCntxt(...
***************************************************************************/
t_Bool spi_tclDiPOCmdRsrcMngr::bSetAccDisplayCntxt(const trDiPOVideoContext& corfrDiPOVideoContext)
{
   ETG_TRACE_USR1(("spi_tclDiPOCmdRsrcMngr::bSetAccDisplayCntxt():Video context:%d,TransferType:%d,TransferPriority:%d,TakeConstraint:%d,BorroConstraint:%d, BorrowId:%s",
   corfrDiPOVideoContext.enDisplayContext,ETG_ENUM(DIPO_TRANSFERTYPE,corfrDiPOVideoContext.enTransferType),ETG_ENUM(DIPO_TRANSFERPRIO,corfrDiPOVideoContext.enTransferPriority),
   ETG_ENUM(DIPO_CONSTRAINT,corfrDiPOVideoContext.enTakeConstraint),ETG_ENUM(DIPO_CONSTRAINT,corfrDiPOVideoContext.enBorrowConstraint), corfrDiPOVideoContext.szBorrowId));
   
   t_Bool bMessageSentStatus = false;
   
   trAccVideoContextMsg oAccVideoContextMsg;
   oAccVideoContextMsg.enMsgType = e8RM_VIDEO_RQST_MESSAGE;
   oAccVideoContextMsg.rDiPOVideoContext = const_cast<trDiPOVideoContext&>(corfrDiPOVideoContext);

   spi_tclDiPOWrapperMsgQInterface* p_DiPOWrapperMsgQInterface = spi_tclDiPOWrapperMsgQInterface::getInstance();
   if(p_DiPOWrapperMsgQInterface)
   {
       bMessageSentStatus = p_DiPOWrapperMsgQInterface->bWriteMsgToQ(&oAccVideoContextMsg, sizeof(trAccVideoContextMsg));
       ETG_TRACE_USR2(("[PARAM]:spi_tclDiPOCmdRsrcMngr::bSetAccDisplayCntxt - Message send status : %d",ETG_ENUM(BOOL,bMessageSentStatus)));
   }
   
   return bMessageSentStatus;
}


/***************************************************************************
** FUNCTION:  t_Bool spi_tclDiPOCmdRsrcMngr::bSetAccAudioCntxt(...
***************************************************************************/
t_Bool spi_tclDiPOCmdRsrcMngr::bSetAccAudioCntxt(const trDiPOAudioContext& corfrDiPOAudioContext)
{
   ETG_TRACE_USR1(("spi_tclDiPOCmdRsrcMngr::bSetAccAudioCntxt():Audio context:%d,TransferType:%d,TransferPriority:%d,TakeConstraint:%d,BorroConstraint:%d, BorrowId:%s",
   corfrDiPOAudioContext.enAudioContext,ETG_ENUM(DIPO_TRANSFERTYPE,corfrDiPOAudioContext.enTransferType),ETG_ENUM(DIPO_TRANSFERPRIO,corfrDiPOAudioContext.enTransferPriority),
   ETG_ENUM(DIPO_CONSTRAINT,corfrDiPOAudioContext.enTakeConstraint),ETG_ENUM(DIPO_CONSTRAINT,corfrDiPOAudioContext.enBorrowConstraint), corfrDiPOAudioContext.szBorrowId));
   
   t_Bool bMessageSentStatus = false;
   
   trAccAudioContextMsg oAccAudioContextMsg;
   oAccAudioContextMsg.enMsgType = e8RM_AUDIO_RQST_MESSAGE;
   oAccAudioContextMsg.rDiPOAudioContext = const_cast<trDiPOAudioContext&>(corfrDiPOAudioContext);

   spi_tclDiPOWrapperMsgQInterface* p_DiPOWrapperMsgQInterface = spi_tclDiPOWrapperMsgQInterface::getInstance();
   if(p_DiPOWrapperMsgQInterface)
   {
       bMessageSentStatus = p_DiPOWrapperMsgQInterface->bWriteMsgToQ(&oAccAudioContextMsg, sizeof(trAccAudioContextMsg));
       ETG_TRACE_USR2(("[PARAM]:spi_tclDiPOCmdRsrcMngr::bSetAccAudioCntxt - Message send status : %d",ETG_ENUM(BOOL,bMessageSentStatus)));
   }
   
   return bMessageSentStatus;
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclDiPOCmdRsrcMngr::vSetAppState(...
***************************************************************************/
t_Void spi_tclDiPOCmdRsrcMngr::vSetAppState(const trDiPOAppState& corfrDiPOAppState)
{
   ETG_TRACE_USR1(("sspi_tclDiPOCmdRsrcMngr::vSetAppState:Speech State:%d,Phone State:%d,NavState:%d",
   ETG_ENUM(SR_STATUS,corfrDiPOAppState.enSpeechAppState),ETG_ENUM(PHONE_APP_STATE,corfrDiPOAppState.enPhoneAppState),
   ETG_ENUM(NAV_APP_STATE,corfrDiPOAppState.enNavAppState)));

   trAccAppStateMsg oAccAppStateMsg;
   oAccAppStateMsg.enMsgType = e8RM_APP_STATE_MESSAGE;
   oAccAppStateMsg.rDiPOAppState = const_cast<trDiPOAppState&>(corfrDiPOAppState);

   spi_tclDiPOWrapperMsgQInterface* p_DiPOWrapperMsgQInterface = spi_tclDiPOWrapperMsgQInterface::getInstance();
   if(p_DiPOWrapperMsgQInterface)
   {
       t_Bool bMessageSentStatus = p_DiPOWrapperMsgQInterface->bWriteMsgToQ(&oAccAppStateMsg, sizeof(trAccAppStateMsg));
       ETG_TRACE_USR2(("[PARAM]:spi_tclDiPOCmdRsrcMngr::vSetAppState - Message send status : %d",ETG_ENUM(BOOL,bMessageSentStatus)));
   }
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclDiPOCmdRsrcMngr::vSendInfoMsg...
***************************************************************************/
t_Void spi_tclDiPOCmdRsrcMngr::vSendInfoMsg(t_String szBtMacAddr,
                                        const trVehicleConfigData& corfrVehicleConfigData,
                                        t_U8 u8DriveRestrictionInfo,
                                        tenVehicleConfiguration enDriveModeInfo,
                                        tenVehicleConfiguration enNightModeInfo,
                                        t_U8 u8DisplayInput)
{
   ETG_TRACE_USR1(("spi_tclDiPOCmdRsrcMngr::vSendInfoMsg"));

   trDiPOInfoMessage oInfoMsg;
      oInfoMsg.enMsgType = e8INFO_MESSAGE;

      oInfoMsg.rVehicleConfigData = const_cast<trVehicleConfigData&>(corfrVehicleConfigData);


      strncpy((oInfoMsg.rVehicleConfigData.rVehicleBrandInfo).szOemIconPath,
               corfrVehicleConfigData.rVehicleBrandInfo.szOemIconPath, MAX_STR_LEN);

      ETG_TRACE_USR2(("[PARAM]:spi_tclDiPOCmdRsrcMngr::vSendInfoMsg:OEM Icon path:%s",
               (oInfoMsg.rVehicleConfigData.rVehicleBrandInfo).szOemIconPath));

      strncpy((oInfoMsg.rVehicleConfigData.rVehicleBrandInfo).szOemName,
               corfrVehicleConfigData.rVehicleBrandInfo.szOemName,
               MAX_STR_LEN);

      ETG_TRACE_USR2(("[PARAM]:spi_tclDiPOCmdRsrcMngr::vSendInfoMsg:OEM Name:%s",
               (oInfoMsg.rVehicleConfigData.rVehicleBrandInfo).szOemName));

      strncpy((oInfoMsg.rVehicleConfigData).szFirmwareRevision,
               corfrVehicleConfigData.szFirmwareRevision,
               MAX_STR_LEN);
      ETG_TRACE_USR2(("[PARAM]:spi_tclDiPOCmdRsrcMngr::vSendInfoMsg:Firmware version:%s",
               (oInfoMsg.rVehicleConfigData).szFirmwareRevision));

      strncpy((oInfoMsg.rVehicleConfigData).szHardwareRevision,
               corfrVehicleConfigData.szHardwareRevision,
               MAX_STR_LEN);

      ETG_TRACE_USR2(("[PARAM]:spi_tclDiPOCmdRsrcMngr::vSendInfoMsg:Hardware version:%s",
               (oInfoMsg.rVehicleConfigData).szHardwareRevision));

      oInfoMsg.rVehicleConfigData.rExtendedFeaturesSupport.bEnhancedRequestUISupport = corfrVehicleConfigData.rExtendedFeaturesSupport.bEnhancedRequestUISupport;
      ETG_TRACE_USR2(("[PARAM]:spi_tclDiPOCmdRsrcMngr::vSendInfoMsg:Enhanced Request UI support: %d",
               ETG_ENUM(BOOL, (oInfoMsg.rVehicleConfigData).rExtendedFeaturesSupport.bEnhancedRequestUISupport)));

      oInfoMsg.rVehicleConfigData.rExtendedFeaturesSupport.bVocoderInfoSupport = corfrVehicleConfigData.rExtendedFeaturesSupport.bVocoderInfoSupport;
      ETG_TRACE_USR2(("[PARAM]:spi_tclDiPOCmdRsrcMngr::vSendInfoMsg:Vocoder info support: %d",
               ETG_ENUM(BOOL, (oInfoMsg.rVehicleConfigData).rExtendedFeaturesSupport.bVocoderInfoSupport)));

      oInfoMsg.u8DriveRestrictionInfo = u8DriveRestrictionInfo;
      oInfoMsg.enDriveModeInfo = enDriveModeInfo;
      oInfoMsg.enNightModeInfo = enNightModeInfo;
      oInfoMsg.u8DisplayInput = u8DisplayInput;
	  
	  ETG_TRACE_USR4(("[PARAM]:spi_tclDiPOCmdRsrcMngr::vSendInfoMsg:Driving mode:%d, DayNight mode:%d, DiplayInput Type:%d, Drive restrictioninfo:%d",
                ETG_ENUM(VEHICLE_MODE,oInfoMsg.enDriveModeInfo),ETG_ENUM(VEHICLE_MODE,oInfoMsg.enNightModeInfo),ETG_ENUM(DIPO_DISPLAY_INPUT_TYPE,oInfoMsg.u8DisplayInput),
				u8DriveRestrictionInfo));

      if (szBtMacAddr.length() < DIPO_MAX_STR_LEN)
      {
         strncpy(oInfoMsg.szBtMacAdress, szBtMacAddr.c_str(), DIPO_MAX_STR_LEN);
         ETG_TRACE_USR2(("[PARAM]:spi_tclDiPOCmdRsrcMngr::vSendInfoMsg:BT MAC Address:%s",
                oInfoMsg.szBtMacAdress));
      }
      else
      {
         ETG_TRACE_ERR(("[ERR]:spi_tclDiPOCmdRsrcMngr::vSendInfoMsg:Received BT Address seems to be invalid. Length is more than defined."));
      }

      spi_tclDiPOWrapperMsgQInterface* p_DiPOWrapperMsgQInterface = spi_tclDiPOWrapperMsgQInterface::getInstance();
      if(p_DiPOWrapperMsgQInterface)
      {
          t_Bool bMessageSentStatus = p_DiPOWrapperMsgQInterface->bWriteMsgToQ(&oInfoMsg, sizeof(trDiPOInfoMessage));
          ETG_TRACE_USR1(("[PARAM]::spi_tclDiPOCmdRsrcMngr::vSendInfoMsg - Message send status : %d",ETG_ENUM(BOOL,bMessageSentStatus)));
      }
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclDiPOCmdRsrcMngr::vSetETCStatus...
***************************************************************************/
t_Void spi_tclDiPOCmdRsrcMngr::vSetETCStatus(const tenETCInfo enETCStatus)
{
     ETG_TRACE_USR1(("spi_tclDiPOCmdRsrcMngr::vSetETCStatus() Entered"));
     ETG_TRACE_USR2(("[PARAM]::spi_tclDiPOCmdRsrcMngr::vSetETCStatus -ETC Status : %d",ETG_ENUM(ETC_SUPPORT,enETCStatus)));

     trETCStatusMsg oETCStatusMsg;
     oETCStatusMsg.enMsgType = e8ETC_STATUS_MESSAGE;
     oETCStatusMsg.enETCSupport = enETCStatus;

     spi_tclDiPOWrapperMsgQInterface* p_DiPOWrapperMsgQInterface = spi_tclDiPOWrapperMsgQInterface::getInstance();
     if(p_DiPOWrapperMsgQInterface)
     {
         t_Bool bMessageSentStatus = p_DiPOWrapperMsgQInterface->bWriteMsgToQ(&oETCStatusMsg, sizeof(trETCStatusMsg));
         ETG_TRACE_USR2(("[PARAM]::spi_tclDiPOCmdRsrcMngr::vSetETCStatus - Message send status : %d",ETG_ENUM(BOOL,bMessageSentStatus)));
     }
     ETG_TRACE_USR1(("spi_tclDiPOCmdRsrcMngr::vSetETCStatus() left"));
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclDiPOCmdRsrcMngr::vSetAudioCtxtRequestedbyCar(...
***************************************************************************/
t_Void spi_tclDiPOCmdRsrcMngr::vSetAudioCtxtRequestedbyCar(const t_Bool bIsAudCtxRequested)
{
    ETG_TRACE_USR2(("[PARAM]::spi_tclDiPOCmdRsrcMngr::vSetAudioCtxtRequestedbyCar - bIsAudCtxRequested : %d",ETG_ENUM(BOOL, bIsAudCtxRequested)));
    m_bAudioCtxtRequestedbyCar = bIsAudCtxRequested;
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclDiPOCmdRsrcMngr::bIsAudioCtxtRequestedbyCar(...
***************************************************************************/
t_Bool spi_tclDiPOCmdRsrcMngr::bIsAudioCtxtRequestedbyCar()
{
    ETG_TRACE_USR2(("[PARAM]::spi_tclDiPOCmdRsrcMngr::bIsAudioCtxtRequestedbyCar - m_bAudioCtxtRequestedbyCar : %d",ETG_ENUM(BOOL, m_bAudioCtxtRequestedbyCar)));
    return m_bAudioCtxtRequestedbyCar;
}

//TODO - not available in git, but available in clearcase F40
/***************************************************************************
** FUNCTION:  t_Void spi_tclDiPOCmdRsrcMngr::vSetBTMediaDeviceInfo...
***************************************************************************/
/*t_Void spi_tclDiPOCmdRsrcMngr::vSetBTMediaDeviceInfo(const trMediaDeviceInfo& corfrMediaDeviceInfo)
{
    ETG_TRACE_USR1(("spi_tclDiPOCmdRsrcMngr::vSetBTMediaDeviceInfo() Entered"));


    //Create buffer
    trBTMediaDevInfoMsg orBTMediaDevInfoMsg;
    orBTMediaDevInfoMsg.bIsConnected = corfrMediaDeviceInfo.bIsConnected;
    orBTMediaDevInfoMsg.bIsMediaPlaying = corfrMediaDeviceInfo.bIsMediaPlaying;
    strncpy(orBTMediaDevInfoMsg.szBTMACAddress,corfrMediaDeviceInfo.szBTMACAddress.c_str(),MAX_STR_LEN-1);
    orBTMediaDevInfoMsg.u32DevID = corfrMediaDeviceInfo.u32DevID;
    orBTMediaDevInfoMsg.enMsgType = e8BTMEDIADEVINFO_MESSAGE;

    spi_tclDiPOWrapperMsgQInterface* p_DiPOWrapperMsgQInterface = spi_tclDiPOWrapperMsgQInterface::getInstance();
    if(p_DiPOWrapperMsgQInterface)
    {
        t_Bool bMessageSentStatus = p_DiPOWrapperMsgQInterface->bWriteMsgToQ(&orBTMediaDevInfoMsg, sizeof(trBTMediaDevInfoMsg));
        ETG_TRACE_USR2(("[PARAM]::spi_tclDiPOCmdRsrcMngr::vSetETCStatus - Message send status : %d",ETG_ENUM(BOOL,bMessageSentStatus)));
    }
}*/

/////////////////////////////////////<EOF>//////////////////////////////////////////
