/***********************************************************************/
/*!
* \file  spi_tclDiPORespRsrcMngr.h
* \brief DiPO Resource Manager Interface
*************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    DiPO Resource Manager Interface
AUTHOR:         Shiva Kumar Gurija
COPYRIGHT:      &copy; RBEI

HISTORY:
Date        | Author                | Modification
09.03.2016  | Shiva Kumar Gurija    | Initial Version

\endverbatim
*************************************************************************/
#ifndef _SPI_TCLDIPORESPRSRCMNGR_H_
#define _SPI_TCLDIPORESPRSRCMNGR_H_


/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/
#include "RespBase.h"
#include "RespRegister.h"
#include "DiPOTypes.h"

/******************************************************************************
| typedefs (scope: module-global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/


/****************************************************************************/
/*!
* \class spi_tclDiPORespRsrcMngr
* \brief DiPO Resource Manager Interface
*
* It provides an interface to SPI, To register for the Audio
* status updates and updates all the registered clients, whenever there is
* an update.
*
****************************************************************************/
class spi_tclDiPORespRsrcMngr:public RespBase
{
public:

   /***************************************************************************
   *********************************PUBLIC*************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  spi_tclDiPORespRsrcMngr::spi_tclDiPORespRsrcMngr()
   ***************************************************************************/
   /*!
   * \fn      spi_tclDiPORespRsrcMngr()
   * \brief   Constructor
   * \sa      ~spi_tclDiPORespRsrcMngr()
   **************************************************************************/
   spi_tclDiPORespRsrcMngr():RespBase(e16DIPO_RSRCMNGR_REGID){}

   /***************************************************************************
   ** FUNCTION:  spi_tclDiPORespRsrcMngr::~spi_tclDiPORespRsrcMngr()
   ***************************************************************************/
   /*!
   * \fn      virtual ~spi_tclDiPORespRsrcMngr()
   * \brief   Destructor
   * \param   t_Void
   * \sa      spi_tclDiPORespRsrcMngr(RegID enRegId)
   **************************************************************************/
   virtual ~spi_tclDiPORespRsrcMngr(){}

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclDiPORespRsrcMngr::vOnModesChangedUpdate(...
   ***************************************************************************/
   /*!
   * \fn      virtual t_Void vOnModesChangedUpdate(
   *                       const trDiPOModeState& corfrDiPOModeState)
   * \brief   To Post the ModesChanged update from Phone
   * \param   corfrDiPOModeState : [IN] Mode states
   * \retval  t_Void
   ***************************************************************************/
   virtual t_Void vOnModesChangedUpdate(const trDiPOModeState& /*corfrDiPOModeState*/){}

   /***************************************************************************
   ****************************END OF PUBLIC***********************************
   ***************************************************************************/

protected:

   /***************************************************************************
   *********************************PROTECTED**********************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  spi_tclDiPORespRsrcMngr::spi_tclDiPORespRsrcMngr()
   ***************************************************************************/
   /*!
   * \fn      spi_tclDiPORespRsrcMngr(const spi_tclDiPORespRsrcMngr& corfoSrc))
   * \brief   Parameterized Constructor
   * \param   corfoSrc : [IN] reference to source data interface object
   * \sa      spi_tclDiPORespRsrcMngr(RegID enRegId)
   **************************************************************************/
   spi_tclDiPORespRsrcMngr(const spi_tclDiPORespRsrcMngr& corfoSrc);

   /***************************************************************************
   ** FUNCTION:  spi_tclDiPORespRsrcMngr& operator=( const  spi_tclDiPO...
   ***************************************************************************/
   /*!
   * \fn      spi_tclDiPORespRsrcMngr& operator=(const spi_tclDiPORespRsrcMngr& corfoSrc))
   * \brief   Assignment operator
   * \param   corfoSrc : [IN] reference to source data interface object
   * \retval
   * \sa      spi_tclDiPORespRsrcMngr(const spi_tclDiPORespRsrcMngr& otrSrc)
   ***************************************************************************/
   spi_tclDiPORespRsrcMngr& operator=(const spi_tclDiPORespRsrcMngr& corfoSrc);


   /***************************************************************************
   ****************************END OF PROTECTED********************************
   ***************************************************************************/

private:

   /***************************************************************************
   *********************************PRIVATE************************************
   ***************************************************************************/


   /***************************************************************************
   ****************************END OF PRIVATE *********************************
   ***************************************************************************/

};


#endif //_SPI_TCLDIPORESPRSRCMNGR_H_

/////////////////////////////////////<EOF>//////////////////////////////////////////

