
/***********************************************************************/
/*!
* \file  spi_tclDiPOCmdRsrcMngr.h
* \brief Adapter class to send resource manager related events to CarPlayd process.
*************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Adapter class to send resource manager related events to CarPlayd process.
AUTHOR:         Shiva Kumar Gurija
COPYRIGHT:      &copy; RBEI

HISTORY:
Date        | Author                | Modification
26.06.2017  | Shiva Kumar Gurija    | Initial Version

\endverbatim
*************************************************************************/
#ifndef _SPI_TCLDIPOCMDRSRCMNGR_H_
#define _SPI_TCLDIPOCMDRSRCMNGR_H_


/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/
#include "ExtInterfacesTypes.h"

/******************************************************************************
| typedefs (scope: module-global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/

/****************************************************************************/
/*!
* \class spi_tclDiPOCmdRsrcMngr
* \brief Adapter class to send resource manager related events to CarPlayd process.
****************************************************************************/
class spi_tclDiPOCmdRsrcMngr
{

public:

    /***************************************************************************
    *********************************PUBLIC*************************************
    ***************************************************************************/

    /***************************************************************************
    ** FUNCTION:  spi_tclDiPOCmdRsrcMngr::spi_tclDiPOCmdRsrcMngr()
    ***************************************************************************/
    /*!
    * \fn      spi_tclDiPOCmdRsrcMngr()
    * \brief   Default Constructor
    * \param   t_Void
    * \sa      ~spi_tclDiPOCmdRsrcMngr()
    **************************************************************************/
    spi_tclDiPOCmdRsrcMngr();

    /***************************************************************************
    ** FUNCTION:  spi_tclDiPOCmdRsrcMngr::~spi_tclDiPOCmdRsrcMngr()
    ***************************************************************************/
    /*!
    * \fn      ~spi_tclDiPOCmdRsrcMngr()
    * \brief   Destructor
    * \param   t_Void
    * \sa      spi_tclDiPOCmdRsrcMngr()
    **************************************************************************/
    ~spi_tclDiPOCmdRsrcMngr();

    /***************************************************************************
    ** FUNCTION:  t_Bool spi_tclDiPOCmdRsrcMngr::bSetAccDisplayCntxt(...
    ***************************************************************************/
    /*!
    * \fn      t_Bool bSetAccDisplayCntxt(const trDiPOVideoContext& corfrDiPOVideoContext)
    * \brief   Adapter Interface to send display context update to CarPlayd process
    * \param   corfrDiPOVideoContext : [IN] Display context information
    * \retval  t_Bool
    **************************************************************************/
    t_Bool bSetAccDisplayCntxt(const trDiPOVideoContext& corfrDiPOVideoContext);

    /***************************************************************************
    ** FUNCTION:  t_Bool spi_tclDiPOCmdRsrcMngr::bSetAccAudioCntxt(...
    ***************************************************************************/
    /*!
    * \fn      t_Bool bSetAccAudioCntxt(const trDiPOAudioContext& corfrDiPOAudioContext)
    * \param   corfrDiPOAudioContext : [IN] Display context information
    * \retval  t_Bool
    **************************************************************************/
    t_Bool bSetAccAudioCntxt(const trDiPOAudioContext& corfrDiPOAudioContext);

    /***************************************************************************
    ** FUNCTION:  t_Void spi_tclDiPOCmdRsrcMngr::vSetAppState...
    ***************************************************************************/
    /*!
    * \fn      t_Void vSetAppState(const trDiPOAppState& corfrDiPOAppState)
    * \brief   Adapter Interface to send app state to CarPlayd process
    * \param   corfrDiPOAppState : [IN] current app state (Speech,Navigation & Phone)
    * \retval  t_Void
    **************************************************************************/
    t_Void vSetAppState(const trDiPOAppState& corfrDiPOAppState);
	
    /***************************************************************************
    ** FUNCTION:  t_Void spi_tclDiPOCmdRsrcMngr::vSendInfoMsg...
    ***************************************************************************/
    /*!
    * \fn      t_Void vSetAppState(t_String szBtMacAddr,
	*            const trVehicleConfigData& corfrVehicleConfigData,t_U8 u8DriveRestrictionInfo,
	*            tenVehicleConfiguration enDriveModeInfo,tenVehicleConfiguration enNightModeInfo,
	*            t_U8 u8DisplayInput)
    * \brief   Adapter Interface to send info message to CarPlayd process
    * \param   szBtMacAddr : [IN] unique device identifier
    * \param   corfrVehicleConfigData : [IN] vehicle configuration data (display info)
    * \param   u8DriveRestrictionInfo : [IN] Restrictions to be enabled in drive mode
    * \param   enDriveModeInfo : [IN] Park/Drive Mode
    * \param   enNightModeInfo : [IN] Day/Night mode
    * \param   u8DisplayInput  : [IN] Display input type
    * \retval  t_Void
    **************************************************************************/	
	t_Void vSendInfoMsg(t_String szBtMacAddr,
      const trVehicleConfigData& corfrVehicleConfigData,
      t_U8 u8DriveRestrictionInfo,
      tenVehicleConfiguration enDriveModeInfo,
      tenVehicleConfiguration enNightModeInfo,
      t_U8 u8DisplayInput);

    /***************************************************************************
    ** FUNCTION:  t_Void spi_tclDiPOCmdRsrcMngr::vSetETCStatus...
    ***************************************************************************/
    /*!
    * \fn      t_Void vSetETCStatus(const t_Bool enETCStatus)
    * \brief   Adapter Interface to send ETC Status to CarPlayd process
    * \param   enETCStatus : [IN] ETC Status(Enabled or Disabled)
    * \retval  t_Void
    **************************************************************************/
    t_Void vSetETCStatus(const tenETCInfo enETCStatus);

    /***************************************************************************
    ** FUNCTION:  t_Void spi_tclDiPOCmdRsrcMngr::vSetAudioCtxtRequestedbyCar...
    ***************************************************************************/
    /*!
    * \fn      t_Void vSetAudioCtxtRequestedbyCar(const t_Bool bIsAudCtxRequested)
    * \brief   to set the accessory audio context flag to keep track, if requested by head unit
    * \param   bIsAudCtxRequested : [IN] bIsAudCtxRequested(Enabled or Disabled)
    * \retval  t_Void
    **************************************************************************/
    t_Void vSetAudioCtxtRequestedbyCar(const t_Bool bIsAudCtxRequested);

    /***************************************************************************
     ** FUNCTION:  t_Bool spi_tclDiPoAudio::bIsAudioCtxtRequestedbyCar()
     ***************************************************************************/
    /*!
     * \fn      bIsAudioCtxtRequestedbyCar()
     * \brief   get the current accessory audio context flag value,
     *          to evaluate whether audio context has been requested by head unit.
     * \retval  Bool value
     **************************************************************************/
    t_Bool bIsAudioCtxtRequestedbyCar();

    /***************************************************************************
    ****************************END OF PUBLIC***********************************
    ***************************************************************************/

protected:

    /***************************************************************************
    *********************************PROTECTED**********************************
    ***************************************************************************/

    /***************************************************************************
    ** FUNCTION:  spi_tclDiPOCmdRsrcMngr(const spi_tclDiPOCmdRsrcMngr...
    ***************************************************************************/
    /*!
    * \fn      spi_tclDiPOCmdRsrcMngr(const spi_tclDiPOCmdRsrcMngr& corfoSrc)
    * \brief   Copy constructor - Do not allow the creation of copy constructor
    * \param   corfoSrc : [IN] reference to source data interface object
    * \sa      spi_tclDiPOCmdRsrcMngr()
    ***************************************************************************/
    spi_tclDiPOCmdRsrcMngr(const spi_tclDiPOCmdRsrcMngr& corfoSrc);


    /***************************************************************************
    ** FUNCTION:  spi_tclDiPOCmdRsrcMngr& operator=( const spi_tclDiP...
    ***************************************************************************/
    /*!
    * \fn      spi_tclDiPOCmdRsrcMngr& operator=(const spi_tclDiPOCmdRsrcMngr& corfoSrc))
    * \brief   Assignment operator
    * \param   corfoSrc : [IN] reference to source data interface object
    * \sa      spi_tclDiPOCmdRsrcMngr(const spi_tclDiPOCmdRsrcMngr& otrSrc)
    ***************************************************************************/
    spi_tclDiPOCmdRsrcMngr& operator=(const spi_tclDiPOCmdRsrcMngr& corfoSrc);


    /***************************************************************************
    ****************************END OF PROTECTED********************************
    ***************************************************************************/

private:

    /***************************************************************************
    *********************************PRIVATE************************************
    ***************************************************************************/

    //! Stores true if audio context requested by IHU(voice mail feature)
    t_Bool m_bAudioCtxtRequestedbyCar;
    /***************************************************************************
    ****************************END OF PRIVATE *********************************
    ***************************************************************************/


}; //class spi_tclDiPOCmdRsrcMngr

#endif //_SPI_TCLDIPOCMDRSRCMNGR_H_

/////////////////////////////////////<EOF>//////////////////////////////////////////
