/***********************************************************************/
/*!
* \file  spi_tclDiPOCmdInput.cpp
* \brief Adapter class to send touch & key requests to CarPlayd process.
*************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Adapter class to send touch & key requests to CarPlayd process.
AUTHOR:         Shiva Kumar Gurija
COPYRIGHT:      &copy; RBEI

HISTORY:
Date        | Author                | Modification
26.06.2017  | Shiva Kumar Gurija    | Initial Version

\endverbatim
*************************************************************************/


/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/
#include "BaseTypes.h"
#include "IPCMessageQueue.h"
#include "SPITypes.h"
#include "DiPOTypes.h"
#include "DiPOWrapperTypes.h"
#include "spi_tclDiPOCmdInput.h"

#include "spi_tclDiPOWrapperMsgQInterface.h"

//! Includes for Trace files
#include "Trace.h"
#ifdef TARGET_BUILD
   #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
      #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_DIPO
      #include "trcGenProj/Header/spi_tclDiPOCmdInput.cpp.trc.h"
   #endif
#endif

/******************************************************************************
| typedefs (scope: module-global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/


/***************************************************************************
** FUNCTION:  spi_tclDiPOCmdInput::spi_tclDiPOCmdInput()
***************************************************************************/
spi_tclDiPOCmdInput::spi_tclDiPOCmdInput()
{
   ETG_TRACE_USR1(("spi_tclDiPOCmdInput::spi_tclDiPOCmdInput()"));
}

/***************************************************************************
** FUNCTION:  spi_tclDiPOCmdInput::~spi_tclDiPOCmdInput()
***************************************************************************/
spi_tclDiPOCmdInput::~spi_tclDiPOCmdInput()
{
   ETG_TRACE_USR1(("spi_tclDiPOCmdInput::~spi_tclDiPOCmdInput()"));
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclDiPOCmdInput::vSendKeyEvent()
***************************************************************************/
t_Void spi_tclDiPOCmdInput::vSendKeyEvent(tenKeyMode enKeyMode,
         tenKeyCode enKeyCode,
         tenKeyType enKeyType,
         t_S8 s8KnobEncoderDeltaCnt)
{
   ETG_TRACE_USR1(("spi_tclDiPOCmdInput::vSendKeyEvent():Key Mode:%d, Key Code:%d, KeyType:%d,Knob Encoder delta cnt:%d",
   ETG_ENUM(KEY_MODE,enKeyMode),ETG_ENUM(KEY_CODE,enKeyCode),ETG_ENUM(KEY_TYPE,enKeyType),s8KnobEncoderDeltaCnt));

   trKeyMsg oKeyMsg;
   oKeyMsg.enMsgType = e8KEY_MESSAGE;
   oKeyMsg.enKeyMode = enKeyMode;
   oKeyMsg.enKeyCode = enKeyCode;
   oKeyMsg.enKeyType = enKeyType;
   oKeyMsg.s8EncoderDeltaCnt = s8KnobEncoderDeltaCnt;

   spi_tclDiPOWrapperMsgQInterface* p_DiPOWrapperMsgQInterface = spi_tclDiPOWrapperMsgQInterface::getInstance();
   if(p_DiPOWrapperMsgQInterface)
   {
       t_Bool bMessageSentStatus = p_DiPOWrapperMsgQInterface->bWriteMsgToQ(&oKeyMsg, sizeof(trKeyMsg));
       ETG_TRACE_USR1(("[PARAM]:spi_tclDiPOCmdInput::vSendKeyEvent - Message send status : %d",ETG_ENUM(BOOL,bMessageSentStatus)));
   }
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclDiPOCmdInput::vSendTouchEvent()
***************************************************************************/
t_Void spi_tclDiPOCmdInput::vSendTouchEvent(t_S32 s32XCoOrdinate,t_S32 s32YCoOrdinate,tenTouchMode enTouchMode)
{
   ETG_TRACE_USR1(("spi_tclDiPOCmdInput::vSendTouchEvent():Touch Mode:%d,X-CoOrdinate:%d,Y-CoOrdinate:%d",
   ETG_ENUM(TOUCH_MODE,enTouchMode),s32YCoOrdinate,s32YCoOrdinate));

   trTouchMsg oTouchMsg;
   oTouchMsg.rTouchCoordinates.s32XCoordinate = s32XCoOrdinate;
   oTouchMsg.rTouchCoordinates.s32YCoordinate = s32YCoOrdinate;
   oTouchMsg.rTouchCoordinates.enTouchMode = enTouchMode;
   oTouchMsg.enMsgType = e8TOUCH_MESSAGE;

   spi_tclDiPOWrapperMsgQInterface* p_DiPOWrapperMsgQInterface = spi_tclDiPOWrapperMsgQInterface::getInstance();
   if(p_DiPOWrapperMsgQInterface)
   {
       t_Bool bMessageSentStatus = p_DiPOWrapperMsgQInterface->bWriteMsgToQ(&oTouchMsg, sizeof(trTouchMsg));
       ETG_TRACE_USR1(("[PARAM]:spi_tclDiPOCmdInput::vSendTouchEvent - Message send status : %d",ETG_ENUM(BOOL,bMessageSentStatus)));
   }
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclDiPOCmdInput::vUpdateSiriActionEvent...
***************************************************************************/
t_Void spi_tclDiPOCmdInput::vUpdateSiriActionEvent(SiriAction enSiriAction)
{
   ETG_TRACE_USR1(("sspi_tclDiPOCmdInput::vUpdateSiriActionEvent:SiriActin:%d",enSiriAction));

   trSiriActionMsg oSiriActionMsg;
   oSiriActionMsg.enMsgType = e8SIRIACTION_MESSAGE;
   oSiriActionMsg.enSiriAction = enSiriAction;
   spi_tclDiPOWrapperMsgQInterface* p_DiPOWrapperMsgQInterface = spi_tclDiPOWrapperMsgQInterface::getInstance();
   if(p_DiPOWrapperMsgQInterface)
   {
       t_Bool bMessageSentStatus = p_DiPOWrapperMsgQInterface->bWriteMsgToQ(&oSiriActionMsg, sizeof(trSiriActionMsg));
       ETG_TRACE_USR1(("[PARAM]:spi_tclDiPOCmdInput::vUpdateSiriActionEvent - Message send status : %d",ETG_ENUM(BOOL,bMessageSentStatus)));
   }
}
/////////////////////////////////////<EOF>//////////////////////////////////////////
