
/***********************************************************************/
/*!
* \file  spi_tclDiPOCmdInput.h
* \brief Adapter class to send touch & key requests to CarPlayd process.
*************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Adapter class to send touch & key requests to CarPlayd process.
AUTHOR:         Shiva Kumar Gurija
COPYRIGHT:      &copy; RBEI

HISTORY:
Date        | Author                | Modification
26.06.2017  | Shiva Kumar Gurija    | Initial Version

\endverbatim
*************************************************************************/
#ifndef _SPI_TCLDIPOCMDINPUT_H_
#define _SPI_TCLDIPOCMDINPUT_H_


/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/

/******************************************************************************
| typedefs (scope: module-global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/

/****************************************************************************/
/*!
* \class spi_tclDiPOCmdInput
* \brief Adapter class to send discovery & connectivity requests to CarPlayd process.
****************************************************************************/
class spi_tclDiPOCmdInput
{

public:

    /***************************************************************************
    *********************************PUBLIC*************************************
    ***************************************************************************/

    /***************************************************************************
    ** FUNCTION:  spi_tclDiPOCmdInput::spi_tclDiPOCmdInput()
    ***************************************************************************/
    /*!
    * \fn      spi_tclDiPOCmdInput()
    * \brief   Default Constructor
    * \param   t_Void
    * \sa      ~spi_tclDiPOCmdInput()
    **************************************************************************/
    spi_tclDiPOCmdInput();

    /***************************************************************************
    ** FUNCTION:  spi_tclDiPOCmdInput::~spi_tclDiPOCmdInput()
    ***************************************************************************/
    /*!
    * \fn      ~spi_tclDiPOCmdInput()
    * \brief   Destructor
    * \param   t_Void
    * \sa      spi_tclDiPOCmdInput()
    **************************************************************************/
    ~spi_tclDiPOCmdInput();

    /***************************************************************************
    ** FUNCTION:  t_Void spi_tclDiPOCmdInput::vSendKeyEvent(...
    ***************************************************************************/
    /*!
    * \fn      t_Void vSendKeyEvent(tenKeyMode enKeyMode, tenKeyCode enKeyCode,
    *                               t_S8 s8KnobEncoderDeltaCnt,tenKeyType enKeyType)
    * \brief   Adapter Interface to send key event to CarPlayd process
    * \param   enKeyMode : [IN] Key mode (Press/Release). Not valid for knob key events
    * \param   enKeyCode : [IN] Key code. Not valid for knob key events
    * \param   enKeyType : [IN]Key Type
    * \param s8KnobEncoderDeltaCnt :[IN] for knob key events.
    * \retval  t_Void
    **************************************************************************/
    t_Void vSendKeyEvent(tenKeyMode enKeyMode, tenKeyCode enKeyCode,tenKeyType enKeyType,t_S8 s8KnobEncoderDeltaCnt);

    /***************************************************************************
    ** FUNCTION:  t_Void spi_tclDiPOCmdInput::vSendTouchEvent(...
    ***************************************************************************/
    /*!
    * \fn      t_Void vSendTouchEvent(t_S32 s32XCoOrdinate,t_S32 s32YCoOrdinate,tenTouchMode enTouchMode)
    * \brief   Adapter Interface to send touch events
    * \param   s32XCoOrdinate : [IN] X co-ordinate
    * \param   s32YCoOrdinate : [IN] Y co-ordinate
    * \param   enTouchMode : [IN] Touch mode
    * \retval  t_Void
    **************************************************************************/
    t_Void vSendTouchEvent(t_S32 s32XCoOrdinate,t_S32 s32YCoOrdinate,tenTouchMode enTouchMode);

    /***************************************************************************
    ** FUNCTION:  t_Void spi_tclDiPOCmdInput::vUpdateSiriActionEvent...
    ***************************************************************************/
    /*!
    * \fn      t_Void vUpdateSiriActionEvent(SiriAction enSiriAction)
    * \brief   Adapter Interface to send Siri events to CarPlayd process
    * \param   enSiriAction : [IN] Siri action event
    * \retval  t_Void
    **************************************************************************/
    t_Void vUpdateSiriActionEvent(SiriAction enSiriAction);


    /***************************************************************************
    ****************************END OF PUBLIC***********************************
    ***************************************************************************/

protected:

    /***************************************************************************
    *********************************PROTECTED**********************************
    ***************************************************************************/

    /***************************************************************************
    ** FUNCTION:  spi_tclDiPOCmdInput(const spi_tclDiPOCmdInput...
    ***************************************************************************/
    /*!
    * \fn      spi_tclDiPOCmdInput(const spi_tclDiPOCmdInput& corfoSrc)
    * \brief   Copy constructor - Do not allow the creation of copy constructor
    * \param   corfoSrc : [IN] reference to source data interface object
    * \sa      spi_tclDiPOCmdInput()
    ***************************************************************************/
    spi_tclDiPOCmdInput(const spi_tclDiPOCmdInput& corfoSrc);


    /***************************************************************************
    ** FUNCTION:  spi_tclDiPOCmdInput& operator=( const spi_tclDiP...
    ***************************************************************************/
    /*!
    * \fn      spi_tclDiPOCmdInput& operator=(const spi_tclDiPOCmdInput& corfoSrc))
    * \brief   Assignment operator
    * \param   corfoSrc : [IN] reference to source data interface object
    * \sa      spi_tclDiPOCmdInput(const spi_tclDiPOCmdInput& otrSrc)
    ***************************************************************************/
    spi_tclDiPOCmdInput& operator=(const spi_tclDiPOCmdInput& corfoSrc);


    /***************************************************************************
    ****************************END OF PROTECTED********************************
    ***************************************************************************/

private:

    /***************************************************************************
    *********************************PRIVATE************************************
    ***************************************************************************/


    /***************************************************************************
    ****************************END OF PRIVATE *********************************
    ***************************************************************************/


}; //class spi_tclDiPOCmdInput

#endif //_SPI_TCLDIPOCMDINPUT_H_

/////////////////////////////////////<EOF>//////////////////////////////////////////
