/******************************************************************************/
/*!
* \file  spi_tclDiPOWrapperMsgQInterface.h
* \brief 
*******************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    
AUTHOR:         Suraj P S
COPYRIGHT:      &copy; RBEI

HISTORY:
Date        | Author                | Modification
03.03.2019  | Suraj P S    | Initial Version

\endverbatim
******************************************************************************/
#ifndef _SPI_TCLDIPOWRAPPERMSGQINTERFACE_H_
#define _SPI_TCLDIPOWRAPPERMSGQINTERFACE_H_

/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/
#include "BaseTypes.h"
#include "MsgQThreader.h"
#include "spi_tclDiPOMsgQThreadable.h"
#include "GenericSingleton.h"

using namespace shl::thread;

/******************************************************************************
| typedefs (scope: module-global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/


/*****************************************************************************/
/*!
* \class spi_tclDiPOWrapperMsgQInterface
* \brief Responsible to write the messages to Queue and creates thread which 
*        reads the messages written to Queue.
****************************************************************************/
class spi_tclDiPOWrapperMsgQInterface : public GenericSingleton<spi_tclDiPOWrapperMsgQInterface>
{
public:

	 /***************************************************************************
	 *********************************PUBLIC*************************************
	 ***************************************************************************/

      /***************************************************************************
      ** FUNCTION:  spi_tclDiPOWrapperMsgQInterface::~spi_tclDiPOWrapperMsgQInterface()
      ***************************************************************************/
      /*!
      * \fn      ~spi_tclDiPOWrapperMsgQInterface()
      * \brief   Destructor
      * \sa      spi_tclDiPOWrapperMsgQInterface()
      ***************************************************************************/
      ~spi_tclDiPOWrapperMsgQInterface();

      /***************************************************************************
      ** FUNCTION:  spi_tclDiPOWrapperMsgQInterface::bWriteMsgToQ
      ***************************************************************************/
      /*!
      * \fn      bWriteMsgToQ(trMsgQBase *prMsgBase, t_U32 u32MsgSize)
      * \brief   Write Msg to Q for dispatching the message by a seperate thread
      * \param prMsgBase : Pointer to Base Message type
      * \param u32MsgSize :  size of the message to be written to the MsgQ
      ***************************************************************************/
      t_Bool bWriteMsgToQ(trMsgQBase *prMsgBase, t_U32 u32MsgSize);

      //! Base Singleton class
      friend class GenericSingleton<spi_tclDiPOWrapperMsgQInterface> ;


	  /***************************************************************************
	  *********************************PUBLIC*************************************
	  ***************************************************************************/

protected:
	 /***************************************************************************
	 *********************************PROTECTED**********************************
	 ***************************************************************************/


	 /***************************************************************************
	 *********************************PROTECTED**********************************
	 ***************************************************************************/

private:

	 /***************************************************************************
	 *******************************PRIVATE**************************************
	 ***************************************************************************/

     /***************************************************************************
     ** FUNCTION:  spi_tclDiPOWrapperMsgQInterface::spi_tclDiPOWrapperMsgQInterface()
     ***************************************************************************/
     /*!
     * \fn      spi_tclDiPOWrapperMsgQInterface()
     * \brief   Default Constructor
     * \sa      ~spi_tclDiPOWrapperMsgQInterface()
     ***************************************************************************/
     spi_tclDiPOWrapperMsgQInterface();
	 
     /***************************************************************************
      ** FUNCTION:  spi_tclDiPOWrapperMsgQInterface(const spi_tclDiPOWrapperMsgQInterface...
      ***************************************************************************/
     /*!
      * \fn      spi_tclDiPOWrapperMsgQInterface(
      *                             const spi_tclDiPOWrapperMsgQInterface& corfoSrc)
      * \brief   Copy constructor - Do not allow the creation of copy constructor
      * \param   corfoSrc : [IN] reference to source data interface object
      * \retval
      * \sa      spi_tclDiPOWrapperMsgQInterface()
      ***************************************************************************/
      spi_tclDiPOWrapperMsgQInterface(const spi_tclDiPOWrapperMsgQInterface& corfoSrc);

     /***************************************************************************
      ** FUNCTION:  spi_tclDiPOWrapperMsgQInterface& operator=( const spi_tclAAP...
      ***************************************************************************/
     /*!
      * \fn      spi_tclDiPOWrapperMsgQInterface& operator=(
      *                          const spi_tclDiPOWrapperMsgQInterface& corfoSrc))
      * \brief   Assignment operator
      * \param   corfoSrc : [IN] reference to source data interface object
      * \retval
      * \sa      spi_tclDiPOWrapperMsgQInterface(const spi_tclDiPOWrapperMsgQInterface& otrSrc)
      ***************************************************************************/
      spi_tclDiPOWrapperMsgQInterface& operator=(const spi_tclDiPOWrapperMsgQInterface& corfoSrc);	 	 

     //! Pointer to the overridden MsgQThreadable class
     MsgQThreadable *m_poMsgQThreadable;

     //! pointer to MsgQThreader
     MsgQThreader *m_poMsgQThreader;

	 /***************************************************************************
	 *******************************PRIVATE************************************
	 **************************************************************************/
};

#endif //_SPI_TCLDIPOWRAPPERMSGQINTERFACE_H_
