/*******************************************************************************************/
/*!
 * \file   spi_tclDiPOMsgQThreadable.h
 * \brief  It is responsible to receive the messages written to Queue and dispatch to respective dispatchers.
 *********************************************************************************************
 \verbatim

 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Responsible to receive the messages written to Queue and dispatch to respective dispatchers.
 AUTHOR:         Shiva Kumar Gurija
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date        | Author                | Modification
 09.12.2016  | Shiva Kumar Gurija    | Initial Version

 \endverbatim
 ****************************************************************************/
#ifndef _SPI_TCL_DIPOMSGQTHREADABLE_H_
#define _SPI_TCL_DIPOMSGQTHREADABLE_H_

/***************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |--------------------------------------------------------------------------*/
using namespace shl::thread;
class spi_tclDiPODiscovererDispatcher;
class spi_tclDiPOVideoDispatcher;
class spi_tclDiPOSessionDispatcher;
class spi_tclDiPOBluetoothDispatcher;
class spi_tclDiPORsrcMngrDispatcher;
class spi_tclDiPOAudioDispatcher;

/******************************************************************************
 | typedefs (scope: module-global)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | defines and macros (scope: global)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | typedefs (scope: module-local)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | defines and macros (scope: local)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | variable definition (scope: global)
 |----------------------------------------------------------------------------*/

/******************************************************************************
 | variable definition (scope: module-local)
 |----------------------------------------------------------------------------*/

/*****************************************************************************/
/*!
 * \class spi_tclDiPOMsgQThreadable
 * \brief implements threading based on MsgQthreader for the messages from CarPlayd process.
 *  It is responsible to receive the messages written to Queue and dispatch to respective dispatchers.
 ***************************************************************************/
class spi_tclDiPOMsgQThreadable: public MsgQThreadable
{
   public:

      /***************************************************************************
       *********************************PUBLIC*************************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclDiPOMsgQThreadable::spi_tclDiPOMsgQThreadable()
       ***************************************************************************/
      /*!
       * \fn      spi_tclDiPOMsgQThreadable()
       * \brief   Default Constructor
       * \sa      ~spi_tclDiPOMsgQThreadable()
       ***************************************************************************/
      spi_tclDiPOMsgQThreadable();

      /***************************************************************************
       ** FUNCTION:  spi_tclDiPOMsgQThreadable::~spi_tclDiPOMsgQThreadable()
       ***************************************************************************/
      /*!
       * \fn      ~spi_tclDiPOMsgQThreadable()
       * \brief   Destructor
       * \sa      spi_tclDiPOMsgQThreadable()
       ***************************************************************************/
      ~spi_tclDiPOMsgQThreadable();

      /***************************************************************************
       *********************************PUBLIC*************************************
       ***************************************************************************/

   protected:
      /***************************************************************************
       *********************************PROTECTED**********************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION:  spi_tclDiPOMsgQThreadable::vExecute
       ***************************************************************************/
      /*!
       * \fn      t_Void vExecute(tShlMessage *poMessage)
       * \brief   Responsible for posting the message to respective dispatchers
       * \param   poMessage : message received from MsgQ for dispatching
       ***************************************************************************/
      virtual t_Void vExecute(tShlMessage *poMessage);

      /***************************************************************************
       ** FUNCTION:  spi_tclDiPOMsgQThreadable::tShlMessage* poGetMsgBuffer(size_t )
       ***************************************************************************/
      /*!
       * \fn      tShlMessage* poGetMsgBuffer(size_t )
       * \brief  This function will be called for requesting the storage allocation for received message
       * \param siBuffer: size of the buffer to be allocated for the received message
       ***************************************************************************/
      virtual tShlMessage* poGetMsgBuffer(size_t siBuffer);

      /***************************************************************************
       *********************************PROTECTED**********************************
       ***************************************************************************/

   private:

      /***************************************************************************
       *******************************PRIVATE**************************************
       ***************************************************************************/

      //! Dispatcher to dispatch Discovery & Connection related messages.
      spi_tclDiPODiscovererDispatcher *m_poDiscDispatcher;
      spi_tclDiPOVideoDispatcher *m_poVideoDispatcher;
      spi_tclDiPOSessionDispatcher *m_poSessionDispatcher;
      spi_tclDiPOBluetoothDispatcher *m_poBTDispatcher;
      spi_tclDiPORsrcMngrDispatcher *m_poRsrcMngrDispatcher;
      spi_tclDiPOAudioDispatcher *m_poAudioDispatcher;

      /***************************************************************************
       ******************************PRIVATE**************************************
       ***************************************************************************/
};

#endif //_SPI_TCL_DIPOMSGQTHREADABLE_H_
