/***********************************************************************/
/*!
* \file  spi_tclDiPOMsgQInterface.cpp
* \brief Responsible to write the messages to Queue and creates thread which reads the messages written to Queue.
*************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Responsible to write the messages to Queue and creates thread which reads the messages written to Queue.
AUTHOR:         Shiva Kumar Gurija
COPYRIGHT:      &copy; RBEI

HISTORY:
Date        | Author                | Modification
09.12.2016  | Shiva Kumar Gurija    | Initial Version

\endverbatim
*************************************************************************/

/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/
#include "MessageQueue.h"
#include "SPITypes.h"
#include "spi_tclDiPOMsgQInterface.h"

//! Includes for Trace files
#include "Trace.h"
   #ifdef TARGET_BUILD
      #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
      #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_MSGQTHREADER
      #include "trcGenProj/Header/spi_tclDiPOMsgQInterface.cpp.trc.h"
   #endif
#endif

/******************************************************************************
| typedefs (scope: module-global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/


/******************************************************************************
 ** FUNCTION:  spi_tclDiPOMsgQInterface::spi_tclDiPOMsgQInterface()
 ***************************************************************************/
spi_tclDiPOMsgQInterface::spi_tclDiPOMsgQInterface():m_poDiPOMsgQThreadable(NULL), m_poDiPOMsgQThreader(NULL)
{
   ETG_TRACE_USR1(("spi_tclDiPOMsgQInterface::spi_tclDiPOMsgQInterface()"));
   
   m_poDiPOMsgQThreadable =  new(std::nothrow) spi_tclDiPOMsgQThreadable();
   SPI_NORMAL_ASSERT(NULL == m_poDiPOMsgQThreadable);
   
   m_poDiPOMsgQThreader =  new(std::nothrow) MsgQThreader(m_poDiPOMsgQThreadable);
   SPI_NORMAL_ASSERT(NULL == m_poDiPOMsgQThreadable);
   
   if(NULL != m_poDiPOMsgQThreader)
   {
      m_poDiPOMsgQThreader->bRunThread();
      m_poDiPOMsgQThreader->vSetThreadName("DiPORespQ");
   }
}

/******************************************************************************
 ** FUNCTION:  spi_tclDiPOMsgQInterface::~spi_tclDiPOMsgQInterface()
 *****************************************************************************/
spi_tclDiPOMsgQInterface::~spi_tclDiPOMsgQInterface()
{
   ETG_TRACE_USR1((" spi_tclDiPOMsgQInterface::~spi_tclDiPOMsgQInterface()"));

   //Terminate the Message Queue threader before deleting it.
   if(NULL != m_poDiPOMsgQThreader)
   {
      MessageQueue *poMsgQ = m_poDiPOMsgQThreader->poGetMessageQueu();
      if(NULL != poMsgQ)
      {
         trMsgBase oMsgQTermMsg;
         poMsgQ->s16Push(static_cast<t_Void*>(&oMsgQTermMsg),0,1,e8_TCL_THREAD_TERMINATE_MESSAGE);
      }//if(NULL != poMsgQ)

      //Wait for the message queue thread to join.
      Threader::vWaitForTermination(m_poDiPOMsgQThreader->pGetThreadID());

   }//if(NULL != m_poDiPOMsgQThreader)

   RELEASE_MEM(m_poDiPOMsgQThreader);
   RELEASE_MEM(m_poDiPOMsgQThreadable);
}

/******************************************************************************
 ** FUNCTION:  spi_tclDiPOMsgQInterface::bWriteMsgToQ(trMsgBase *prMsgBase,t_U32 u32MsgSize)
 *****************************************************************************/
t_Bool spi_tclDiPOMsgQInterface::bWriteMsgToQ(trMsgBase *prMsgBase,t_U32 u32MsgSize)
{
   ETG_TRACE_USR1((" spi_tclDiPOMsgQInterface::bWriteMsgToQ() entered" ));

   t_Bool bRetQ = false;

   if (NULL != m_poDiPOMsgQThreader)
   {
      //Get the MsgQ form threader and push the message to Q
      MessageQueue *poMsgQ = m_poDiPOMsgQThreader->poGetMessageQueu();
      if ((NULL != poMsgQ) && (NULL != prMsgBase))
      {
         t_S32 s32RetMsgQ = poMsgQ->s16Push(static_cast<t_Void*>(prMsgBase), u32MsgSize);
         bRetQ = (0 == s32RetMsgQ);
      } // if ((NULL != poMsgQ) && (NULL != prMsgBase))
   } //if (NULL != m_poDiPOMsgQThreader)

   if(bRetQ == false)
   {
      ETG_TRACE_ERR(("[ERR]:spi_tclDiPOMsgQInterface::bWriteMsgToQ():Write to MsgQ failed"));
   }

   return bRetQ;
}

///////////////////////////////////////////////// EOF //////////////////////////////////////////////
