/*!
*******************************************************************************
* \file             spi_tclDiPOManager.h
* \brief            CarPlay Wrapper Manager
*******************************************************************************
\verbatim
PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    CarPlay Wrapper Manager to provide interface to SPI
COPYRIGHT:      &copy; RBEI

HISTORY:
Date       |  Author              | Modifications
09.12.2016 |  Shiva kumar G       | Initial Version

\endverbatim
******************************************************************************/
#ifndef _SPI_TCLDIPOMANAGER_H_
#define _SPI_TCLDIPOMANAGER_H_

/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/
#include "GenericSingleton.h"
class RespBase;
class spi_tclDiPODeviceMsgRcvr;
class spi_tclDiPOCmdDiscoverer;
class spi_tclDiPOCmdVideo;
class spi_tclDiPOCmdInput;
class spi_tclDiPOCmdBluetooth;
class spi_tclDiPOCmdRsrcMngr;
class spi_tclDiPOCmdAudio;
class spi_tclDiPOCmdSession;

/******************************************************************************
| typedefs (scope: module-global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/


/*!
* \class spi_tclDiPOManager
* \brief CarPlay Wrapper Manager to provide interface to SPI
*/
class spi_tclDiPOManager : public GenericSingleton<spi_tclDiPOManager>
{
public:

   /***************************************************************************
   *********************************PUBLIC*************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  spi_tclDiPOManager::~spi_tclDiPOManager();
   ***************************************************************************/
   /*!
   * \fn      ~spi_tclDiPOManager()
   * \brief   Destructor
   * \sa      spi_tclDiPOManager()
   **************************************************************************/
   ~spi_tclDiPOManager();


   /***************************************************************************
   ** FUNCTION:    spi_tclDiPOCmdDiscoverer* poGetDiPODiscInstance()
   ***************************************************************************/
   /*!
   * \fn       spi_tclDiPOCmdDiscoverer* poGetDiPODiscInstance() const
   * \brief    Method to get the CmdDiscoverer instance
   **************************************************************************/
   spi_tclDiPOCmdDiscoverer* poGetDiPODiscInstance() const;

   /***************************************************************************
   ** FUNCTION:    spi_tclDiPOCmdVideo* poGetDiPOVideoInstance()
   ***************************************************************************/
   /*!
   * \fn       spi_tclDiPOCmdVideo* poGetDiPOVideoInstance() const
   * \brief    Method to get the CmdVideo instance
   **************************************************************************/
   spi_tclDiPOCmdVideo* poGetDiPOVideoInstance() const;


   /***************************************************************************
   ** FUNCTION:    spi_tclDiPOCmdInput* poGetDiPOInputInstance()
   ***************************************************************************/
   /*!
   * \fn       spi_tclDiPOCmdInput* poGetDiPOInputInstance() const
   * \brief    Method to get the CmdInput instance
   **************************************************************************/
   spi_tclDiPOCmdInput* poGetDiPOInputInstance() const;

   /***************************************************************************
   ** FUNCTION:    spi_tclDiPOCmdBluetooth* poGetDiPOBluetoothInstance()
   ***************************************************************************/
   /*!
   * \fn       spi_tclDiPOCmdBluetooth* poGetDiPOBluetoothInstance() const
   * \brief    Method to get the CmdBluetooth instance
   **************************************************************************/
   spi_tclDiPOCmdBluetooth* poGetDiPOBluetoothInstance() const;
 
   /***************************************************************************
   ** FUNCTION:    spi_tclDiPOCmdRsrcMngr* poGetDiPORsrcMngrInstance()
   ***************************************************************************/
   /*!
   * \fn       spi_tclDiPOCmdRsrcMngr* poGetDiPORsrcMngrInstance() const
   * \brief    Method to get the Cmd Resource Manager instance
   **************************************************************************/ 
   spi_tclDiPOCmdRsrcMngr* poGetDiPORsrcMngrInstance() const;
   
   /***************************************************************************
   ** FUNCTION:    spi_tclDiPOCmdAudio* poGetDiPOAudioInstance()
   ***************************************************************************/
   /*!
   * \fn       spi_tclDiPOCmdAudio* poGetDiPOAudioInstance() const
   * \brief    Method to get the Cmd Audio instance
   **************************************************************************/  
   spi_tclDiPOCmdAudio* poGetDiPOAudioInstance() const;

   /***************************************************************************
   ** FUNCTION:    spi_tclDiPOCmdSession* poGetDiPOSessionInstance()
   ***************************************************************************/
   /*!
   * \fn       spi_tclDiPOCmdSession* poGetDiPOSessionInstance() const
   * \brief    Method to get the Cmd Session instance
   **************************************************************************/
   spi_tclDiPOCmdSession* poGetDiPOSessionInstance() const;

   /***************************************************************************
   ** FUNCTION:    spi_tclDiPODeviceMsgRcvr* poGetDeviceMsgRcvrInstance()
   ***************************************************************************/
   /*!
   * \fn       spi_tclDiPODeviceMsgRcvr* poGetDeviceMsgRcvrInstance() const
   * \brief    Method to get the spi_tclDiPODeviceMsgRcvr instance
   **************************************************************************/
   spi_tclDiPODeviceMsgRcvr* poGetDeviceMsgRcvrInstance() const;

   /***************************************************************************
   ** FUNCTION:  t_Bool spi_tclDiPOManager::bRegisterObject(RespBase *poRespBase)
   ***************************************************************************/
   /*!
   * \fn      t_Bool spi_tclDiPOManager::bRegisterObject(RespBase *poRespBase) const
   * \brief   It provides mechanism to register for the callbacks from a
   *          response class of CarPlayd Wrapper
   * \ret     true on success
   *          false on failure
   **************************************************************************/
   t_Bool bRegisterObject(RespBase *poRespBase) const;

   /***************************************************************************
   ** FUNCTION:  t_Bool spi_tclDiPOManager::bUnResgisterObject(RespBase *poRespBase)
   ***************************************************************************/
   /*!
   * \fn       t_Bool spi_tclDiPOManager::bUnResgisterObject(RespBase *poRespBase) const
   * \brief    It provides mechanism to un-register for the callbacks
   * \ret      returns true on success
   **************************************************************************/
   t_Bool bUnResgisterObject(RespBase *poRespBase) const;
   
   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclDiPOManager::vInitiateMsgRcvr()
   ***************************************************************************/
   /*!
   * \fn       t_Void spi_tclDiPOManager::vInitiateMsgRcvr()
   * \brief    Method to create the Msg Receiver
   **************************************************************************/   
   t_Void vInitiateMsgRcvr();

   //! Base Singleton class
   friend class GenericSingleton<spi_tclDiPOManager>;

   /***************************************************************************
   *********************************PUBLIC*************************************
   ***************************************************************************/

protected:
   /***************************************************************************
   *********************************PROTECTED**********************************
   ***************************************************************************/


   /***************************************************************************
   *********************************PROTECTED**********************************
   ***************************************************************************/

private:

   /***************************************************************************
   *******************************PRIVATE*************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  spi_tclDiPOManager& spi_tclDiPOManager::operator= (const..
   ***************************************************************************/
   /*!
   * \fn      spi_tclDiPOManager& operator= (const spi_tclDiPOManager &corfrSrc)
   * \brief   Assignment Operator, will not be implemented.
   * \note    This is a technique to disable the assignment operator for this class.
   *          So if an attempt for the assignment is made linker complains.
   * \param   corfrSrc : [IN] Source Object
   **************************************************************************/
   spi_tclDiPOManager& operator=(const spi_tclDiPOManager& corfrSrc);


   /***************************************************************************
   ** FUNCTION:  spi_tclDiPOManager::spi_tclDiPOManager(const spi_tclDiPOManager..
   ***************************************************************************/
   /*!
   * \fn      spi_tclDiPOManager(const spi_tclDiPOManager &corfrSrc)
   * \brief   Copy constructor, will not be implemented.
   * \note    This is a technique to disable the Copy constructor for this class.
   * \param   corfrSrc : [IN] Source Object
   **************************************************************************/
   spi_tclDiPOManager(const spi_tclDiPOManager& corfrSrc);

   /***************************************************************************
   ** FUNCTION:  spi_tclDiPOManager::spi_tclDiPOManager()
   ***************************************************************************/
   /*!
   * \fn      spi_tclDiPOManager()
   * \brief   Default Constructor
   * \sa      ~spi_tclDiPOManager()
   **************************************************************************/
   spi_tclDiPOManager();


   //Discoverer Instance
   spi_tclDiPOCmdDiscoverer* m_pCmdDisc;
   
   spi_tclDiPOCmdVideo* m_pCmdVideo;

   //! Pointer object to the DiPo device msg receiver
   spi_tclDiPODeviceMsgRcvr *m_poDeviceMsgRcvr;

   spi_tclDiPOCmdInput *m_poCmdInput;

   spi_tclDiPOCmdBluetooth *m_poCmdBluetooth;
   
   spi_tclDiPOCmdRsrcMngr* m_poCmdRsrcMngr;
   
   spi_tclDiPOCmdAudio* m_poCmdAudio;

   spi_tclDiPOCmdSession* m_poCmdSession;

   /***************************************************************************
   *******************************PRIVATE************************************
   **************************************************************************/
};

#endif //_SPI_TCLDIPOMANAGER_H_

