/*!
 *******************************************************************************
 * \file              spi_tclDiPOManager.cpp
 * \brief             CarPlay Wrapper Manager
 *******************************************************************************
 \verbatim
 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    CarPlay Wrapper Manager to provide interface to SPI
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date       |  Author              | Modifications
 09.12.2016 |  Shiva kumar G       | Initial Version

 \endverbatim
 ******************************************************************************/

/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/
#include "SPITypes.h"
#include "RespBase.h"
#include "RespRegister.h"
#include "spi_tclDiPODeviceMsgRcvr.h"
#include "DiPOWrapperTypes.h"
#include "spi_tclDiPOCmdDiscoverer.h"
#include "spi_tclDiPOCmdVideo.h"
#include "spi_tclDiPOCmdInput.h"
#include "spi_tclDiPOCmdBluetooth.h"
#include "spi_tclDiPOCmdRsrcMngr.h"
#include "spi_tclDiPOCmdAudio.h"
#include "spi_tclDiPOCmdSession.h"
#include "spi_tclDiPOManager.h"

//! Includes for Trace files
#include "Trace.h"
#ifdef TARGET_BUILD
   #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
      #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_DIPO
      #include "trcGenProj/Header/spi_tclDiPOManager.cpp.trc.h"
   #endif
#endif

/******************************************************************************
| typedefs (scope: module-global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/


/***************************************************************************
 ** FUNCTION:  spi_tclDiPOManager::spi_tclDiPOManager()
 ***************************************************************************/
spi_tclDiPOManager::spi_tclDiPOManager():m_pCmdDisc(NULL),
m_pCmdVideo(NULL),
m_poDeviceMsgRcvr(NULL),
m_poCmdInput(NULL),
m_poCmdBluetooth(NULL),
m_poCmdRsrcMngr(NULL),
m_poCmdAudio(NULL),
m_poCmdSession(NULL)
{
   ETG_TRACE_USR1(("spi_tclDiPOManager::spi_tclDiPOManager()  entered "));
   
   m_pCmdDisc = new(std::nothrow) spi_tclDiPOCmdDiscoverer();
   SPI_NORMAL_ASSERT(NULL == m_pCmdDisc);
   
   m_pCmdVideo = new(std::nothrow) spi_tclDiPOCmdVideo();
   SPI_NORMAL_ASSERT(NULL == m_pCmdVideo);
   
   m_poCmdInput = new(std::nothrow) spi_tclDiPOCmdInput();
   SPI_NORMAL_ASSERT(NULL == m_poCmdInput);

   m_poCmdBluetooth = new(std::nothrow) spi_tclDiPOCmdBluetooth();
   SPI_NORMAL_ASSERT(NULL == m_poCmdBluetooth);
   
   m_poCmdRsrcMngr = new(std::nothrow) spi_tclDiPOCmdRsrcMngr();
   SPI_NORMAL_ASSERT(NULL == m_poCmdRsrcMngr);
   
   m_poCmdAudio = new(std::nothrow) spi_tclDiPOCmdAudio();
   SPI_NORMAL_ASSERT(NULL == m_poCmdAudio);

   m_poCmdSession = new(std::nothrow) spi_tclDiPOCmdSession();
   SPI_NORMAL_ASSERT(NULL == m_poCmdSession);

}

/***************************************************************************
 ** FUNCTION:  spi_tclDiPOManager::~spi_tclDiPOManager()
 ***************************************************************************/
spi_tclDiPOManager::~spi_tclDiPOManager()
{
   ETG_TRACE_USR1(("spi_tclDiPOManager::~spi_tclDiPOManager()  entered "));
   
   RELEASE_MEM(m_pCmdDisc);
   RELEASE_MEM(m_poDeviceMsgRcvr);
   RELEASE_MEM(m_pCmdVideo);
   RELEASE_MEM(m_poCmdInput);
   RELEASE_MEM(m_poCmdBluetooth);
   RELEASE_MEM(m_poCmdRsrcMngr);
   RELEASE_MEM(m_poCmdAudio);
   RELEASE_MEM(m_poCmdSession);
}

/***************************************************************************
 ** FUNCTION: spi_tclDiPOCmdDiscoverer* spi_tclDiPOManager::poGetDiPODiscInstance() const
 ***************************************************************************/
spi_tclDiPOCmdDiscoverer* spi_tclDiPOManager::poGetDiPODiscInstance() const
{
   ETG_TRACE_USR1(("spi_tclDiPOManager::poGetDiPODiscInstance():%p", m_pCmdDisc));
   return m_pCmdDisc;
}

/***************************************************************************
 ** FUNCTION: spi_tclDiPOCmdVideo* spi_tclDiPOManager::poGetDiPOVideoInstance() const
 ***************************************************************************/
spi_tclDiPOCmdVideo* spi_tclDiPOManager::poGetDiPOVideoInstance() const
{
   ETG_TRACE_USR1(("spi_tclDiPOManager::poGetDiPOVideoInstance():%p", m_pCmdVideo));
   return m_pCmdVideo;
}

/***************************************************************************
** FUNCTION:    spi_tclDiPOCmdInput* spi_tclDiPOManager::poGetDiPOInputInstance()
***************************************************************************/
spi_tclDiPOCmdInput* spi_tclDiPOManager::poGetDiPOInputInstance() const
{
   ETG_TRACE_USR1(("spi_tclDiPOManager::poGetDiPOInputInstance():%p", m_poCmdInput));
   return m_poCmdInput;
}


/***************************************************************************
** FUNCTION:    spi_tclDiPOCmdBluetooth* spi_tclDiPOManager::poGetDiPOBluetoothInstance()
***************************************************************************/
spi_tclDiPOCmdBluetooth* spi_tclDiPOManager::poGetDiPOBluetoothInstance() const
{
   ETG_TRACE_USR1(("spi_tclDiPOManager::poGetDiPOBluetoothInstance():%p", m_poCmdBluetooth));
   return m_poCmdBluetooth;
}

/***************************************************************************
** FUNCTION:    spi_tclDiPOCmdRsrcMngr* spi_tclDiPOManager::poGetDiPORsrcMngrInstance()
***************************************************************************/
spi_tclDiPOCmdRsrcMngr* spi_tclDiPOManager::poGetDiPORsrcMngrInstance() const
{
   ETG_TRACE_USR1(("spi_tclDiPOManager::poGetDiPORsrcMngrInstance():%p", m_poCmdRsrcMngr));
   return m_poCmdRsrcMngr; 
}
  
/***************************************************************************
** FUNCTION:    spi_tclDiPOCmdAudio* poGetDiPOAudioInstance()
***************************************************************************/
spi_tclDiPOCmdAudio* spi_tclDiPOManager::poGetDiPOAudioInstance() const
{
   ETG_TRACE_USR1(("spi_tclDiPOManager::poGetDiPORsrcMngrInstance():%p", m_poCmdAudio));
   return m_poCmdAudio; 	   
}

/***************************************************************************
** FUNCTION:    spi_tclDiPOCmdSession* poGetDiPOSessionInstance()
***************************************************************************/
spi_tclDiPOCmdSession* spi_tclDiPOManager::poGetDiPOSessionInstance() const
{
   ETG_TRACE_USR1(("spi_tclDiPOManager::poGetDiPOSessionInstance():%p", m_poCmdSession));
   return m_poCmdSession;
}

/***************************************************************************
** FUNCTION:    spi_tclDiPODeviceMsgRcvr* poGetDeviceMsgRcvrInstance()
***************************************************************************/
spi_tclDiPODeviceMsgRcvr* spi_tclDiPOManager::poGetDeviceMsgRcvrInstance() const
{
    ETG_TRACE_USR1(("spi_tclDiPOManager::poGetDeviceMsgRcvrInstance():%p", m_poDeviceMsgRcvr));
    return m_poDeviceMsgRcvr;
}
  
/***************************************************************************
 ** FUNCTION:  t_Bool spi_tclDiPOManager::bRegisterObject(RespBase *poRespBase) const
 ***************************************************************************/
t_Bool spi_tclDiPOManager::bRegisterObject(RespBase *poRespBase) const
{
   ETG_TRACE_USR1(("spi_tclDiPOManager::bRegisterObject() entered"));
   
   t_Bool bRetReg = false;

   RespRegister *pRespRegister = RespRegister::getInstance();
   if(NULL!= pRespRegister)
   {
      bRetReg = pRespRegister->bRegisterObject(poRespBase);
   }

   return bRetReg;
}

/***************************************************************************
 ** FUNCTION:  t_Bool spi_tclDiPOManager::bUnResgisterObject(RespBase *poRespBase) const
 ***************************************************************************/
t_Bool spi_tclDiPOManager::bUnResgisterObject(RespBase *poRespBase) const
{
   ETG_TRACE_USR1(("spi_tclDiPOManager::bUnResgisterObject()  entered"));
   
   t_Bool bRetReg = false;

   RespRegister *pRespRegister = RespRegister::getInstance();
   if(NULL!= pRespRegister)
   {
      bRetReg = pRespRegister->bUnregisterObject(poRespBase);
   }

   return bRetReg;
}

/***************************************************************************
 ** FUNCTION:  t_Void spi_tclDiPOManager::vInitiateMsgRcvr()
 ***************************************************************************/
t_Void spi_tclDiPOManager::vInitiateMsgRcvr()
{
   ETG_TRACE_USR1(("spi_tclDiPOManager::vInitiateMsgRcvr()  entered"));
   
   m_poDeviceMsgRcvr = new(std::nothrow) spi_tclDiPODeviceMsgRcvr();
   SPI_NORMAL_ASSERT(NULL == m_poDeviceMsgRcvr);
}

///////////////////////////////////////////////// EOF //////////////////////////////////////////////
