/***********************************************************************/
/*!
* \file  spi_tclDiPOCmdBluetooth.h
* \brief Adapter class to process Bluetooth related events.
*************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Adapter class to process Bluetooth related events.
AUTHOR:         Shiva Kumar Gurija
COPYRIGHT:      &copy; RBEI

HISTORY:
Date        | Author                | Modification
26.06.2017  | Shiva Kumar Gurija    | Initial Version

\endverbatim
*************************************************************************/


/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/
#include "BaseTypes.h"
#include "SPITypes.h"
#include "IPCMessageQueue.h"
#include "DiPOTypes.h"
#include "DiPOWrapperTypes.h"
#include "spi_tclDiPOCmdBluetooth.h"

#include "spi_tclDiPOWrapperMsgQInterface.h"

//! Includes for Trace files
#include "Trace.h"
#ifdef TARGET_BUILD
   #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
      #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_DIPO
      #include "trcGenProj/Header/spi_tclDiPOCmdBluetooth.cpp.trc.h"
   #endif
#endif

/******************************************************************************
| typedefs (scope: module-global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/


/***************************************************************************
** FUNCTION:  spi_tclDiPOCmdBluetooth::spi_tclDiPOCmdBluetooth()
***************************************************************************/
spi_tclDiPOCmdBluetooth::spi_tclDiPOCmdBluetooth()
{
   ETG_TRACE_USR1(("spi_tclDiPOCmdBluetooth::spi_tclDiPOCmdBluetooth()"));
}

/***************************************************************************
** FUNCTION:  spi_tclDiPOCmdBluetooth::~spi_tclDiPOCmdBluetooth()
***************************************************************************/
spi_tclDiPOCmdBluetooth::~spi_tclDiPOCmdBluetooth()
{
   ETG_TRACE_USR1(("spi_tclDiPOCmdBluetooth::~spi_tclDiPOCmdBluetooth()"));
}

/***************************************************************************
** FUNCTION:  t_Void spi_tclDiPOCmdBluetooth::vUpdateSiriActionEvent...
***************************************************************************/
t_Void spi_tclDiPOCmdBluetooth::vUpdateBTAddr(t_String szBMACAddr)
{
   ETG_TRACE_USR1(("spi_tclDiPOCmdBluetooth::vUpdateBTAddr:%s",szBMACAddr.c_str()));
   trBtAddrUpdateMsg oBtAddrUpdateMsg;
   if (szBMACAddr.length() < DIPO_MAX_STR_LEN)
   {
       strncpy(oBtAddrUpdateMsg.cBTAddress, szBMACAddr.c_str(), DIPO_MAX_STR_LEN);
   }
   else
   {
       ETG_TRACE_ERR(("[ERR]:sspi_tclDiPOCmdBluetooth::vUpdateBTAddr():Received BT Address seems to be invalid. Length is more than defined."));
   }

   oBtAddrUpdateMsg.enMsgType = e8BTADDRESS_UPDATE_MESSAGE;

   spi_tclDiPOWrapperMsgQInterface* p_DiPOWrapperMsgQInterface = spi_tclDiPOWrapperMsgQInterface::getInstance();
   if(p_DiPOWrapperMsgQInterface)
   {
       p_DiPOWrapperMsgQInterface->bWriteMsgToQ(&oBtAddrUpdateMsg, sizeof(trBtAddrUpdateMsg));
   }
}
/////////////////////////////////////<EOF>//////////////////////////////////////////
