/***********************************************************************/
/*!
* \file  spi_tclDiPOBluetoothDispatcher.cpp
* \brief Message Dispatcher for Session Messages.
*************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Message Dispatcher for Bluetooth Messages.
AUTHOR:         Shiva Kumar Gurija
COPYRIGHT:      &copy; RBEI

HISTORY:
Date        | Author                | Modification
09.12.2016  | Shiva Kumar Gurija    | Initial Version

\endverbatim
*************************************************************************/


/***************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |--------------------------------------------------------------------------*/
#include "SPITypes.h"
#include "DiPOTypes.h"
#include "StringHandler.h"
#include "RespRegister.h"
#include "spi_tclDiPOBluetoothDispatcher.h"
#include "spi_tclDiPORespBluetooth.h"

//! Includes for Trace files
#include "Trace.h"
#ifdef TARGET_BUILD
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_MSGQTHREADER
#include "trcGenProj/Header/spi_tclDiPOBluetoothDispatcher.cpp.trc.h"
#endif
#endif

/******************************************************************************
| typedefs (scope: module-global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: local)
|----------------------------------------------------------------------------*/
#define DEFINE_DISPATCH_MESSAGE_FUNCTION(COMMAND,DISPATCHER)\
t_Void COMMAND::vDispatchMsg(DISPATCHER* poDispatcher)      \
{                                                           \
   if (NULL != poDispatcher)                                \
   {                                                        \
      poDispatcher->vHandleBluetoothMsg(this);                \
   }                                                        \
   vDeAllocateMsg();                                        \
}                                                           \

/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/

/***************************************************************************
 ** FUNCTION:  DiPOBluetoothMsgBase::DiPOBluetoothMsgBase()
 ***************************************************************************/
DiPOBluetoothMsgBase::DiPOBluetoothMsgBase(): m_u32DeviceHandle(0)
{
   vSetServiceID(e8_DIPO_WRAPPER_BLUETOOTH);
}

/***************************************************************************
 ** FUNCTION:  DiPOBluetoothMsgBase::u32GetDeviceHandle()
 ***************************************************************************/
t_U32 DiPOBluetoothMsgBase::u32GetDeviceHandle()
{
   return m_u32DeviceHandle;
}
/***************************************************************************
 ** FUNCTION:  DiPOBluetoothMsgBase::vSetDeviceHandle()
 ***************************************************************************/
t_Void DiPOBluetoothMsgBase::vSetDeviceHandle(t_U32 u32DevHndle)
{
   m_u32DeviceHandle = u32DevHndle;
}

/***************************************************************************
 ** FUNCTION:  DisableBluetoothMsg::DisableBluetoothMsg()
 ***************************************************************************/
DisableBluetoothMsg::DisableBluetoothMsg():enSessionTransport(e8_DIPO_SESSION_TRANSPORT_USB)
{
   memset(szBMACAddress,'\0',DIPO_MAX_STR_LEN);
   vAllocateMsg();
}

/***************************************************************************
 ** FUNCTION:  DisableBluetoothMsg::DisableBluetoothMsg()
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(DisableBluetoothMsg, spi_tclDiPOBluetoothDispatcher)

/***************************************************************************
 ** FUNCTION:  DisableBluetoothMsg::vAllocateMsg()
 ***************************************************************************/
t_Void DisableBluetoothMsg::vAllocateMsg(){}

/***************************************************************************
 ** FUNCTION:  DisableBluetoothMsg::vDeAllocateMsg()
 ***************************************************************************/
t_Void DisableBluetoothMsg::vDeAllocateMsg(){}

/***************************************************************************
 ** FUNCTION:  spi_tclDiPOBluetoothDispatcher::spi_tclDiPOBluetoothDispatcher()
 ***************************************************************************/
spi_tclDiPOBluetoothDispatcher::spi_tclDiPOBluetoothDispatcher()
{
   ETG_TRACE_USR1((" spi_tclDiPOBluetoothDispatcher::spi_tclDiPOBluetoothDispatcher()"));
}

/***************************************************************************
 ** FUNCTION:  spi_tclDiPOBluetoothDispatcher::~spi_tclDiPOBluetoothDispatcher()
 ***************************************************************************/
spi_tclDiPOBluetoothDispatcher::~spi_tclDiPOBluetoothDispatcher()
{
   ETG_TRACE_USR1((" spi_tclDiPOBluetoothDispatcher::~spi_tclDiPOBluetoothDispatcher()"));
}

/***************************************************************************
 ** FUNCTION:  spi_tclDiPOBluetoothDispatcher::vHandleBluetoothMsg(...
 ***************************************************************************/
t_Void spi_tclDiPOBluetoothDispatcher::vHandleBluetoothMsg(DisableBluetoothMsg* poDisableBluetoothMsg)const
{
   ETG_TRACE_USR1((" spi_tclDiPOSessionDispatcher::vHandleBluetoothMsg(DisableBluetoothMsg* poDisableBluetoothMsg)"));
   if (NULL != poDisableBluetoothMsg)
   {
      CALL_REG_OBJECTS(spi_tclDiPORespBluetooth,
               e16DIPO_BLUETOOTH_REGID,
               vOnDisableBluetooth(poDisableBluetoothMsg->szBMACAddress,poDisableBluetoothMsg->enSessionTransport));
   } // if (NULL != poSessionMsg)
}

/////////////////////////////////////<EOF>//////////////////////////////////////////
