/***********************************************************************/
/*!
* \file  spi_tclDiPORespBluetooth.h
* \brief DiPO Bluetooth Output Interface
*************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    DiPO Bluetooth Output Interface
AUTHOR:         Shiva Kumar Gurija
COPYRIGHT:      &copy; RBEI

HISTORY:
Date        | Author                | Modification
26.06.2017  | Shiva Kumar Gurija    | Initial Version

\endverbatim
*************************************************************************/
#ifndef _SPI_TCLDIPORESPBLUETOOTH_H_
#define _SPI_TCLDIPORESPBLUETOOTH_H_


/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/
#include "RespBase.h"
#include "RespRegister.h"
#include "DiPOTypes.h"

/******************************************************************************
| typedefs (scope: module-global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/


/****************************************************************************/
/*!
* \class spi_tclDiPORespBluetooth
* \brief DiPO Bluetooth Output Interface
*
* It provides an interface to SPI, To register for the bluetooth
* status updates and updates all the registered clients, whenever there is
* an update.
*
****************************************************************************/
class spi_tclDiPORespBluetooth:public RespBase
{
public:

   /***************************************************************************
   *********************************PUBLIC*************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  spi_tclDiPORespBluetooth::spi_tclDiPORespBluetooth()
   ***************************************************************************/
   /*!
   * \fn      spi_tclDiPORespBluetooth()
   * \brief   Constructor
   * \sa      ~spi_tclDiPORespBluetooth()
   **************************************************************************/
   spi_tclDiPORespBluetooth():RespBase(e16DIPO_BLUETOOTH_REGID){}

   /***************************************************************************
   ** FUNCTION:  spi_tclDiPORespBluetooth::~spi_tclDiPORespBluetooth()
   ***************************************************************************/
   /*!
   * \fn      virtual ~spi_tclDiPORespBluetooth()
   * \brief   Destructor
   * \param   t_Void
   * \sa      spi_tclDiPORespBluetooth(RegID enRegId)
   **************************************************************************/
   virtual ~spi_tclDiPORespBluetooth(){}

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclDiPORespBluetooth::vOnDisableBluetooth(...
   ***************************************************************************/
   /*!
   * \fn      virtual t_Void vOnDisableBluetooth(t_String szBTMACAddr,
   *                     ,tenDiPOSessionTransport enSessionTransport)
   * \brief   To Post the disableBluetooth update to registered clients
   * \param   szBTMACAddr : [IN] Unique ID of the device.
   * \param   enSessionTransport : [IN] Session transport
   * \retval  t_Void
   ***************************************************************************/
   virtual t_Void vOnDisableBluetooth(t_String /*szBTMACAddr*/,tenDiPOSessionTransport /*enSessionTransport*/){}

   /***************************************************************************
   ****************************END OF PUBLIC***********************************
   ***************************************************************************/

protected:

   /***************************************************************************
   *********************************PROTECTED**********************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  spi_tclDiPORespBluetooth::spi_tclDiPORespBluetooth()
   ***************************************************************************/
   /*!
   * \fn      spi_tclDiPORespBluetooth(const spi_tclDiPORespBluetooth& corfoSrc))
   * \brief   Parameterized Constructor
   * \param   corfoSrc : [IN] reference to source data interface object
   * \sa      spi_tclDiPORespBluetooth(RegID enRegId)
   **************************************************************************/
   spi_tclDiPORespBluetooth(const spi_tclDiPORespBluetooth& corfoSrc);

   /***************************************************************************
   ** FUNCTION:  spi_tclDiPORespBluetooth& operator=( const  spi_tclDiPO...
   ***************************************************************************/
   /*!
   * \fn      spi_tclDiPORespBluetooth& operator=(const spi_tclDiPORespBluetooth& corfoSrc))
   * \brief   Assignment operator
   * \param   corfoSrc : [IN] reference to source data interface object
   * \retval
   * \sa      spi_tclDiPORespBluetooth(const spi_tclDiPORespBluetooth& otrSrc)
   ***************************************************************************/
   spi_tclDiPORespBluetooth& operator=(const spi_tclDiPORespBluetooth& corfoSrc);


   /***************************************************************************
   ****************************END OF PROTECTED********************************
   ***************************************************************************/

private:

   /***************************************************************************
   *********************************PRIVATE************************************
   ***************************************************************************/


   /***************************************************************************
   ****************************END OF PRIVATE *********************************
   ***************************************************************************/

};


#endif //_SPI_TCLDIPORESPBLUETOOTH_H_
/////////////////////////////////////<EOF>//////////////////////////////////////////

