/***********************************************************************/
/*!
* \file  spi_tclDiPOAudioDispatcher.h
* \brief Message Dispatcher for Audio Messages. 
*************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Message Dispatcher for Audio Messages. 
AUTHOR:         Shiva Kumar Gurija
COPYRIGHT:      &copy; RBEI

HISTORY:
Date        | Author                | Modification
27.06.2017  | Shiva Kumar Gurija    | Initial Version

\endverbatim
*************************************************************************/


/***************************************************************************
 | includes:
 | 1)system- and project- includes
 | 2)needed interfaces from external components
 | 3)internal and external interfaces from this component
 |--------------------------------------------------------------------------*/
#include "SPITypes.h"
#include "DiPOTypes.h"
#include "RespRegister.h"
#include "spi_tclDiPOAudioDispatcher.h"
#include "spi_tclDiPORespAudio.h"

//! Includes for Trace files
#include "Trace.h"
#ifdef TARGET_BUILD
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_MSGQTHREADER
#include "trcGenProj/Header/spi_tclDiPOAudioDispatcher.cpp.trc.h"
#endif
#endif

/******************************************************************************
| typedefs (scope: module-global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: local)
|----------------------------------------------------------------------------*/
#define DEFINE_DISPATCH_MESSAGE_FUNCTION(COMMAND,DISPATCHER)\
t_Void COMMAND::vDispatchMsg(DISPATCHER* poDispatcher)      \
{                                                           \
   if (NULL != poDispatcher)                                \
   {                                                        \
      poDispatcher->vHandleAudioMsg(this);                  \
   }                                                        \
   vDeAllocateMsg();                                        \
}                                                           \

/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/

/***************************************************************************
 ** FUNCTION:  DiPOAudioMsgBase::DiPOAudioMsgBase()
 ***************************************************************************/
DiPOAudioMsgBase::DiPOAudioMsgBase(): m_u32DeviceHandle(0)
{
	vSetServiceID(e8_DIPO_WRAPPER_AUDIO);
}

/***************************************************************************
 ** FUNCTION:  DiPOAudioMsgBase::u32GetDeviceHandle()
 ***************************************************************************/
t_U32 DiPOAudioMsgBase::u32GetDeviceHandle()
{
   return m_u32DeviceHandle;
}
/***************************************************************************
 ** FUNCTION:  DiPOAudioMsgBase::vSetDeviceHandle()
 ***************************************************************************/
t_Void DiPOAudioMsgBase::vSetDeviceHandle(t_U32 u32DevHndle)
{
   m_u32DeviceHandle = u32DevHndle;
}

/***************************************************************************
 ** FUNCTION:  AudioAllocReq::AudioAllocReq()
 ***************************************************************************/
AudioAllocReq::AudioAllocReq():prDiPOAudioFormat(NULL)
{
   vAllocateMsg();
}

/***************************************************************************
 ** FUNCTION:  AudioAllocReq::vDispatchMsg()
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(AudioAllocReq, spi_tclDiPOAudioDispatcher)

/***************************************************************************
 ** FUNCTION:  AudioAllocReq::vAllocateMsg()
 ***************************************************************************/
t_Void AudioAllocReq::vAllocateMsg()
{
   prDiPOAudioFormat = new trDiPOAudioFormat;
   SPI_NORMAL_ASSERT(NULL == prDiPOAudioFormat);
}

/***************************************************************************
 ** FUNCTION:  AudioAllocReq::vDeAllocateMsg()
 ***************************************************************************/
t_Void AudioAllocReq::vDeAllocateMsg()
{
   RELEASE_MEM(prDiPOAudioFormat);
}


/***************************************************************************
 ** FUNCTION:  DuckAudioMsg::DuckAudioMsg()
 ***************************************************************************/
DuckAudioMsg::DuckAudioMsg()
{
   vAllocateMsg();
}

/***************************************************************************
 ** FUNCTION:  DuckAudioMsg::vDispatchMsg()
 ***************************************************************************/
DEFINE_DISPATCH_MESSAGE_FUNCTION(DuckAudioMsg, spi_tclDiPOAudioDispatcher)

/***************************************************************************
 ** FUNCTION:  DuckAudioMsg::vAllocateMsg()
 ***************************************************************************/
t_Void DuckAudioMsg::vAllocateMsg() { }

/***************************************************************************
 ** FUNCTION:  DuckAudioMsg::vDeAllocateMsg()
 ***************************************************************************/
t_Void DuckAudioMsg::vDeAllocateMsg() { }

/***************************************************************************
 ** FUNCTION:  spi_tclDiPOAudioDispatcher::spi_tclDiPOAudioDispatcher()
 ***************************************************************************/
spi_tclDiPOAudioDispatcher::spi_tclDiPOAudioDispatcher()
{
   ETG_TRACE_USR1((" spi_tclDiPOAudioDispatcher::spi_tclDiPOAudioDispatcher()"));
}

/***************************************************************************
 ** FUNCTION:  spi_tclDiPOAudioDispatcher::~spi_tclDiPOAudioDispatcher()
 ***************************************************************************/
spi_tclDiPOAudioDispatcher::~spi_tclDiPOAudioDispatcher()
{
   ETG_TRACE_USR1((" spi_tclDiPOAudioDispatcher::~spi_tclDiPOAudioDispatcher()"));
}

/***************************************************************************
 ** FUNCTION:  spi_tclDiPOAudioDispatcher::vHandleDiscoveryMsg(AudioAllocReq* poAudioAllocReq)
 ***************************************************************************/
t_Void spi_tclDiPOAudioDispatcher::vHandleAudioMsg(AudioAllocReq* poAudioAllocReq)const
{
   ETG_TRACE_USR1((" spi_tclDiPOAudioDispatcher::vHandleAudioMsg(AudioAllocReq* poAudioAllocReq)"));
   if ((NULL != poAudioAllocReq) && (NULL != poAudioAllocReq->prDiPOAudioFormat))
   {
      CALL_REG_OBJECTS(spi_tclDiPORespAudio,
               e16DIPO_AUDIO_REGID,
               vOnAudioAllocateRequest(poAudioAllocReq->enAudioChannelType,
			   poAudioAllocReq->enAudioType,
			   poAudioAllocReq->enAudioReqType,
			   *(poAudioAllocReq->prDiPOAudioFormat)));
   } // if (NULL != poDeviceListMsg)
}

/***************************************************************************
 ** FUNCTION:  spi_tclDiPOAudioDispatcher::vHandleDiscoveryMsg(DuckAudioMsg* poDuckAudioMsg)
 ***************************************************************************/
t_Void spi_tclDiPOAudioDispatcher::vHandleAudioMsg(DuckAudioMsg* poDuckAudioMsg)const
{
   ETG_TRACE_USR1((" spi_tclDiPOAudioDispatcher::vHandleAudioMsg(DuckAudioMsg* poDuckAudioMsg)"));
   if (NULL != poDuckAudioMsg)
   {
      CALL_REG_OBJECTS(spi_tclDiPORespAudio,
               e16DIPO_AUDIO_REGID,
               vOnDuckAudioMsg(poDuckAudioMsg->dFinalVolume,poDuckAudioMsg->dDurationInMs));
   } // if (NULL != poDeviceListMsg)
}

/////////////////////////////////////<EOF>//////////////////////////////////////////
