/***********************************************************************/
/*!
* \file  spi_tclDiPORespAudio.h
* \brief DiPO Audio Output Interface
*************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    DiPO Audio Output Interface
AUTHOR:         Shiva Kumar Gurija
COPYRIGHT:      &copy; RBEI

HISTORY:
Date        | Author                | Modification
09.03.2016  | Shiva Kumar Gurija    | Initial Version

\endverbatim
*************************************************************************/
#ifndef _SPI_TCLDIPORESPAUDIO_H_
#define _SPI_TCLDIPORESPAUDIO_H_


/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/
#include "RespBase.h"
#include "RespRegister.h"
#include "DiPOTypes.h"

/******************************************************************************
| typedefs (scope: module-global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/


/****************************************************************************/
/*!
* \class spi_tclDiPORespAudio
* \brief DiPO Audio Output Interface
*
* It provides an interface to SPI, To register for the Audio
* status updates and updates all the registered clients, whenever there is
* an update.
*
****************************************************************************/
class spi_tclDiPORespAudio:public RespBase
{
public:

   /***************************************************************************
   *********************************PUBLIC*************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  spi_tclDiPORespAudio::spi_tclDiPORespAudio()
   ***************************************************************************/
   /*!
   * \fn      spi_tclDiPORespAudio()
   * \brief   Constructor
   * \sa      ~spi_tclDiPORespAudio()
   **************************************************************************/
   spi_tclDiPORespAudio():RespBase(e16DIPO_AUDIO_REGID){}

   /***************************************************************************
   ** FUNCTION:  spi_tclDiPORespAudio::~spi_tclDiPORespAudio()
   ***************************************************************************/
   /*!
   * \fn      virtual ~spi_tclDiPORespAudio()
   * \brief   Destructor
   * \param   t_Void
   * \sa      spi_tclDiPORespAudio(RegID enRegId)
   **************************************************************************/
   virtual ~spi_tclDiPORespAudio(){}

   /***************************************************************************
    ** FUNCTION:  t_Void spi_tclDiPORespAudio::vOnAudioAllocateRequest(...
    ***************************************************************************/
   /*!
    * \fn      virtual t_Void vOnAudioAllocateRequest(AudioChannelType enAudioChannelType,
    *                         tenDiPOMainAudioType enAudioType,tenAudioReqType enAudioReqType,
    *                         const trDiPOAudioFormat& corfrDiPOAudioFormat)
    * \brief   To Post the Audio allocate/de-allocate request
    * \param   tenAudioChannelType : [IN] Audio channel type
    * \param   enAudioType : [IN] Alternate audio/ default audio
    * \param   enAudioReqType : [IN] Audio allocate/deallocate request
    * \param   corfrDiPOAudioFormat : [IN] Audio format which includes sample rate, bits per channel..
    * \retval  t_Void
    ***************************************************************************/
   virtual t_Void vOnAudioAllocateRequest(AudioChannelType /*enAudioChannelType*/,
            tenDiPOMainAudioType /*enAudioType*/,
            tenAudioReqType /*enAudioReqType*/,
            const trDiPOAudioFormat& /*corfrDiPOAudioFormat*/){}

   /***************************************************************************
    ** FUNCTION:  t_Void spi_tclDiPORespAudio::vOnDuckAudioMsg(...
    ***************************************************************************/
   /*!
    * \fn      virtual t_Void vOnDuckAudioMsg(t_Double dFinalVolume,
    *                         t_Double dDurationInMs)
    * \brief   To Post the duck audio request
    * \param   dFinalVolume : [IN] Final volume after ducking
    * \param   dDurationInMs : [IN] Ramp down duration in msec
    * \retval  t_Void
    ***************************************************************************/
   virtual t_Void vOnDuckAudioMsg(t_Double /*dFinalVolume*/,t_Double /*dDurationInMs*/){}

   /***************************************************************************
    ****************************END OF PUBLIC***********************************
   ***************************************************************************/

protected:

   /***************************************************************************
   *********************************PROTECTED**********************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  spi_tclDiPORespAudio::spi_tclDiPORespAudio()
   ***************************************************************************/
   /*!
   * \fn      spi_tclDiPORespAudio(const spi_tclDiPORespAudio& corfoSrc))
   * \brief   Parameterized Constructor
   * \param   corfoSrc : [IN] reference to source data interface object
   * \sa      spi_tclDiPORespAudio(RegID enRegId)
   **************************************************************************/
   spi_tclDiPORespAudio(const spi_tclDiPORespAudio& corfoSrc);

   /***************************************************************************
   ** FUNCTION:  spi_tclDiPORespAudio& operator=( const  spi_tclDiPO...
   ***************************************************************************/
   /*!
   * \fn      spi_tclDiPORespAudio& operator=(const spi_tclDiPORespAudio& corfoSrc))
   * \brief   Assignment operator
   * \param   corfoSrc : [IN] reference to source data interface object
   * \retval
   * \sa      spi_tclDiPORespAudio(const spi_tclDiPORespAudio& otrSrc)
   ***************************************************************************/
   spi_tclDiPORespAudio& operator=(const spi_tclDiPORespAudio& corfoSrc);


   /***************************************************************************
   ****************************END OF PROTECTED********************************
   ***************************************************************************/

private:

   /***************************************************************************
   *********************************PRIVATE************************************
   ***************************************************************************/


   /***************************************************************************
   ****************************END OF PRIVATE *********************************
   ***************************************************************************/

};


#endif //_SPI_TCLDIPORESPAUDIO_H_

/////////////////////////////////////<EOF>//////////////////////////////////////////

