
/***********************************************************************/
/*!
* \file  spi_tclDiPOCmdAudioIntf.h
* \brief Adapter class to send audio related events to CarPlayd process.
*************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Adapter class to send audio related events to CarPlayd process.
AUTHOR:         rry4kor
COPYRIGHT:      &copy; RBEI

HISTORY:
Date        | Author                | Modification
20.02.2019  | Ramya H R             | Unit Testing
\endverbatim
*************************************************************************/
#ifndef _SPI_TCLDIPOCMDAUDIOINTF_H_
#define _SPI_TCLDIPOCMDAUDIOINTF_H_
#include "BaseTypes.h"
#include "SPITypes.h"
#include "DiPOWrapperTypes.h"

/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/

/******************************************************************************
| typedefs (scope: module-global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/

/****************************************************************************/
/*!
* \class spi_tclDiPOCmdAudioIntf
* \brief Adapter class to send audio related events to CarPlayd process.
****************************************************************************/
class spi_tclDiPOCmdAudioIntf
{

public:

    /***************************************************************************
    *********************************PUBLIC*************************************
    ***************************************************************************/

    /***************************************************************************
    ** FUNCTION:  spi_tclDiPOCmdAudio::spi_tclDiPOCmdAudio()
    ***************************************************************************/
    /*!
    * \fn      spi_tclDiPOCmdAudio()
    * \brief   Default Constructor
    * \retval  t_Void
    * \sa      ~spi_tclDiPOCmdAudio()
    **************************************************************************/
    spi_tclDiPOCmdAudioIntf() {}

    /***************************************************************************
    ** FUNCTION:  spi_tclDiPOCmdAudio::~spi_tclDiPOCmdAudio()
    ***************************************************************************/
    /*!
    * \fn      ~spi_tclDiPOCmdAudio()
    * \brief   Destructor
    * \retval  t_Void
    * \sa      spi_tclDiPOCmdAudio()
    **************************************************************************/
    virtual ~spi_tclDiPOCmdAudioIntf() {}
	
    /***************************************************************************
     ** FUNCTION:  t_Bool spi_tclDiPOCmdAudio::bSendAudioAllocResponse(...
     ***************************************************************************/
    /*!
     * \fn      t_Bool bSendAudioAllocResponse(tenDiPOAudioAllocRespType enDiPOAudioAllocRespType,
     *                 tenAudioStreamType enAudioStreamType,t_String szAudioOutAlsaDevice,
     *                 t_String szAudioInAlsaDevice)
     * \brief   Method to send the response for Audio allocation request (prepare).
     * \param   enDiPOAudioAllocRespType : [IN] Enum to detail the response type.
     *                                          eg. Audio Error/AudioIn/Audio or Audio source is already available
     * \param   enDiPOAudioAllocRespType : [IN] Enum to detail the response type.
     * \param   enAudioStreamType : [IN] Main Audio/Alternate audio. Not valid for AudioIn response.
     * \param   szAudioOutAlsaDevice : [IN] Output Alsa device name.
     * \param   szAudioInAlsaDevice : [IN] Input Alsa device name. Valid only for AudioIn messages.
     * \retval  t_Bool
     **************************************************************************/
     virtual t_Bool bSendAudioAllocResponse(tenDiPOAudioAllocRespType enDiPOAudioAllocRespType,
             tenAudioStreamType enAudioStreamType,
             t_String szAudioOutAlsaDevice,
             t_String szAudioInAlsaDevice) =0;

    /***************************************************************************
     ** FUNCTION:  t_Void spi_tclDiPOCmdAudio::vSendStopAudioRequest(...
     ***************************************************************************/
    /*!
     * \fn      t_Void vSendStopAudioRequest(tenAudioReqType enAudioReqType)
     * \brief   Method to send the stop audio request to Phone.
     * \param   enAudioReqType : [IN] Audio allocation/de-allocation enum
     * \param   bIsDropAudio :   [IN] whether audio strem need to be blocked by platform
     * \retval  t_Void
     **************************************************************************/
    virtual t_Void vSendStopAudioRequest(tenAudioReqType enAudioReqType, t_Bool bIsDropAudio) = 0;


    /***************************************************************************
    ****************************END OF PUBLIC***********************************
    ***************************************************************************/


}; //class spi_tclDiPOCmdAudioIntf

#endif //_SPI_TCLDIPOCMDAUDIOINTF_H_

/////////////////////////////////////<EOF>//////////////////////////////////////////
