/***********************************************************************/
/*!
* \file  spi_tclDiPOAudioDispatcher.h
* \brief Message Dispatcher for Audio Messages. 
*************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Message Dispatcher for Audio Messages. 
AUTHOR:         Shiva Kumar Gurija
COPYRIGHT:      &copy; RBEI

HISTORY:
Date        | Author                | Modification
27.06.2017  | Shiva Kumar Gurija    | Initial Version

\endverbatim
*************************************************************************/
#ifndef _SPI_TCLDIPOAUDIODISPATCHER_H_
#define _SPI_TCLDIPOAUDIODISPATCHER_H_

/***************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|--------------------------------------------------------------------------*/
#include "DiPOTypes.h"
#include "DiPOWrapperTypes.h"
class spi_tclDiPOAudioDispatcher;

/******************************************************************************
| typedefs (scope: module-global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/

/****************************************************************************/
/*!
 * \class DiPOAudioMsgBase
 * \brief Base Message type for all Audio messages
 ****************************************************************************/
class DiPOAudioMsgBase: public trMsgBase
{
   public:
      /***************************************************************************
       ** FUNCTION:  DiPOAudioMsgBase::DiPOAudioMsgBase
       ***************************************************************************/
      /*!
       * \fn      DiPOAudioMsgBase()
       * \brief   Default constructor
       **************************************************************************/
      DiPOAudioMsgBase();

      /***************************************************************************
       ** FUNCTION:  DiPOAudioMsgBase::vDispatchMsg
       ***************************************************************************/
      /*!
       * \fn      vDispatchMsg(spi_tclDiPOAudioDispatcher* poDiscDispatcher)
       * \brief   Pure virtual function to be overridden by inherited classes for
       *          dispatching the message
       * \param poDiscDispatcher: pointer to Resource Manager Message Dispatcher
       **************************************************************************/
      virtual t_Void vDispatchMsg(spi_tclDiPOAudioDispatcher* poDiscDispatcher) = 0;

      /***************************************************************************
       ** FUNCTION:  DiPOAudioMsgBase::~DiPOAudioMsgBase
       ***************************************************************************/
      /*!
       * \fn      ~DiPOAudioMsgBase()
       * \brief   Destructor
       **************************************************************************/
      virtual ~DiPOAudioMsgBase()
      {

      }

      /***************************************************************************
       ** FUNCTION:  DiPOAudioMsgBase::u32GetDeviceHandle
       ***************************************************************************/
      /*!
       * \fn      u32GetDeviceHandle()
       * \brief   returns the device handle
       **************************************************************************/
      virtual t_U32 u32GetDeviceHandle();

      /***************************************************************************
       ** FUNCTION:  DiPOAudioMsgBase::vSetDeviceHandle
       ***************************************************************************/
      /*!
       * \fn      vSetDeviceHandle()
       * \brief   sets the device handle
       **************************************************************************/
      virtual t_Void vSetDeviceHandle(t_U32 u32DevHndle);

   private:
      t_U32 m_u32DeviceHandle;
};

/****************************************************************************/
/*!
 * \class AudioAllocReq
 * \brief AudioAllocReq update from Phone
 ****************************************************************************/
class AudioAllocReq: public DiPOAudioMsgBase
{
   public:
   
      //! Identify the type of the audio.
      AudioChannelType enAudioChannelType;

      //! type of the audio stream
      tenDiPOMainAudioType enAudioType;

      //!type of audio allocation
      tenAudioReqType enAudioReqType;

      //! Format of the audio satream requested.
      trDiPOAudioFormat *prDiPOAudioFormat;

      /***************************************************************************
       ** FUNCTION:  AudioAllocReq::AudioAllocReq()
       ***************************************************************************/
      /*!
       * \fn      AudioAllocReq()
       * \brief   Default constructor
       **************************************************************************/
      AudioAllocReq();

      /***************************************************************************
       ** FUNCTION:  AudioAllocReq::~AudioAllocReq()
       ***************************************************************************/
      /*!
       * \fn      ~AudioAllocReq()
       * \brief   AudioAllocReq
       **************************************************************************/
      virtual ~AudioAllocReq() {}

      /***************************************************************************
       ** FUNCTION:  AudioAllocReq::vDispatchMsg()
       ***************************************************************************/
      /*!
       * \fn      vDispatchMsg(spi_tclDiPOAudioDispatcher* poAudioDispatcher)
       * \brief   virtual function for dispatching the message of 'this' type
       * \param   poAudioDispatcher: pointer to Audio Message Dispatcher
       **************************************************************************/
      t_Void vDispatchMsg(spi_tclDiPOAudioDispatcher* poAudioDispatcher);

      /***************************************************************************
       ** FUNCTION:  AudioAllocReq::vAllocateMsg()
       ***************************************************************************/
      /*!
       * \fn      vAllocateMsg()
       * \brief   Allocates memory for non trivial datatypes (ex STL containers)
       * \sa      vDeAllocateMsg
       **************************************************************************/
      t_Void vAllocateMsg();

      /***************************************************************************
       ** FUNCTION:  AudioAllocReq::vDeAllocateMsg()
       ***************************************************************************/
      /*!
       * \fn      vDeAllocateMsg()
       * \brief   Destroys memory allocated by vAllocateMsg()
       * \sa      vAllocateMsg
       **************************************************************************/
      t_Void vDeAllocateMsg();
};


/****************************************************************************/
/*!
 * \class DuckAudioMsg
 * \brief DuckAudioMsg update from Phone
 ****************************************************************************/
class DuckAudioMsg: public DiPOAudioMsgBase
{
   public:
   
      //! Final volume after ducking the audio
      t_Double dFinalVolume;

      //! Duration in milli seconds
      t_Double dDurationInMs;

      /***************************************************************************
       ** FUNCTION:  DuckAudioMsg::DuckAudioMsg()
       ***************************************************************************/
      /*!
       * \fn      DuckAudioMsg()
       * \brief   Default constructor
       **************************************************************************/
      DuckAudioMsg();

      /***************************************************************************
       ** FUNCTION:  DuckAudioMsg::~DuckAudioMsg()
       ***************************************************************************/
      /*!
       * \fn      ~DuckAudioMsg()
       * \brief   DuckAudioMsg
       **************************************************************************/
      virtual ~DuckAudioMsg() {}

      /***************************************************************************
       ** FUNCTION:  DuckAudioMsg::vDispatchMsg()
       ***************************************************************************/
      /*!
       * \fn      vDispatchMsg(spi_tclDiPOAudioDispatcher* poAudioDispatcher)
       * \brief   virtual function for dispatching the message of 'this' type
       * \param   poAudioDispatcher: pointer to Audio Message Dispatcher
       **************************************************************************/
      t_Void vDispatchMsg(spi_tclDiPOAudioDispatcher* poAudioDispatcher);

      /***************************************************************************
       ** FUNCTION:  DuckAudioMsg::vAllocateMsg()
       ***************************************************************************/
      /*!
       * \fn      vAllocateMsg()
       * \brief   Allocates memory for non trivial datatypes (ex STL containers)
       * \sa      vDeAllocateMsg
       **************************************************************************/
      t_Void vAllocateMsg();

      /***************************************************************************
       ** FUNCTION:  DuckAudioMsg::vDeAllocateMsg()
       ***************************************************************************/
      /*!
       * \fn      vDeAllocateMsg()
       * \brief   Destroys memory allocated by vAllocateMsg()
       * \sa      vAllocateMsg
       **************************************************************************/
      t_Void vDeAllocateMsg();
};

/****************************************************************************/
/*!
 * \class spi_tclDiPOAudioDispatcher
 * \brief Message Dispatcher for Audio Messages implemented using
 *        double dispatch mechanism
 ****************************************************************************/
class spi_tclDiPOAudioDispatcher
{
   public:
      /***************************************************************************
       ** FUNCTION:  spi_tclDiPOAudioDispatcher::spi_tclDiPOAudioDispatcher
       ***************************************************************************/
      /*!
       * \fn      spi_tclDiPOAudioDispatcher()
       * \brief   Default constructor
       **************************************************************************/
      spi_tclDiPOAudioDispatcher();

      /***************************************************************************
       ** FUNCTION:  spi_tclDiPOAudioDispatcher::~spi_tclDiPOAudioDispatcher
       ***************************************************************************/
      /*!
       * \fn      ~spi_tclDiPOAudioDispatcher()
       * \brief   Destructor
       **************************************************************************/
      ~spi_tclDiPOAudioDispatcher();

      /***************************************************************************
       ** FUNCTION:  spi_tclDiPOAudioDispatcher::vHandleAudioMsg(...
       ***************************************************************************/
      /*!
       * \fn      vHandleAudioMsg(AudioAllocReq* poAudioAllocReq) const
       * \brief   Handles Messages of AudioAllocReq type
       * \param   poAudioAllocReq : pointer to AudioAllocReq
       **************************************************************************/
      t_Void vHandleAudioMsg(AudioAllocReq* poAudioAllocReq)const;
	  
      /***************************************************************************
       ** FUNCTION:  spi_tclDiPOAudioDispatcher::vHandleAudioMsg(...
       ***************************************************************************/
      /*!
       * \fn      vHandleAudioMsg(DuckAudioMsg* poDuckAudioMsg) const
       * \brief   Handles Messages of DuckAudioMsg type
       * \param   poDuckAudioMsg : pointer to DuckAudioMsg
       **************************************************************************/
      t_Void vHandleAudioMsg(DuckAudioMsg* poDuckAudioMsg)const;
      
};

#endif // _SPI_TCLDIPOAUDIODISPATCHER_H_

/////////////////////////////////////<EOF>//////////////////////////////////////////
