/***********************************************************************/
/*!
* \file  spi_tclDiPoAppMngr.h
* \brief DiPo App Mngr Implementation
*************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    DiPo App Mngr Implementation
AUTHOR:         Shiva Kumar Gurija
COPYRIGHT:      &copy; RBEI

HISTORY:
Date        | Author                | Modification
16.02.2014  | Shiva Kumar Gurija    | Initial Version

\endverbatim
*************************************************************************/


#ifndef _SPI_TCLDIPOAPPMNGR_H_
#define _SPI_TCLDIPOAPPMNGR_H_

/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/
#include "SPITypes.h"
#include "spi_tclAppMngrDev.h"
#include "spi_tclExtRespMetaData.h"
#include "spi_tclExtRespNavData.h"
#include "spi_tclDiPORespSession.h"
#include "Lock.h"
#include "Timer.h"

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

/****************************************************************************/
/*!
* \class spi_tclDiPoAppMngr
* \brief DiPo App Mngr Implementation
****************************************************************************/
class spi_tclDiPoAppMngr : public spi_tclAppMngrDev, public spi_tclExtRespMetaData, public spi_tclExtRespNavData , public spi_tclDiPORespSession
{
public:
   /***************************************************************************
   *********************************PUBLIC*************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  spi_tclDiPoAppMngr::spi_tclDiPoAppMngr()
   ***************************************************************************/
   /*!
   * \fn      spi_tclDiPoAppMngr()
   * \brief   Default Constructor
   * \sa      ~spi_tclDiPoAppMngr()
   **************************************************************************/
   spi_tclDiPoAppMngr();

  /***************************************************************************
   ** FUNCTION:  spi_tclDiPoAppMngr::~spi_tclDiPoAppMngr()
   ***************************************************************************/
   /*!
   * \fn      ~spi_tclDiPoAppMngr()
   * \brief   Destructor
   * \sa      spi_tclDiPoAppMngr()
   **************************************************************************/
   ~spi_tclDiPoAppMngr();
 
   /***************************************************************************
   ** FUNCTION:  t_Bool spi_tclDiPoAppMngr::bInitialize()
   ***************************************************************************/
   /*!
   * \fn      t_Bool bInitialize()
   * \brief   To Initialize all theDipo App Mngr related things
   * \retval  t_Bool
   * \sa      vUninitialize()
   **************************************************************************/
   t_Bool bInitialize();

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclDiPoAppMngr::vUnInitialize()
   ***************************************************************************/
   /*!
   * \fn      t_Void vUnInitialize()
   * \brief   To Uninitialize all the Dipo App Mngr related things
   * \retval  t_Void
   * \sa      bInitialize()
   **************************************************************************/
   t_Void vUnInitialize();

   /***************************************************************************
   ** FUNCTION:  t_Void  spi_tclDiPoAppMngr::vRegisterAppMngrCallbacks()
   ***************************************************************************/
   /*!
   * \fn      t_Void vRegisterAppMngrCallbacks(const trAppMngrCallbacks& corfrAppMngrCbs)
   * \brief   To Register for the asynchronous responses that are required from
   *          ML/DiPo App Mngr
   * \param   corfrAppMngrCbs : [IN] Application Manager callabcks structure
   * \retval  t_Void 
   **************************************************************************/
   t_Void vRegisterAppMngrCallbacks(const trAppMngrCallbacks& corfrAppMngrCbs);

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclDiPoAppMngr::vSelectDevice()
   ***************************************************************************/
   /*!
   * \fn      virtual t_Void vSelectDevice(const t_U32 cou32DevId,
   *          const tenDeviceConnectionReq coenConnReq)
   * \brief   To Subscribe/unsubscribe for events of the currently selected device
   * \param  corfrSelectReq : Device selection request details
   * \retval  t_Void
   **************************************************************************/
   t_Void vSelectDevice(const trSelectDeviceRequest& corfrSelectReq);

   /***************************************************************************
   ** FUNCTION:  t_Bool spi_tclDiPoAppMngr::bLaunchApp()
   ***************************************************************************/
   /*!
   * \fn      t_Bool bLaunchApp(const t_U32 cou32DevId, 
   *           t_U32 u32AppHandle, 
   *           tenDiPOAppType enDiPOAppType, 
   *           t_String szTelephoneNumber, 
   *           tenEcnrSetting enEcnrSetting)
   * \brief   To Launch the requested app 
   * \pram    cou32DevId  : [IN] Uniquely identifies the target Device.
   * \param  [IN] enDevCat : Device Type Information(Mirror Link/DiPO).
   * \param  [IN] u32AppHandle : Uniquely identifies an Application on
   *              the target Device. This value will be obtained from AppList Interface. 
   *              This value will be set to 0xFFFFFFFF if DeviceCategory = DEV_TYPE_DIPO.
   * \param  [IN] enDiPOAppType : Identifies the application to be launched on a DiPO device.
   *              This value will be set to NOT_USED if DeviceCategory = DEV_TYPE_MIRRORLINK.
   * \param  [IN] szTelephoneNumber : Number to be dialed if the DiPO application to be launched 
   *              is a phone application. If not valid to be used, this will be set to NULL, 
   *              zero length string. Will not be used if DeviceCategory = DEV_TYPE_MIRRORLINK.
   * \param  [IN] enEcnrSetting : Sets voice or server echo cancellation and noise reduction 
   *              settings if the DiPO application to be launched is a phone application. 
   *              If not valid to be used, this will be set to ECNR_NOCHANGE.
   * \retval  t_Bool
   * \sa      vTerminateApp()
   **************************************************************************/
   t_Void vLaunchApp(const t_U32 cou32DevId, 
      t_U32 u32AppHandle,
      const trUserContext& rfrcUsrCntxt, 
      tenDiPOAppType enDiPOAppType, 
      t_String szTelephoneNumber, 
      tenEcnrSetting enEcnrSetting);

     /***************************************************************************
   ** FUNCTION:  t_Void spi_tclDiPoAppMngr::vTerminateApp()
   ***************************************************************************/
   /*!
   * \fn      t_Void vTerminateApp(trUserContext rUserContext,
   *          t_U32 u32DeviceId, t_U32 u32AppId)
   * \brief   To Terminate an Application asynchronously.
   * \param   rUserContext : [IN] Context Message
   * \param   u32DeviceId  : [IN] Device Id
   * \param   u32AppId     : [IN] Application Id
   * \retval  t_Void
   * \sa      t_Bool bLaunchApp(t_U32 u32DeviceId, t_U32 u32AppId)
   **************************************************************************/
   t_Void vTerminateApp(const t_U32 cou32devId, 
      const t_U32 cou32AppId,
      const trUserContext& rfrcUsrCntxt);

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclDiPoAppMngr::vGetAppIconData()
   ***************************************************************************/
   /*!
   * \fn    virtual t_Void vGetAppIconData(t_String szAppIconUrl, 
   *         const trUserContext& rfrcUsrCntxt)
   * \brief  To Get the application icon data
   * \param  szAppIconUrl  : [IN] Application Icon data
   * \param  rfrcUsrCntxt  : [IN] User Context
   * \retval  t_Void
   **************************************************************************/
   t_Void vGetAppIconData(t_String szAppIconUrl, 
      const trUserContext& rfrcUsrCntxt);

   /***************************************************************************
   ** FUNCTION:  t_Bool spi_tclDiPoAppMngr::bCheckAppValidity()
   ***************************************************************************/
   /*!
   * \fn      t_Bool bCheckAppValidity(const t_U32 cou32DevId,
   *             const t_U32 cou32AppId)
   * \brief   To check whether the application exists or not
   * \pram    cou32DevId  : [IN] Uniquely identifies the target Device.
   * \param   cou32AppId  : [IN] Application Id
   * \retval  t_Bool
   **************************************************************************/
   t_Bool bCheckAppValidity(const t_U32 cou32DevId, 
      const t_U32 cou32AppId);

  /***************************************************************************
   ** FUNCTION: t_Void spi_tclDiPoAppMngr::vSetVehicleConfig()
   ***************************************************************************/
   /*!
   * \fn     t_Void vSetVehicleConfig(tenVehicleConfiguration enVehicleConfig,
   *          t_Bool bSetConfig,const trUserContext& corfrUsrCntxt)
   * \brief  Interface to set the Vehicle configurations.
   * \param  [IN] enVehicleConfig :  Identifies the Vehicle Configuration.
   * \param  [IN] bSetConfig      : Enable/Disable config
   **************************************************************************/
   virtual t_Void vSetVehicleConfig(tenVehicleConfiguration enVehicleConfig,
      t_Bool bSetConfig);

   //METADATA Change this when SPI implements external interface...

   t_Void vGetMediaObjectAlbumArt(const t_U32& corfu32DeviceHandle,
             const t_String& corfsAlbumArt, const trUserContext& corfrUsrCntxt);

   t_Void vAppMediaAlbumArtCb(const trAppMediaAlbumArt& rAppMediaAlbumArt, const trUserContext& rUserContext);

   t_Void vAppPhoneDataCb(
      const trAppPhoneData& rfcorApplicationPhoneData,
      const trUserContext& rfcorUsrCntxt) ;


   t_Void vAppMediaPlaytimeCb(
            const trAppMediaPlaytime& rfcorApplicationMediaPlaytime,
            const trUserContext& rfcorUsrCntxt);

   t_Void vAppMetaDataCallback(
            const trAppMediaMetaData& rfcorApplicationMediaMetaData,
            const trUserContext& rfcorUsrCntxt);

   t_Void vAppPhoneCallDataCb(
      const trAppPhoneCallData& rfcorApplicationPhoneCallData,
      const trUserContext& rfcorUsrCntxt) ;

   /***************************************************************************
   ** FUNCTION: t_Void vSetConfigData(const trConfigData& rfrConfigData)
   ***************************************************************************/
   /*!
   * \fn    t_Void vSetConfigData(const trConfigData& rfrConfigData)
   * \brief  Sets the Config data
   * \param  rfrConfigData : structure consisting of values to be set for
   *                         TBT updates
   ***************************************************************************/
   t_Void vSetConfigData(const trConfigData& rfrConfigData);

   /***************************************************************************
   ** FUNCTION: t_Bool spi_tclDiPoAppMngr::bOnRegRouteGuidanceDisplayConf()
   ***************************************************************************/
   /*!
    * \fn     bOnRegRouteGuidanceDisplayConf(const std::vector<trDiPORouteGuidanceDisplayComponent>& corfvecRouteGuidanceDisplayComponent)
    * \brief  Interface to send device list details
    * \param  [IN] corfvecRouteGuidanceDisplayComponent : registered display component list
    * \retval t_Bool  TRUE- Enabled FALSE-Disabled
    **************************************************************************/
   t_Bool bOnRegRouteGuidanceDisplayConf(const std::vector<trDiPORouteGuidanceDisplayComponent>& corfvecRouteGuidanceDisplayComponent);

   /***************************************************************************
    ** FUNCTION: t_Void spi_tclDiPoAppMngr::bOnStartRouteGuidanceUpdates
    ***************************************************************************/
   /*!
    * \fn     bOnStartRouteGuidanceUpdates(const trStartRouteGuidanceUpdates& corfStartRouteGuidanceUpdates)
    * \brief  Interface to start route guidance updates
    * \param  [IN] trStartRouteGuidanceUpdates : start route guidance parameters
    * \retval t_Bool  TRUE- Enabled FALSE-Disabled
    **************************************************************************/
    t_Bool bOnStartRouteGuidanceUpdates(trStartRouteGuidanceUpdates& corfStartRouteGuidanceUpdates);

    /***************************************************************************
     ** FUNCTION: t_Void spi_tclDiPoAppMngr::bOnStopRouteGuidanceUpdates
     ***************************************************************************/
    /*!
     * \fn     bOnStopRouteGuidanceUpdates(const trStopRouteGuidanceUpdates& corfStopRouteGuidanceUpdates)
     * \brief  Interface to stop route guidance updates
     * \param  [IN] trStartRouteGuidanceUpdates : stop route guidance paramaeters
     * \retval t_Bool  TRUE- Enabled FALSE-Disabled
     **************************************************************************/
     t_Bool bOnStopRouteGuidanceUpdates(trStopRouteGuidanceUpdates& corfStopRouteGuidanceUpdates);

     /***************************************************************************
     ** FUNCTION: t_Void vUpdatePhoneCallProgress()
     ***************************************************************************/
     /*!
     * \fn    t_Void vUpdatePhoneCallProgress()
     * \brief  increment phone call timer
     * \retval t_Void
     ***************************************************************************/
     t_Void vUpdatePhoneCallProgress();

     /***************************************************************************
     ** FUNCTION: t_Void vSendAppPhoneCallData()
     ***************************************************************************/
     /*!
     * \fn    t_Void vSendAppPhoneCallData()
     * \brief  Send PhoneCall Data to AppMngr Callback
     * \retval t_Void
     ***************************************************************************/
     t_Void vSendAppPhoneCallData();

     /***************************************************************************
     ** FUNCTION:  spi_tclDiPoAppMngr::vDisplayPhoneCallData()
     ***************************************************************************/
     /*!
     * \fn      vDisplayPhoneCallData()
     * \brief   Log PhoneCallData
     * \note    Log PhoneCallData
     **************************************************************************/
     t_Void vDisplayPhoneCallData();


   /***************************************************************************
   ****************************END OF PUBLIC***********************************
   ***************************************************************************/

protected:

   /***************************************************************************
   *********************************PROTECTED**********************************
   ***************************************************************************/

   /***************************************************************************
    ** FUNCTION:  t_Void spi_tclDiPoAppMngr::vPostAppMediaMetaDataMsg()
    ***************************************************************************/
   /*!
    * \fn      t_Void vPostAppMediaMetaDataMsg()
    * \brief   Called when DiPO Now Playing Status is detected
    * \param   rAppMediaMetaData: a trAppMediaMetaData type structure
    * \param   rUserContext: User context info
    * \sa      None
    **************************************************************************/
   t_Void vPostAppMediaMetaDataMsg(const trAppMediaMetaData &rfcoAppMediaMetaData, const trUserContext &rfcoUserContext);

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclDiPoAppMngr::vPostAppMediaAlbumArtMsg()
   ***************************************************************************/
  /*!
   * \fn      t_Void vPostAppMediaAlbumArtMsg()
   * \brief   Called when DiPO get media object album art
   * \param   rAppMediaAlbumArt: a trAppMediaAlbumArt type structure
   * \param   rUserContext: User context info
   * \sa      None
   **************************************************************************/
   t_Void vPostAppMediaAlbumArtMsg(const trAppMediaAlbumArt &rfcoAppMediaAlbumArt, const trUserContext &rfcoUserContext);

   /***************************************************************************
    ** FUNCTION:  t_Void spi_tclDiPoAppMngr::vPostAppMediaPlaytimeMsg()
    ***************************************************************************/
   /*!
    * \fn      t_Void vPostAppMediaPlaytimeMsg()
    * \brief   Called when DiPO Play time msg arrives.
    * \param   rfcorAppMediaPlaytime: a trAppMediaPlaytime type structure
    * \param   rfcorUsrCntxt: User context info
    * \sa      None
    **************************************************************************/
   t_Void vPostAppMediaPlaytimeMsg(const trAppMediaPlaytime &rfcoAppMediaPlaytime, const trUserContext &rfcoUserContext);

   /***************************************************************************
    ** FUNCTION:  t_Void spi_tclDiPoAppMngr::vPostAppPhoneDataMsg()
    ***************************************************************************/
   /*!
    * \fn      t_Void vPostAppPhoneDataMsg()
    * \brief   Called when DiPO Called state Status message arrives.
    * \param   rfcorApplicationPhoneData: a trAppPhoneData type structure
    * \param   rfcorUsrCntxt: User context info
    * \sa      None
    **************************************************************************/
   t_Void vPostAppPhoneDataMsg(const trAppPhoneData& rfcorAppPhoneData, const trUserContext &rfcoUserContext);

   /***************************************************************************
    ** FUNCTION:  t_Void spi_tclDiPoAppMngr::vPostAppPhoneCallDataMsg()
    ***************************************************************************/
   /*!
    * \fn      t_Void vPostAppPhoneCallDataMsg()
    * \brief   Called when DiPO CallstateStatus message arrives.
    * \param   rfcorApplicationPhoneCallData: a trAppPhoneCallData type structure
    * \param   rfcorUsrCntxt: User context info
    * \sa      None
    **************************************************************************/
   t_Void vPostAppPhoneCallDataMsg(const trAppPhoneCallData& rfcorAppPhoneCallData, const trUserContext &rfcoUserContext);

   /***************************************************************************
    ** FUNCTION:  t_Void spi_tclDiPoAppMngr::vPostAppDeviceTimeUpdateMsg()
    ***************************************************************************/
   /*!
    * \fn      t_Void vPostAppDeviceTimeUpdateMsg()
    * \brief   Called when DiPO Device Time message arrives.
    * \param   rfcoDeviceTime: start time of phone call with reference to device time
    * \sa      None
    **************************************************************************/
   t_Void vPostAppDeviceTimeUpdateMsg(const trDeviceTime& rfcoDeviceTime);

   /***************************************************************************
    ** FUNCTION:  t_Void spi_tclDiPoAppMngr::vPostDiPORouteGuidanceUpdateMsg()
    ***************************************************************************/
   /*!
    * \fn      t_Void vPostDiPORouteGuidanceUpdateMsg()
    * \brief   Called when DiPORouteGuidanceUpdate is sent by MediaPlayer Client Handler.
    * \param   corfrDiPORouteGuidanceUpdate: structure to hold trDiPORouteGuidanceUpdate
    * \sa      None
    **************************************************************************/
    t_Void vPostDiPORouteGuidanceUpdateMsg(const trDiPORouteGuidanceUpdate &corfrDiPORouteGuidanceUpdate);

    /***************************************************************************
     ** FUNCTION:  t_Void spi_tclDiPoAppMngr::vPostDiPORouteGuidanceManeuverUpdateMsg()
     ***************************************************************************/
    /*!
     * \fn      t_Void vPostDiPORouteGuidanceManeuverUpdateMsg()
     * \brief   Called when DiPORouteGuidanceManeuverUpdate is sent by MediaPlayer Client Handler.
     * \param   corfrDiPORouteGuidanceManeuverUpdate: structure to hold trDiPORouteGuidanceManeuverUpdate
     * \sa      None
     **************************************************************************/
     t_Void vPostDiPORouteGuidanceManeuverUpdateMsg(const trDiPORouteGuidanceManeuverUpdate &corfrDiPORouteGuidanceManeuverUpdate);

     /***************************************************************************
     ** FUNCTION:  t_Void spi_tclDiPoAppMngr::vOnSelectDeviceResult()
     ***************************************************************************/
     /*!
     * \fn      t_Void vOnSelectDeviceResult(const t_U32 cou32DevId,
     *                 const tenDeviceConnectionReq coenConnReq,
     *                 const tenResponseCode coenRespCode)
     * \brief   To perform the actions that are required, after the select device is
     *           successful
     * \param    cou32DevId  : [IN] Uniquely identifies the target Device.
     * \param    coenConnReq : [IN] Identifies the Connection Request.
     * \param    coenRespCode: [IN] Response code. Success/Failure
     * \retval  t_Void
     **************************************************************************/
     t_Void vOnSelectDeviceResult(const t_U32 cou32DevId, const tenDeviceConnectionReq coenConnReq, const tenResponseCode coenRespCode);

     /***************************************************************************
     ** FUNCTION:  t_Void spi_tclDiPoAppMngr::vRestoreSettings()
     ***************************************************************************/
     /*!
     * \fn      t_Void vRestoreSettings()
     * \brief   To clear private data on factory reset
     * \retval  t_Void
     **************************************************************************/
     t_Void vRestoreSettings();


   /***************************************************************************
   ****************************END OF PROTECTED********************************
   ***************************************************************************/

private:

   /***************************************************************************
   *********************************PRIVATE************************************
   ***************************************************************************/

     /***************************************************************************
     ** FUNCTION:  t_Void spi_tclDiPoConnection::vOnSessionMsg(...
     ***************************************************************************/
     /*!
     * \fn      t_Void vOnSessionMsg(tenDiPOSessionState enDiPOSessionState,
     *                                       tenDiPOSessionTransport enSessionTransport,
     *                                       t_String szSessionIPAddress)
     * \brief   To Post the session message to SPI, when the session state changes.
     * \param   enDiPOSessionState : [IN] Session State : Session Started,Session_Ended,
     *                                                    CarPlayd_PlugIn_Loaded or UnLoaded.
     * \param   enSessionTransport : [IN] Session is started over USB Transport or WiFi
     *                                    Applicable, only when SessionState is Session Started/ended.
     * \param   szSessionIPAddress : [IN] IP Address of the active carplay device.
     *                                    used, only if the Session Transport is WiFi
     * \retval  t_Void
     ***************************************************************************/
     t_Void vOnSessionMsg(tenDiPOSessionState enDiPOSessionState,
                                  tenDiPOSessionTransport enSessionTransport,
                                  t_String szSessionIPAddress);

   /***************************************************************************
   ** FUNCTION:  spi_tclDiPoAppMngr& spi_tclDiPoAppMngr::operator= (const..
   ***************************************************************************/
   /*!
   * \fn      spi_tclDiPoAppMngr& operator= (const spi_tclDiPoAppMngr &corfrSrc)
   * \brief   Assignment Operator, will not be implemented.
   * \note    This is a technique to disable the assignment operator for this class.
   *          So if an attempt for the assignment is made linker complains.
   * \param   corfrSrc : [IN] Source Object
   **************************************************************************/
   spi_tclDiPoAppMngr& operator= (const spi_tclDiPoAppMngr &corfrSrc);

   /***************************************************************************
   ** FUNCTION:  spi_tclDiPoAppMngr::spi_tclDiPoAppMngr(const spi_tclDiPoAppMngr..
   ***************************************************************************/
   /*!
   * \fn      spi_tclDiPoAppMngr(const spi_tclDiPoAppMngr &corfrSrc)
   * \brief   Copy constructor, will not be implemented.
   * \note    This is a technique to disable the Copy constructor for this class.
   * \param   corfrSrc : [IN] Source Object
   **************************************************************************/
   spi_tclDiPoAppMngr(const spi_tclDiPoAppMngr &corfrSrc);

   /***************************************************************************
   ** FUNCTION:  spi_tclDiPoAppMngr::vUpdateConfigInfo()
   ***************************************************************************/
   /*!
   * \fn      vUpdateConfigInfo(const tenVehicleConfiguration enVehicleConfig)
   * \brief   Copy constructor, will not be implemented.
   * \note    Function to update the values in config reader.
   * \param   enVehicleConfig : [IN] latest config value.
   **************************************************************************/
   t_Void vUpdateConfigInfo(const tenVehicleConfiguration enVehicleConfig);
   
   /***************************************************************************
   ** FUNCTION:  spi_tclDiPoAppMngr::vClearRouteGuidanceUpdates()
   ***************************************************************************/
   /*!
   * \fn      vClearRouteGuidanceUpdates()
   * \brief   Updates the HMI with cleared route guidance updates 
   * \note    Function to clear the route guidance updates on session termination.
   **************************************************************************/
   t_Void vClearRouteGuidanceUpdates();

   /***************************************************************************
   ** FUNCTION:  spi_tclDiPoAppMngr::vAppPhoneDataSyncList()
   ***************************************************************************/
   /*!
   * \fn      vAppPhoneDataSyncList()
   * \brief   synchronize the list
   * \note    Function to sync PhoneCallData vector in spi_tclDipoMngr with the
   *          new data received.
   **************************************************************************/
   t_Void vAppPhoneDataSyncList(const trAppPhoneCallData& rfcorPhoneCallExtendedMetadata);

   /***************************************************************************
   ** FUNCTION:  spi_tclDiPoAppMngr::vStartPhoneCallProgressTimer()
   ***************************************************************************/
   /*!
   * \fn      vStartPhoneCallProgressTimer()
   * \brief   Starts the phone call timer
   * \note    Function to start phone call timer.
   **************************************************************************/
   t_Void vStartPhoneCallProgressTimer();

   /***************************************************************************
   ** FUNCTION:  spi_tclDiPoAppMngr::vStopPhoneCallProgressTimer()
   ***************************************************************************/
   /*!
   * \fn      vStopPhoneCallProgressTimer()
   * \brief   Cancels the phone call timer
   * \note    Function to stop/cancel phone call timer.
   **************************************************************************/
   t_Void vStopPhoneCallProgressTimer();

   /***************************************************************************
   ** FUNCTION:  spi_tclDiPoAppMngr::vStartDeviceTimeProgressTimer()
   ***************************************************************************/
   /*!
   * \fn      vStartDeviceTimeProgressTimer()
   * \brief   Starts the device time timer
   * \note    Function to start device time timer.
   **************************************************************************/
   t_Void vStartDeviceTimeProgressTimer();

   /***************************************************************************
   ** FUNCTION:  spi_tclDiPoAppMngr::vStopDeviceTimeProgressTimer()
   ***************************************************************************/
   /*!
   * \fn      vStopDeviceTimeProgressTimer()
   * \brief   Cancels the device time timer
   * \note    Function to stop/cancel device time timer.
   **************************************************************************/
   t_Void vStopDeviceTimeProgressTimer();

   /***************************************************************************
   ** FUNCTION:  spi_tclDiPoAppMngr::vUpdateOffsetBasedOnStartTimeStamp()
   ***************************************************************************/
   /*!
   * \fn      vUpdateOffsetBasedOnStartTimeStamp()
   * \brief   Update the offset to CallProgressRefFromDevice
   * \note    Calculates the difference between StartTimeStamp received from
   *          the device and System TIme and updates it to CallProgressRefFromDevice
   **************************************************************************/
   t_Void vUpdateOffsetBasedOnStartTimeStamp();

   /***************************************************************************
   ** FUNCTION:  spi_tclDiPoAppMngr::vResetAllPhoneCallData()
   ***************************************************************************/
   /*!
   * \fn      vResetAllPhoneCallTimer()
   * \brief   reset phone call data
   * \note    reset phone call data.
   **************************************************************************/
   t_Void vResetAllPhoneCallData();

   /***************************************************************************
   ** FUNCTION: t_Void vResetPhoneCallProgressTimer()
   ***************************************************************************/
   /*!
   * \fn    t_Void vResetPhoneCallProgressTimer()
   * \brief  reset the phone call progress timer
   * \retval t_Void
   ***************************************************************************/
   t_Void vResetPhoneCallProgressTimer(trTime& rCallProgress);

   /***************************************************************************
   ** FUNCTION:  spi_tclDiPoAppMngr::vIncrementPhoneCallTimer()
   ***************************************************************************/
   /*!
   * \fn      vAdvanceTimeBySeconds()
   * \brief   increment phone call time by 1 second
   * \note    increment phone call time by 1 second.
   **************************************************************************/
   t_Void vIncrementPhoneCallTimer(trTime& rCallProgressTimer);

   /***************************************************************************
   ** FUNCTION:  spi_tclDiPoAppMngr::vIncrementCurrentDeviceTime ()
   ***************************************************************************/
   /*!
   * \fn      vIncrementCurrentDeviceTime ()
   * \brief   increment device time by 1 second
   * \note    increment device time by 1 second.
   **************************************************************************/
   t_Void vIncrementCurrentDeviceTime ();

   /***************************************************************************
   ** FUNCTION:  spi_tclDiPoAppMngr::bIsAnyCallInProgress()
   ***************************************************************************/
   /*!
   * \fn      bIsAnyCallInProgress()
   * \brief   Returns true if any call is ACTIVE or HELD state else returns false
   * \note    Returns true if any call is ACTIVE or HELD state else returns false
   **************************************************************************/
   t_Bool bIsAnyCallInProgress();

   /***************************************************************************
    ** FUNCTION:  spi_tclDiPoAppMngr::bPhoneCallTimerCb
    ***************************************************************************/
   /*!
    * \fn     bPhoneCallTimerCb
    * \brief  called on expiry of Phonecall timer timer
    * \param  rTimerID: ID of the timer which has expired
    * \param  pvObject: pointer to object passed while starting the timer
    * \param  pvUserData: data passed during start of the timer
    **************************************************************************/
   static t_Bool bPhoneCallTimerCb(timer_t rTimerID, t_Void *pvObject,
            const t_Void *pvUserData);

   /***************************************************************************
    ** FUNCTION:  spi_tclDiPoAppMngr::bDeviceTimeTimerCb
    ***************************************************************************/
   /*!
    * \fn     bDeviceTimeTimerCb
    * \brief  called on expiry of Device time timer timer
    * \param  rTimerID: ID of the timer which has expired
    * \param  pvObject: pointer to object passed while starting the timer
    * \param  pvUserData: data passed during start of the timer
    **************************************************************************/
   static t_Bool bDeviceTimeTimerCb(timer_t rTimerID, t_Void *pvObject,
            const t_Void *pvUserData);

   /***************************************************************************
   ** FUNCTION:  spi_tclDiPoAppMngr::vTriggerNowPlayingStatus()
   ***************************************************************************/
   /*!
   * \fn      vTriggerNowPlayingStatus()
   * \brief   Method to trigger Get DiPo Now Playing Status updates
   * \param   None
   **************************************************************************/
   t_Void vTriggerNowPlayingStatus();

   //! call back structure tos end response to Main App lmgr
   trAppMngrCallbacks m_rAppMngrCallbacks;

   //!Device Handle of selected device
   t_U32 m_u32SelDevHandle;

   //!Sturture for enabling TBT for CarPlay
   trConfigData m_bDiPOConfigData;

   //! Pending StartRouteGuidanceUpdates request
   trStartRouteGuidanceUpdates m_rStartRouteGuidanceUpdates;

   //!0 Structure to store PhoneCall Data
   trAppPhoneCallData m_rAppPhoneCallData;

   //!Lock for accessing m_rAppPhoneCallData
   Lock m_rAppPhoneCallDataLock;

   //!number of seconds since epoch received from device
   t_U64 m_u64CurrDeviceTimeInSeconds;

   //!Lock for accessing m_u64CurrDeviceTimeInSeconds
   Lock m_u64CurrDeviceTimeInSecondsLock;

   //! Timer ID and flag of timer for phone call timer
   timer_t m_rPhoneCallTimerID;

   //! Timer flag
   t_Bool m_bPhoneCallTimerRunning;

   //! Timer ID and flag of timer for device time received from connected device
   timer_t m_rDeviceTimeTimerID;

   //! Timer flag
   t_Bool m_bDeviceTimeTimerRunning;

   /***************************************************************************
   ****************************END OF PRIVATE *********************************
   ***************************************************************************/

};//spi_tclDiPoAppMngr


#endif //_SPI_TCLDIPOAPPMNGR_H_
