/***********************************************************************/
/*!
* \file  spi_tclDiPOAdapterMsgQInterface.cpp
* \brief Responsible to write the messages to Queue and creates thread which reads the messages written to Queue.
*************************************************************************
\verbatim

PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Responsible to write the messages to Queue and creates thread which reads the messages written to Queue.
AUTHOR:         Suraj P S
COPYRIGHT:      &copy; RBEI

HISTORY:
Date        | Author                | Modification
03.03.2019  | Suraj P S    | Initial Version

\endverbatim
*************************************************************************/

/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/
#include "MessageQueue.h"
#include "SPITypes.h"
#include "DiPOTypes.h"
#include "spi_tclDiPOAdapterMsgQInterface.h"

#include "spi_tclDiPOManager.h"
#include "spi_tclDiPODeviceMsgRcvr.h"

//! Includes for Trace files
#include "Trace.h"
   #ifdef TARGET_BUILD
      #ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
      #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_DIPO
      #include "trcGenProj/Header/spi_tclDiPOAdapterMsgQInterface.cpp.trc.h"
   #endif
#endif

/******************************************************************************
| typedefs (scope: module-global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| defines and macros (scope: local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/


/******************************************************************************
 ** FUNCTION:  spi_tclDiPOAdapterMsgQInterface::spi_tclDiPOAdapterMsgQInterface()
 ***************************************************************************/
spi_tclDiPOAdapterMsgQInterface::spi_tclDiPOAdapterMsgQInterface():m_poMsgQThreadable(NULL), m_poMsgQThreader(NULL)
{
   ETG_TRACE_USR1(("spi_tclDiPOAdapterMsgQInterface::spi_tclDiPOAdapterMsgQInterface()"));
   
   spi_tclDiPOManager* poDiPOManager = spi_tclDiPOManager::getInstance();
   if(poDiPOManager)
   {
	   m_poMsgQThreadable = poDiPOManager->poGetDeviceMsgRcvrInstance();
   }
   SPI_NORMAL_ASSERT(NULL == m_poMsgQThreadable);
   
   m_poMsgQThreader =  new(std::nothrow) MsgQThreader(m_poMsgQThreadable);
   SPI_NORMAL_ASSERT(NULL == m_poMsgQThreadable);
   
   if(NULL != m_poMsgQThreader)
   {
      m_poMsgQThreader->bRunThread();
      m_poMsgQThreader->vSetThreadName("CarplaydToSpi");
   }
}

/******************************************************************************
 ** FUNCTION:  spi_tclDiPOAdapterMsgQInterface::~spi_tclDiPOAdapterMsgQInterface()
 *****************************************************************************/
spi_tclDiPOAdapterMsgQInterface::~spi_tclDiPOAdapterMsgQInterface()
{
   ETG_TRACE_USR1((" spi_tclDiPOAdapterMsgQInterface::~spi_tclDiPOAdapterMsgQInterface()"));

   //Terminate the Message Queue threader before deleting it.
   if(NULL != m_poMsgQThreader)
   {
      MessageQueue *poMsgQ = m_poMsgQThreader->poGetMessageQueu();
      if(NULL != poMsgQ)
      {
         //trMsgQBase oMsgQTermMsg;
         //poMsgQ->s16Push(static_cast<t_Void*>(&oMsgQTermMsg),0,1,e8_TCL_THREAD_TERMINATE_MESSAGE);
         poMsgQ->s16Push(poMsgQ, sizeof(trMsgQBase), e8_TCL_THREAD_TERMINATE_MESSAGE);
      }//if(NULL != poMsgQ)

      //Wait for the message queue thread to join.
      Threader::vWaitForTermination(m_poMsgQThreader->pGetThreadID());

   }//if(NULL != m_poMsgQThreader)

   RELEASE_MEM(m_poMsgQThreader);
   RELEASE_MEM(m_poMsgQThreadable);
}

/******************************************************************************
 ** FUNCTION:  spi_tclDiPOAdapterMsgQInterface::bWriteMsgToQ(trMsgQBase *prMsgBase,t_U32 u32MsgSize)
 *****************************************************************************/
t_Bool spi_tclDiPOAdapterMsgQInterface::bWriteMsgToQ(trMsgQBase *prMsgBase,t_U32 u32MsgSize)
{
   ETG_TRACE_USR1((" spi_tclDiPOAdapterMsgQInterface::bWriteMsgToQ() entered" ));

   t_Bool bRetQ = false;

   if (NULL != m_poMsgQThreader)
   {
      //Get the MsgQ form threader and push the message to Q
      MessageQueue *poMsgQ = m_poMsgQThreader->poGetMessageQueu();
      if ((NULL != poMsgQ) && (NULL != prMsgBase))
      {
         t_S32 s32RetMsgQ = poMsgQ->s16Push(static_cast<t_Void*>(prMsgBase), u32MsgSize);
         bRetQ = (0 == s32RetMsgQ);
      } // if ((NULL != poMsgQ) && (NULL != prMsgBase))
   } //if (NULL != m_poMsgQThreader)

   if(bRetQ == false)
   {
      ETG_TRACE_ERR(("[ERR]:spi_tclDiPOAdapterMsgQInterface::bWriteMsgToQ():Write to MsgQ failed"));
   }

   return bRetQ;
}

///////////////////////////////////////////////// EOF //////////////////////////////////////////////
