/*!
 *******************************************************************************
 * \file              spi_tclDiPOVideoOutAdapterImpl.h
 * \brief             CarPlay video out adapter extended implementation for
 *                    HMI Synchronization.
 *******************************************************************************
 \verbatim
 PROJECT:        G3G
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    CarPlay VIDEO out adapter extended implementation
 COPYRIGHT:      &copy; RBEI

 HISTORY:
 Date       |  Author                      | Modifications
 17.11.2016 |  Noopur R K                  | Initial Version

 \endverbatim
 ******************************************************************************/

#include "DiPOTypes.h"
#include "Lock.h"
#include "gst/gstpad.h"
#include "GstreamerVideoOut.h"
#include <semaphore.h>
#ifndef SPI_TCLDIPOVIDEOOUTADAPTERIMPL_H
#define SPI_TCLDIPOVIDEOOUTADAPTERIMPL_H

/*#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
 #define ETG_DEFAULT_TRACE_CLASS TR_CLASS_SMARTPHONEINT_DIPO
 #endif
 */
/****************************************************************************/
/*!
 * \class spi_tclDiPOVideoOutAdapterImpl
 * \brief CarPlay video out adapter extended.
 *
 * spi_tclDiPOVideoOutAdapterImpl is the adapter implementation of IVideoOutAdapter.
 * IVideoOutAdapter is implemented in GstreamerVideoOut, and the spi_tclDiPOVideoOutAdapterImpl
 * is extending the implementation for adding additional funcionality.
 * @ Note : GstreamerVideoOut is a part of libcarplay_gstreamer_so.co
 ****************************************************************************/

class spi_tclDiPOVideoOutAdapterImpl: public GstreamerVideoOut
{
   public:
      /***************************************************************************
       ** FUNCTION:  spi_tclDiPOVideoOutAdapterImpl::spi_tclDiPOVideoOutAdapterImpl()
       ***************************************************************************/
      /*!
       * \fn     spi_tclDiPOVideoOutAdapterImpl()
       * \brief  Constructor
       * \sa     ~spi_tclDiPOVideoOutAdapterImpl()
       **************************************************************************/
      spi_tclDiPOVideoOutAdapterImpl();

      /***************************************************************************
       ** FUNCTION:  spi_tclDiPOVideoOutAdapterImpl::spi_tclDiPOVideoOutAdapterImpl()
       ***************************************************************************/
      /*!
       * \fn     ~spi_tclDiPOVideoOutAdapterImpl()
       * \brief  Destructor
       * \sa     spi_tclDiPOVideoOutAdapterImpl()
       **************************************************************************/
      virtual ~spi_tclDiPOVideoOutAdapterImpl();

      /***************************************************************************
       ** FUNCTION:  spi_tclDiPOAudioOutAdapterImpl::poGetInstance()
       ***************************************************************************/
      /*!
       * \fn     poGetInstance()
       * \brief  Return the handle of CarPlay audio out adapter implementation
       * \retVal spi_tclDiPOAudioOutAdapterImpl* : handle to the audio out adapter
       **************************************************************************/
      static spi_tclDiPOVideoOutAdapterImpl* poGetDiPOVideoAdapterInstance();
      /***************************************************************************
       ** FUNCTION:  spi_tclDiPOAudioOutAdapterImpl::vStop()
       ***************************************************************************/
      /*!
       * \fn     vStop()
       * \brief  To stop the video playback through the audio output channel
       * \retVal t_Void
       **************************************************************************/
      t_Void Stop();

      /***************************************************************************
       ** FUNCTION:  spi_tclDiPOAudioOutAdapterImpl::vNativeVideoRenderingStatus()
       ***************************************************************************/
      /*!
       * \fn     vNativeVideoRenderingStatus()
       * \brief  To update the state of native video rendering.
       * \retVal t_Void
       **************************************************************************/
      t_Void vNativeVideoRenderingStatus(tenNativeVideoRenderingStatus enNativeVideoRenderingStatus);

   private:
      /***************************************************************************
       ** FUNCTION: t_Bool spi_tclDiPOVideoOutAdapterImpl::bSendMessage()
       ***************************************************************************/
      /*!
       * \fn     bSendMessage(trMsgQBase &rfoMsgQBase)
       * \brief  Send the IPC message to SPI component.
       * \param  rMessage : [IN]Message data
       * \retVal  t_Bool : True if message send success, false otherwise
       * \sa
       **************************************************************************/
      template<typename trMessage>
      t_Bool bSendMessage(trMessage rMessage);

      static spi_tclDiPOVideoOutAdapterImpl * m_poVideoOutAdapter;

      sem_t m_DiPOVideoRenderingSem;

      t_Bool m_bVideoRenderingLockStatus;

      //Lock m_oVideoRendering;

};
#endif
