/***********************************************************************/
/*!
* \file  spi_tclWiFiSettingsIntf.h
* \brief  Implementation of the Class spi_tclWiFiSettingsIntf
*************************************************************************
\verbatim


PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Interface class for Wifi Settings
AUTHOR:         kmo6kor
COPYRIGHT:      &copy; 2017 Robert Bosch Car Multimedia GmbH
HISTORY:
Date        | Author                | Modification
07.06.2018    kmo6kor			    Initial Version
\endverbatim
*************************************************************************/


/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/
/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/
#ifndef SPI_TCLWIFISETTINGSINTF_
#define SPI_TCLWIFISETTINGSINTF_

#include "spi_tclCommonSettingsIntf.h"

class spi_tclWiFiSettingsIntf : public virtual spi_tclCommonSettingsIntf
{

public:

   /***************************************************************************
   ****************************PUBLIC *********************************
   ***************************************************************************/

   /***************************************************************************
    ** FUNCTION: spi_tclWiFiSettingsIntf::spi_tclWiFiSettingsIntf()
    ***************************************************************************/
   /*!
    * \fn      spi_tclWiFiSettingsIntf()
    * \brief   Constructor
    * \param   None
    **************************************************************************/
	spi_tclWiFiSettingsIntf(){}

   /***************************************************************************
    ** FUNCTION: spi_tclWiFiSettingsIntf::~spi_tclWiFiSettingsIntf()
    ***************************************************************************/
   /*!
    * \fn      ~spi_tclWiFiSettingsIntf()
    * \brief   Destructor
    * \param   None
    **************************************************************************/
   virtual ~spi_tclWiFiSettingsIntf(){}

   /***************************************************************************
   ** FUNCTION:  virtual t_Bool spi_tclWiFiSettingsIntf::bSetUpAPonOOBT(const t_String coszVehicleModelName)
   ***************************************************************************/
   /*!
   * \fn      virtual t_Bool bSetUpAPonOOBT(const t_String coszVehicleModelName)
   * \brief   Method to Read the OOBT Enabled.
   * \param   NONE
   * \retval  t_Bool
   **************************************************************************/
   virtual t_Bool bSetUpAPonOOBT() = 0;

   /***************************************************************************
   ****************************END OF  PUBLIC *********************************
   ***************************************************************************/

};
#endif //SPI_TCLWIFISETTINGSINTF_
