/***********************************************************************/
/*!
* \file  spi_tclVideoSettingsIntf.h
* \brief  Implementation of the Class spi_tclVideoSettingsIntf
*************************************************************************
\verbatim


PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Interface class for Video Settings
AUTHOR:         kmo6kor
COPYRIGHT:      &copy; 2017 Robert Bosch Car Multimedia GmbH
HISTORY:
Date        | Author                | Modification
07.06.2018   kmo6kor			    Initial Version
\endverbatim
*************************************************************************/


/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/
/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/
#ifndef SPI_TCLVIDEOSETTINGSINTF_
#define SPI_TCLVIDEOSETTINGSINTF_

#include "spi_tclCommonSettingsIntf.h"

class spi_tclVideoSettingsIntf : public virtual spi_tclCommonSettingsIntf
{

public:

   /***************************************************************************
   ****************************PUBLIC *********************************
   ***************************************************************************/

   /***************************************************************************
    ** FUNCTION: spi_tclVideoSettingsIntf::spi_tclVideoSettingsIntf()
    ***************************************************************************/
   /*!
    * \fn      spi_tclVideoSettingsIntf()
    * \brief   Constructor
    * \param   None
    **************************************************************************/
   spi_tclVideoSettingsIntf(){}

   /***************************************************************************
    ** FUNCTION: spi_tclVideoSettingsIntf::~spi_tclVideoSettingsIntf()
    ***************************************************************************/
   /*!
    * \fn      ~spi_tclVideoSettingsIntf()
    * \brief   Destructor
    * \param   None
    **************************************************************************/
   virtual ~spi_tclVideoSettingsIntf(){}

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclVideoSettingsIntf::vGetScreenOffset(t_U32& u32Scre...
   ***************************************************************************/
   /*!
   * \fn      t_Void vGetScreenOffset(t_U32& u32Screen_X_Offset,
   *          t_U32& u32Screen_Y_Offset)
   * \brief   To Get the Screen Offsets
   * \param   u32Screen_X_Offset : [OUT] X Offset
   * \param   u32Screen_Y_Offset : [OUT] Y Offset
   * \retval  t_Void
   * \sa
   **************************************************************************/
   virtual t_Void vGetScreenOffset(trScreenOffset &rfoScreenOffset) const = 0;


   /***************************************************************************
   ** FUNCTION:  t_Bool spi_tclVideoSettingsIntf::bIsServerSideScalingRequired()
   ***************************************************************************/
   /*!
   * \fn      t_Bool bIsServerSideScalingRequired()
   * \brief   To Check whether the server side scaling required
   * \retval  t_Bool : false if the scaling is not required, else true
   **************************************************************************/
   virtual t_Bool bIsServerSideScalingRequired() = 0;

   /***************************************************************************
   ** FUNCTION:  t_String spi_tclVideoSettingsIntf::szGetVideoCodecType()
   ***************************************************************************/
   /*!
   * \fn      t_String szGetVideoCodecType()
   * \brief   To get the video codec type
   *          before the device is selected for the session
   * \retval  t_String
   **************************************************************************/
   virtual t_String szGetVideoCodecType() const = 0;

   /***************************************************************************
   ** FUNCTION:  t_U8 spi_tclVideoSettingsIntf::u8GetMaxUnackedFrames()
   ***************************************************************************/
   /*!
   * \fn      t_U8 u8GetMaxUnackedFrames()
   * \brief   To get the max number of frames that can be recieved with out ack
   * \retval  t_U8
   **************************************************************************/
   virtual t_U8 u8GetMaxUnackedFrames() const = 0;


   /***************************************************************************
   ** FUNCTION: t_Bool spi_tclVideoSettingsIntf::bGetAutoStartProjection()
   ***************************************************************************/
   /*!
   * \fn      t_Bool bGetAutoStartProjection()
   * \brief   To get whether the auto projection start is enabled or not
   * \retval  t_Bool
   **************************************************************************/
   virtual t_Bool bGetAutoStartProjection() const = 0;

   /***************************************************************************
   ** FUNCTION:  t_U8 spi_tclVideoSettingsIntf::u8GetFramesPerSec()
   ***************************************************************************/
   /*!
   * \fn      t_U8 u8GetFramesPerSec()
   * \brief   To get the frame per pixel rate
   * \retval  t_U8
   **************************************************************************/
   virtual t_U8 u8GetFramesPerSec() const = 0;

   /***************************************************************************
   ** FUNCTION:  t_U8 spi_tclVideoSettingsIntf::u8GetContAttestSignFlag()
   ***************************************************************************/
   /*!
   * \fn      t_U8 u8GetContAttestSignFlag()
   * \brief   To get the Content attestation info signed flag
   * \retval  t_U8
   **************************************************************************/
   virtual t_U8 u8GetContAttestSignFlag() const = 0;

   /***************************************************************************
   ** FUNCTION:  tenPixelFormat spi_tclVideoSettingsIntf::enGetPixelFormat()
   ***************************************************************************/
   /*!
   * \fn      tenPixelFormat enGetPixelFormat()
   * \brief   To get the pixel format for display
   * \retval  tenPixelFormat
   **************************************************************************/
   virtual tenPixelFormat enGetPixelFormat() const = 0;

   /***************************************************************************
   ** FUNCTION: t_Void spi_tclVideoSettingsIntf::vGetBdclVideoSinkConfig()
   ***************************************************************************/
   /*!
   * \fn     vGetBdclVideoSinkConfig()
   * \brief  To Get BDCL VR Video Sink configuration
   * \retval  t_Void
   **************************************************************************/
   virtual t_Void vGetBdclVideoSinkConfig(std::map< t_String, t_String >& mapVideoConfig) const = 0;

   /***************************************************************************
   ** FUNCTION: t_Void spi_tclVideoSettingsIntf::vDisplayVideoSettings()
   ***************************************************************************/
   /*!
   * \fn     t_Void vDisplayVideoSettings()
   * \brief  To print the video settings data
   * \retval  t_Void
   **************************************************************************/
   virtual t_Void vDisplayVideoSettings() = 0;

   /***************************************************************************
   ****************************END OF PUBLIC *********************************
   ***************************************************************************/
};
#endif //SPI_TCLVIDEOSETTINGSINTF_
