/***********************************************************************/
/*!
* \file  spi_tclInputHandlerSettingsIntf.h
* \brief  Implementation of the Class spi_tclInputHandlerSettingsIntf
*************************************************************************
\verbatim


PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Interface class for Input Settings
AUTHOR:         kmo6kor
COPYRIGHT:      &copy; 2017 Robert Bosch Car Multimedia GmbH
HISTORY:
Date        | Author                | Modification
07.06.2018    kmo6kor			       Initial Version
\endverbatim
*************************************************************************/


/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/
/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/
#ifndef SPI_TCLINPUTHANDLERSETTINGSINTF_
#define SPI_TCLINPUTHANDLERSETTINGSINTF_

#include <set>
#include "spi_tclCommonSettingsIntf.h"

class spi_tclInputHandlerSettingsIntf : public virtual spi_tclCommonSettingsIntf
{
   /***************************************************************************
   ****************************PUBLIC *********************************
   ***************************************************************************/

public:
   /***************************************************************************
    ** FUNCTION: spi_tclInputHandlerSettingsIntf::spi_tclInputHandlerSettingsIntf()
    ***************************************************************************/
   /*!
    * \fn      spi_tclInputHandlerSettingsIntf()
    * \brief   Constructor
    * \param   None
    **************************************************************************/
   spi_tclInputHandlerSettingsIntf(){}

   /***************************************************************************
    ** FUNCTION: spi_tclInputHandlerSettingsIntf::~spi_tclInputHandlerSettingsIntf()
    ***************************************************************************/
   /*!
    * \fn      ~spi_tclInputHandlerSettingsIntf()
    * \brief   Destructor
    * \param   None
    **************************************************************************/
   virtual ~spi_tclInputHandlerSettingsIntf(){}

   /***************************************************************************
    ** FUNCTION:  t_Bool spi_tclInputHandlerSettingsIntf::bGetRotaryCtrlSupport()
    ***************************************************************************/
   /*!
    * \fn      t_Bool bGetRotaryCtrlSupport()
    * \brief   Method to know if Rotary Controller is supported
    * \param   NONE
    * \retval  t_Bool
    **************************************************************************/
   virtual t_Bool bGetRotaryCtrlSupport() = 0;

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclInputHandlerSettingsIntf::vRegisterKeyCodes()
   ***************************************************************************/
   /*!
   * \fn     vRegisterKeyCodes()
   * \brief  Function to Register KeyInfo into Datapool
   * \param  corfrmapTechSuppHardkeys[IN] : Map of Hard Keys supported for technologies
   * \param  corfrmapTechSuppSoftkeys[IN] : Map of Soft Keys supported for technologies
   * \retval  None
   **************************************************************************/
   virtual t_Void vRegisterKeyCodes(const std::map<tenDeviceCategory,std::set<tenKeyCode>>& corfrmapTechSuppHardkeys,
                                    const std::map<tenDeviceCategory,std::set<tenKeyCode>>& corfrmapTechSuppSoftkeys) = 0;

   /***************************************************************************
   ** FUNCTION:  t_Bool spi_tclInputHandlerSettingsIntf::bGetKeyInfo()
   ***************************************************************************/
   /*!
   * \fn     bGetKeyInfo()
   * \brief  Function to Get the KeyInfo.
   * \param  rfrsetKeyCodes:[OUT] Keys supported
   * \param  enCategory:[IN] For Which Technology
   * \retval t_Bool
   **************************************************************************/
   virtual t_Bool bGetKeyInfo(std::set<tenKeyCode>& rfrsetKeyCodes,tenDeviceCategory enCategory) = 0;

  /***************************************************************************
   ** FUNCTION:  t_Bool spi_tclInputHandlerSettingsIntf::bGetSoftKeyInfo()
   ***************************************************************************/
   /*!
   * \fn     bGetSoftKeyInfo()
   * \brief  Function to Get the Soft KeyInfo.
   * \param  rfrsetKeyCodes:[OUT] Keys supported
   * \param  enCategory:[IN] For Which Technology
   * \retval t_Bool
   **************************************************************************/
   virtual t_Bool bGetSoftKeyInfo(std::set<tenKeyCode>& rfrsetKeyCodes,tenDeviceCategory enCategory) = 0;


   /***************************************************************************
   ****************************END OF PUBLIC *********************************
   ***************************************************************************/

};
#endif //SPI_TCLINPUTHANDLERSETTINGSINTF_
