/***********************************************************************/
/*!
 * \file  spi_tclDiscovererSettingsIntf.h
 * \brief  Implementation of the Class spi_tclDiscovererSettingsIntf.h
 *************************************************************************
 \verbatim


 PROJECT:        Gen3
 SW-COMPONENT:   Smart Phone Integration
 DESCRIPTION:    Interface class to get Discoverer Settings
 AUTHOR:         kmo6kor
 COPYRIGHT:      &copy; 2017 Robert Bosch Car Multimedia GmbH
 HISTORY:
 Date        | Author                | Modification
 3.08.2018     kmo6kor	              Initial Version
 \endverbatim
 *************************************************************************/

/******************************************************************************
 | typedefs (scope: module-local)
 |----------------------------------------------------------------------------*/
/******************************************************************************
 | defines and macros (scope: global)
 |----------------------------------------------------------------------------*/
#ifndef SPI_TCLDISCOVERERSETTINGSINTF_
#define SPI_TCLDISCOVERERSETTINGSINTF_

#include "spi_tclCommonSettingsIntf.h"

class spi_tclDiscovererSettingsIntf: public virtual spi_tclCommonSettingsIntf
{

   public:

      /***************************************************************************
       ****************************PUBLIC *********************************
       ***************************************************************************/

      /***************************************************************************
       ** FUNCTION: spi_tclDiscovererSettingsIntf::spi_tclDiscovererSettingsIntf()
       ***************************************************************************/
      /*!
       * \fn      spi_tclDiscovererSettingsIntf()
       * \brief   Constructor
       * \param   None
       **************************************************************************/
      spi_tclDiscovererSettingsIntf()
      {
      }

      /***************************************************************************
       ** FUNCTION:  spi_tclDiscovererSettingsIntf:: ~spi_tclDiscovererSettingsIntf()
       ***************************************************************************/
      /*!
       * \fn      ~spi_tclDiscovererSettingsIntf()
       * \brief   Destructor
       * \param   None
       **************************************************************************/
      virtual ~spi_tclDiscovererSettingsIntf()
      {
      }

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclDiscovererSettingsIntf::vGetUSBPortsEnabledStatus(t_Bool &bUSBPort1,t_Bool &bUSBPort2,t_Bool &bUSBPort3)
       ***************************************************************************/
      /*!
       * \fn     t_Void vGetUSBPortsEnabledStatus()
       * \brief  to check whether the PORT is enabled/disabled
       **************************************************************************/
      virtual t_Void vGetUSBPortsEnabledStatus(t_Bool &bUSBPort1, t_Bool &bUSBPort2, t_Bool &bUSBPort3) = 0;

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclDiscovererSettingsIntf::vIntializeSPISettings
       ***************************************************************************/
      /*!
       * \fn     t_Void vIntializeSPISettings()
       * \brief  Reads settings from xml file and store it internally
       **************************************************************************/
      virtual t_Void vIntializeSPISettings() = 0;

      /***************************************************************************
       ** FUNCTION:  t_Bool spi_tclDiscovererSettingsIntf::bIsDeviceBlacklisted
       ***************************************************************************/
      /*!
       * \fn     t_Bool bIsDeviceBlacklisted()
       * \brief  to check whether  the device is blacklisted.
       **************************************************************************/
      virtual t_Bool bIsDeviceBlacklisted(t_S32 s32ProductID, t_S32 s32VendorID, tenDeviceCategory enDeviceCtegory =
               e8DEV_TYPE_DEFAULT) = 0;

      /***************************************************************************
       ** FUNCTION:  t_Void spi_tclDiscovererSettingsIntf::vIsDeviceWhitelisted(...
       ***************************************************************************/
      /*!
       * \fn     t_Void vIsDeviceWhitelisted()
       * \brief  to check whether the connected device is whitelisted or not and return category
       **************************************************************************/
      virtual t_Void vIsDeviceWhitelisted(t_S32 s32ProductID, t_S32 s32VendorID, tenDeviceCategory &rfenDevCat) = 0;

      /***************************************************************************
       ** FUNCTION:  t_Bool spi_tclDiscovererSettingsIntf::bIsDeviceWhitelistingEnabled(...
       ***************************************************************************/
      /*!
       * \fn     t_Bool bIsDeviceWhitelistingEnabled()
       * \brief  to check whether the whitelisting is enabled for a project or not
       **************************************************************************/
      virtual t_Bool bIsDeviceWhitelistingEnabled() = 0;

      /***************************************************************************
       ** FUNCTION:  t_Bool spi_tclDiscovererSettingsIntf::bIsWhitelistEnabledCat(...
       ***************************************************************************/
      /*!
       * \fn     t_Bool bIsWhitelistEnabledCat()
       * \brief  to set the category for which whitelisting is enabled
       **************************************************************************/
      virtual t_Bool bIsWhitelistEnabledCat(tenDeviceCategory enChosenDeviceCategory) = 0;

      /***************************************************************************
       ** FUNCTION:  t_Bool spi_tclDiscovererSettingsIntf::bIsDeviceWhitelisted
       ***************************************************************************/
      /*!
       * \brief  check if the device is whitelisted based on VID and PID of device
       * \param  [IN] u32ProductID :Product ID
       * \param  [IN] u32VendorID : Vendor ID
       * \param  [IN] enReqDevCat : Device Category
       ***************************************************************************/
      virtual t_Bool bIsDeviceWhitelisted(t_U32 u32ProductID, t_U32 u32VendorID, tenDeviceCategory enReqDevCat) = 0;

      /***************************************************************************
       ****************************END OF PUBLIC *********************************
       ***************************************************************************/

};
#endif //SPI_TCLDISCOVERERSETTINGSINTF_
