/***********************************************************************/
/*!
* \file  spi_tclDefaultSettingsIntf.h
* \brief  Implementation of the Class spi_tclDefaultSettingsIntf.h
*************************************************************************
\verbatim


PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Interface class for Default Settings
AUTHOR:         kmo6kor
COPYRIGHT:      &copy; 2017 Robert Bosch Car Multimedia GmbH
HISTORY:
Date        | Author                | Modification
3.08.2018     kmo6kor	              Initial Version                                               
\endverbatim
*************************************************************************/


/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/
/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/
#ifndef SPI_TCLDEFAULTSETTINGSINTF_
#define SPI_TCLDEFAULTSETTINGSINTF_

#include "spi_tclCommonSettingsIntf.h"

class spi_tclDefaultSettingsIntf: public virtual spi_tclCommonSettingsIntf 
{

public:

   /***************************************************************************
   ****************************PUBLIC *********************************
   ***************************************************************************/

   /***************************************************************************
    ** FUNCTION: spi_tclDefaultSettingsIntf::spi_tclDefaultSettingsIntf()
    ***************************************************************************/
   /*!
    * \fn      spi_tclDefaultSettingsIntf()
    * \brief   Constructor
    * \param   None
    **************************************************************************/
   spi_tclDefaultSettingsIntf(){}

   /***************************************************************************
    ** FUNCTION: spi_tclDefaultSettingsIntf::~spi_tclDefaultSettingsIntf()
    ***************************************************************************/
   /*!
    * \fn      ~spi_tclDefaultSettingsIntf()
    * \brief   Destructor
    * \param   None
    **************************************************************************/
   virtual ~spi_tclDefaultSettingsIntf(){}

   /***************************************************************************
   ** FUNCTION:  t_Bool spi_tclDefaultSettingsIntf::bGetMLNotiSettingVal()
   ***************************************************************************/
   /*!
   * \fn     t_Bool bGetMLNotiSettingVal()
   * \brief  To get the default ML Notification Setting Value
   * \retval t_Bool
   **************************************************************************/
   virtual t_Bool bGetMLNotiSettingVal() const = 0;

   /***************************************************************************
   ** FUNCTION:  tenEnabledInfo spi_tclDefaultSettingsIntf::enGetMLLinkEnableSetVal()
   ***************************************************************************/
   /*!
   * \fn     tenEnabledInfo enGetMLLinkEnableSetVal()
   * \brief  To get the default ML Link Enable Setting Value
   * \retval tenEnabledInfo
   **************************************************************************/
   virtual tenEnabledInfo enGetMLLinkEnableSetVal() const = 0;

   /***************************************************************************
   ** FUNCTION:  tenEnabledInfo spi_tclDefaultSettingsIntf::enGetDipoEnableSetVal()
   ***************************************************************************/
   /*!
   * \fn     tenEnabledInfo enGetDipoEnableSetVal()
   * \brief  To get the default Dipo Enable Setting Value
   * \retval tenEnabledInfo
   **************************************************************************/
   virtual tenEnabledInfo enGetDipoEnableSetVal() const = 0;

   /***************************************************************************
   ** FUNCTION:  tenEnabledInfo spi_tclDefaultSettingsIntf::enGetAAPEnableSetVal()
   ***************************************************************************/
   /*!
   * \fn     tenEnabledInfo enGetAAPEnableSetVal()
   * \brief  To get the default AAP Enable Setting Value
   * \retval tenEnabledInfo
   **************************************************************************/
   virtual tenEnabledInfo enGetAAPEnableSetVal() const = 0;

   /***************************************************************************
   ** FUNCTION:  tenEnabledInfo spi_tclDefaultSettingsIntf::enGetCarlifeEnableSetVal()
   ***************************************************************************/
   /*!
   * \fn     tenEnabledInfo enGetCarlifeEnableSetVal()
   * \brief  To get the default Carlife Enable Setting Value
   * \retval tenEnabledInfo
   **************************************************************************/
   virtual tenEnabledInfo enGetCarlifeEnableSetVal() const = 0;
   
   /***************************************************************************
   ** FUNCTION:  tenEnabledInfo spi_tclDefaultSettings::enGetMySPINEnableSetVal()
   ***************************************************************************/
   /*!
   * \fn     tenEnabledInfo enGetMySPINEnableSetVal()
   * \brief  To get the default myspin Enable Setting Value
   * \retval tenEnabledInfo
   **************************************************************************/
   virtual tenEnabledInfo enGetMySPINEnableSetVal() const = 0;

   /***************************************************************************
   ** FUNCTION:  tenDriveSideInfo  spi_tclDefaultSettingsIntf::enGetSteeringWheelPos()
   ***************************************************************************/
   /*!
   * \fn     tenDriveSideInfo  enGetSteeringWheelPos()
   * \brief  To get the default Steering Wheel Position
   * \retval tenDriveSideInfo
   **************************************************************************/
   virtual tenDriveSideInfo enGetSteeringWheelPos() const = 0;

   /***************************************************************************
   ** FUNCTION:  tenDeviceSelectionMode spi_tclDefaultSettingsIntf::enGetSelectMode()
   ***************************************************************************/
   /*!
   * \fn     tenDriveSideInfo  enGetSelectMode()
   * \brief  To get the default Selection Mode
   * \retval tenDeviceSelectionMode
   **************************************************************************/
   virtual tenDeviceSelectionMode enGetSelectMode() const = 0;

   /***************************************************************************
   ** FUNCTION:  tenEnabledInfo spi_tclDefaultSettingsIntf::enGetOnCarEnableSetVal()
   ***************************************************************************/
   /*!
   * \fn     tenEnabledInfo enGetOnCarEnableSetVal()
   * \brief  To get the default OnCar Enable Setting Value
   * \retval tenEnabledInfo
   **************************************************************************/
   virtual tenEnabledInfo enGetOnCarEnableSetVal() const = 0;

   /***************************************************************************
   ** FUNCTION:  tenDeviceCategory spi_tclDefaultSettingsIntf::enGetAndroidDeviceTechnologyPreference()
   ***************************************************************************/
   /*!
   * \fn     tenDeviceCategory  enGetAndroidDeviceTechnologyPreference()
   * \brief  To get the default Technology Preference for Android Devices
   * \retval tenDeviceCategory
   **************************************************************************/
   virtual tenDeviceCategory enGetAndroidDeviceTechnologyPreference() const = 0;

   /***************************************************************************
   ** FUNCTION:  tenDeviceCategory spi_tclDefaultSettingsIntf::enGetAppleDeviceTechnologyPreference()
   ***************************************************************************/
   /*!
   * \fn     tenDeviceCategory  enGetAppleDeviceTechnologyPreference()
   * \brief  To get the default Technology Preference for Apple Devices
   * \retval tenDeviceCategory
   **************************************************************************/
   virtual tenDeviceCategory enGetAppleDeviceTechnologyPreference() const = 0;


   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclDefaultSettingsIntf::vSetMLNotiSettingVal()
   ***************************************************************************/
   /*!
   * \fn      vSetMLNotiSettingVal(t_Bool bMLNotiSettingVal)
   * \brief   Called to set the default value to notification setting.
   * \param   [IN] bMLNotiSettingVal: default value for notification setting
   * \retval  None
   **************************************************************************/
   virtual t_Void vSetMLNotiSettingVal(t_Bool bMLNotiSettingVal) = 0;

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclDefaultSettingsIntf::vSetSteeringWheelPos()
   ***************************************************************************/
   /*!
   * \fn      vSetSteeringWheelPos(tenDriveSideInfo enSteeringWheelPos)
   * \brief   Called to set the default value to steering wheel position.
   * \param   [IN] enSteeringWheelPos: default value for steering wheel position
   * \retval  None
   **************************************************************************/
   virtual t_Void vSetSteeringWheelPos(tenDriveSideInfo enSteeringWheelPos) = 0;

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclDefaultSettingsIntf::vSetSelectMode()
   ***************************************************************************/
   /*!
   * \fn      vSetSelectMode(tenDeviceSelectionMode enSelectMode)
   * \brief   Called to set the default value to selection mode.
   * \param   [IN] enSelectMode: default value for selection mode
   * \retval  None
   **************************************************************************/
   virtual t_Void vSetSelectMode(tenDeviceSelectionMode enSelectMode) = 0;

   /***************************************************************************
   ** FUNCTION:  t_U8 spi_tclDefaultSettingsIntf::u8ReadVirginStartSetting()
   ***************************************************************************/
   /*!
   * \fn      u8ReadVirginStartSetting( )
   * \brief   Called to read VirginStartSetting.
   * \param   None
   * \retval  t_U8
   **************************************************************************/
   virtual t_U8 u8ReadVirginStartSetting() = 0;

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclDefaultSettingsIntf::vWriteVirginStartSetting()
   ***************************************************************************/
   /*!
   * \fn      vWriteVirginStartSetting( )
   * \brief   Called to write VirginStartSetting to datapool.
   * \param   None
   * \retval  t_Void
   **************************************************************************/
   virtual t_Void vWriteVirginStartSetting(t_U8 u8DefaultVgStrt) = 0;

   /***************************************************************************
   ****************************END OF PUBLIC *********************************
   ***************************************************************************/
};
#endif //SPI_TCLDEFAULTSETTINGSINTF_
