/***********************************************************************/
/*!
* \file  spi_tclDataServiceSettingsIntf.h
* \brief  Implementation of the Class spi_tclDataServiceSettingsIntf
*************************************************************************
\verbatim


PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Interface class for Data service Settings
AUTHOR:         kmo6kor
COPYRIGHT:      &copy; 2017 Robert Bosch Car Multimedia GmbH
HISTORY:
Date        | Author                | Modification
 07.06.2018   kmo6kor			       Initial Version
\endverbatim
*************************************************************************/


/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/
/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/
#ifndef SPI_TCLDATASERVICESETTINGSINTF_
#define SPI_TCLDATASERVICESETTINGSINTF_

#include "spi_tclCommonSettingsIntf.h"

class spi_tclDataServiceSettingsIntf : public virtual spi_tclCommonSettingsIntf
{

public:

   /***************************************************************************
   ****************************PUBLIC *********************************
   ***************************************************************************/

   /***************************************************************************
	** FUNCTION: spi_tclDataServiceSettingsIntf::spi_tclDataServiceSettingsIntf()
	***************************************************************************/
   /*!
	* \fn      spi_tclDataServiceSettingsIntf()
	* \brief   Constructor
	* \param   None
	**************************************************************************/
   spi_tclDataServiceSettingsIntf(){}

   /***************************************************************************
	** FUNCTION: spi_tclDataServiceSettingsIntf::~spi_tclDataServiceSettingsIntf()
	***************************************************************************/
   /*!
	* \fn      ~spi_tclDataServiceSettingsIntf()
	* \brief   Destructor
	* \param   None
	**************************************************************************/
   virtual ~spi_tclDataServiceSettingsIntf(){}

   /***************************************************************************
   ** FUNCTION:  t_Bool spi_tclDataServiceSettingsIntf::bGetCdbGPSSeviceEnabled()
   ***************************************************************************/
   /*!
   * \fn     t_Bool bGetCdbGPSSeviceEnabled()
   * \brief  Interface to read whether GPS CDB service is enabled
   * \retval t_Bool
   **************************************************************************/
   virtual t_Bool bGetCdbGPSSeviceEnabled() const = 0;

   /***************************************************************************
   ** FUNCTION:  t_Bool spi_tclDataServiceSettingsIntf::bGetCdbLocationSeviceEnabled()
   ***************************************************************************/
   /*!
   * \fn     bGetCdbLocationSeviceEnabled()
   * \brief  Interface to read whether Location CDB service is enabled
   * \retval t_Bool
   **************************************************************************/
   virtual t_Bool bGetCdbLocationSeviceEnabled() const = 0;

   /***************************************************************************
   ** FUNCTION:  t_Bool spi_tclDataServiceSettingsIntf::bGetCdbPrivateSeviceEnabled()
   ***************************************************************************/
   /*!
   * \fn     bGetCdbPrivateSeviceEnabled()
   * \brief  Interface to read whether Private CDB service is enabled
   * \retval t_Bool
   **************************************************************************/
   virtual t_Bool bGetCdbPrivateSeviceEnabled() const = 0;

   /***************************************************************************
   ** FUNCTION:  t_Bool spi_tclDataServiceSettingsIntf::bGetCdbMediaMetadataSinkEnabled()
   ***************************************************************************/
   /*!
   * \fn     bGetCdbMediaMetadataSinkEnabled()
   * \brief  Interface to read whether CDB Sink Media Metadata sink is enabled
   * \retval t_Bool
   **************************************************************************/
   virtual t_Bool bGetCdbMediaMetadataSinkEnabled() const = 0;

   /***************************************************************************
   ** FUNCTION:  t_Bool spi_tclDataServiceSettingsIntf::bGetCdbMediaMetadataSeviceEnabled()
   ***************************************************************************/
   /*!
   * \fn     bGetCdbNaviMetadataSinkEnabled()
   * \brief  Interface to read whether CDB Navigation Metadata sink is enabled
   * \retval t_Bool
   **************************************************************************/
   virtual t_Bool bGetCdbNaviMetadataSinkEnabled() const = 0;

   /***************************************************************************
   ** FUNCTION:  t_Bool spi_tclDataServiceSettingsIntf::bGetEnvDataSubEnabled()
   ***************************************************************************/
   /*!
   * \fn     t_Bool bGetEnvDataSubEnabled() const
   * \brief  Interface to get whether to subscribe for Environment data or not
   * \retval t_Bool
   **************************************************************************/
   virtual t_Bool bGetEnvDataSubEnabled() const = 0;

   /***************************************************************************
     ** FUNCTION:  t_Bool spi_tclDataServiceSettingsIntf::bGetGearStatusEnabled()
   ***************************************************************************/
   /*!
   * \fn     t_Bool bGetGearStatusEnabled() const
   * \brief  Interface to get whether to subscribe for Gear Status data or not
   * \retval t_Bool
   **************************************************************************/
   virtual t_Bool bGetGearStatusEnabled() const = 0;

   /***************************************************************************
     ** FUNCTION:  t_Bool spi_tclDataServiceSettingsIntf::bGetAccelerometerDataEnabled()
   ***************************************************************************/
   /*!
   * \fn     t_Bool bGetAccelerometerDataDisable() const
   * \brief  Interface to get whether to subscribe for Accelerometer data or not
   * \retval t_Bool
   **************************************************************************/
   virtual t_Bool bGetAccelerometerDataEnabled() const = 0;

   /***************************************************************************
   ** FUNCTION:  t_Bool spi_tclDataServiceSettingsIntf::bGetGyroDataEnabled()
   ***************************************************************************/
   /*!
   * \fn     t_Bool bGetGyroDataEnabled() const
   * \brief  Interface to get whether to subscribe for Gyroscope data or not
   * \retval t_Bool
   **************************************************************************/
   virtual t_Bool bGetGyroDataEnabled() const = 0;

   /***************************************************************************
   ** FUNCTION:  t_Bool spi_tclDataServiceSettingsIntf::bGetParkBrakeDataEnabled()
   ***************************************************************************/
   /*!
   * \fn     t_Bool bGetParkBrakeDataEnabled() const
   * \brief  Interface to get whether to subscribe for park brake data or not
   * \retval t_Bool
   **************************************************************************/
   virtual t_Bool bGetParkBrakeDataEnabled() const = 0;

   /***************************************************************************
   ** FUNCTION:  t_Bool spi_tclDataServiceSettingsIntf::bIsBochNavigation()
   ***************************************************************************/
   /*!
   * \fn     t_Bool bIsBochNavigation() const
   * \brief  Interface to get the type of navigation used.
   * \retval t_Bool
   **************************************************************************/
   virtual t_Bool bIsBochNavigation() const = 0;

   /***************************************************************************
   ** FUNCTION:  t_U32 spi_tclDataServiceSettingsIntf:: u32GetSpeedTimerInterval()
   ***************************************************************************/
   /*!
   * \fn     t_U32 u32GetSpeedTimerInterval() const
   * \brief  Interface to get the Speed timer interval in ms.
   * \retval t_U32
   **************************************************************************/
   virtual t_U32 u32GetSpeedTimerInterval()const = 0;

   /***************************************************************************
   ** FUNCTION:  t_Bool spi_tclDataServiceSettingsIntf::bGetLocDataEnabled()
   ***************************************************************************/
   /*!
   * \fn     t_Bool bGetLocDataEnabled() const
   * \brief  Interface to get location data enabled setting
   * \retval t_Bool
   **************************************************************************/
   virtual t_Bool bGetLocDataEnabled() const = 0;

   /***************************************************************************
   ** FUNCTION: tenGeoCoordinateSystemType spi_tclDataServiceSettingsIntf::enGetGeoCoordinateSystem()
   ***************************************************************************/
   /*!
   * \fn      enGetGeoCoordinateSystem()
   * \brief   Method to read the supported coordinate system
   * \retval  tenGeoCoordinateSystemType : To indicate type of Geo Coordinate System
   **************************************************************************/
   virtual tenGeoCoordinateSystemType enGetGeoCoordinateSystem() const = 0;

   /***************************************************************************
   ** FUNCTION:  tenATBoxSupportedState spi_tclDataServiceSettingsIntf::vGetATBoxSupportedState()
   ***************************************************************************/
   /*!
   * \fn      tenATBoxSupportedState vGetATBoxSupportedState()
   * \brief   Method to read supported AT Box features info.
   * \param   NONE
   * \retval  tenATBoxSupportedState
   **************************************************************************/
   virtual tenATBoxSupportedState vGetATBoxSupportedState() const = 0;

   /***************************************************************************
   ** FUNCTION:  t_Bool spi_tclDataServiceSettingsIntf::bGetCarlifeGPSDataSupportflag()
   ***************************************************************************/
   /*!
   * \fn     t_Bool bGetCarlifeGPSDataSupportflag() const
   * \brief  Interface to get location data enabled setting for carlfie
   * \retval t_Bool
   **************************************************************************/
   virtual t_Bool bGetCarlifeGPSDataSupportflag() const = 0;

   /***************************************************************************
   ** FUNCTION:  t_Bool spi_tclDataServiceSettingsIntf::bGetCarPlayGPSDataSupportflag()
   ***************************************************************************/
   /*!
   * \fn     t_Bool bGetCarPlayGPSDataSupportflag()
   * \brief  Interface to get GPS data enabled setting
   * \retval t_Bool
   **************************************************************************/
   virtual t_Bool bGetCarPlayGPSDataSupportflag() = 0;

   /***************************************************************************
   ****************************END OF PUBLIC *********************************
   ***************************************************************************/

};
#endif //SPI_TCLDATASERVICESETTINGSINTF_
