/***********************************************************************/
/*!
* \file  spi_tclConnSettingsIntf.h
* \brief  Implementation of the Class spi_tclConnSettingsIntf
*************************************************************************
\verbatim


PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Interface class for Connection Settings
AUTHOR:         kmo6kor
COPYRIGHT:      &copy; 2017 Robert Bosch Car Multimedia GmbH
HISTORY:
Date        | Author                | Modification
07.06.2018    kmo6kor			       Initial Version
\endverbatim
*************************************************************************/


/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/
/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/
#ifndef SPI_TCLCONNSETTINGSINTF_
#define SPI_TCLCONNSETTINGSINTF_

#include "spi_tclCommonSettingsIntf.h"
#include "spi_ConnMngrTypeDefines.h"

class spi_tclConnSettingsIntf : public virtual spi_tclCommonSettingsIntf
{

public:

   /***************************************************************************
   ****************************PUBLIC *********************************
   ***************************************************************************/

	/***************************************************************************
	 ** FUNCTION:  spi_tclConnSettingsIntf::spi_tclConnSettingsIntf()
	 ***************************************************************************/
	/*!
	 * \fn     spi_tclConnSettingsIntf()
	 * \brief  Default Constructor
	 **************************************************************************/
    spi_tclConnSettingsIntf(){}

	/***************************************************************************
	 ** FUNCTION:  spi_tclConnSettingsIntf::~spi_tclConnSettingsIntf()
	 ***************************************************************************/
	/*!
	 * \fn     ~spi_tclConnSettingsIntf()
	 * \brief  Destructor
	 * \param  none
	 **************************************************************************/
   virtual ~spi_tclConnSettingsIntf(){}

   /***************************************************************************
    ** FUNCTION:  spi_tclConnSettingsIntf::enGetDeviceSelectionMode
    ***************************************************************************/
   /*!
    * \fn     tenDeviceSelectionMode enGetDeviceSelectionMode()
    * \brief  returns Device Selection Mode
    **************************************************************************/
   virtual tenDeviceSelectionMode enGetDeviceSelectionMode(tenDeviceCategory enTechnologyType) const = 0;

   /***************************************************************************
    ** FUNCTION:  tenEnabledInfo spi_tclConnSettingsIntf::enGetCertificateType
    ***************************************************************************/
   /*!
    * \fn     tenEnabledInfo enGetCertificateType()
    * \brief  returns Certificate type
    **************************************************************************/
   virtual tenCertificateType enGetCertificateType() const = 0;

   /***************************************************************************
    ** FUNCTION:  tenSelModePriority spi_tclConnSettingsIntf::enGetSelectionModePriority
    ***************************************************************************/
   /*!
    * \fn     tenSelModePriority enGetSelectionModePriority()
    * \brief  returns Priority of selection mode
    **************************************************************************/
   virtual tenSelModePriority enGetSelectionModePriority() const = 0;

   /***************************************************************************
    ** FUNCTION:  t_Void spi_tclConnSettingsIntf::vGetPersistentStoragePath
    ***************************************************************************/
   /*!
    * \fn     t_Void vGetPersistentStoragePath()
    * \brief  returns path for persistent Storage
    **************************************************************************/
   virtual t_Void vGetPersistentStoragePath(t_String &rfszPersStoragePath) = 0;

   /***************************************************************************
    ** FUNCTION:  t_U32 spi_tclConnSettingsIntf::u32GetDeviceHistorySize
    ***************************************************************************/
   /*!
    * \fn     t_U32 u32GetDeviceHistorySize()
    * \brief  returns the Maximum size of Device History Database
    **************************************************************************/
   virtual t_U32 u32GetDeviceHistorySize() const = 0;

   /***************************************************************************
    ** FUNCTION:  t_Bool spi_tclConnSettingsIntf::vGetMySPINAoapAppInfo
    ***************************************************************************/
   /*!
    * \fn     t_Bool vGetMySPINAoapAppInfo(trMySPINAoapAppInfo& rfrMySPINAoapAppInfo)
    * \brief  Method to retrieve head unit information
    * \param  rfrMySPINAoapAppInfo:[IN]Aoap application information
    * \retval t_Bool
    **************************************************************************/
   virtual t_Void vGetMySPINAoapAppInfo(trMySPINAoapAppInfo& rfrMySPINAoapAppInfo) = 0;

   /***************************************************************************
    ** FUNCTION:  t_U16 spi_tclConnSettingsIntf::u16GetGeneralRestrictionsInfo
    ***************************************************************************/
   /*!
    * \fn     t_U16 u16GetGeneralRestrictionsInfo(t_String &rfszDeviceExclusionListPath)
    * \brief  Method to get General restriction info according to the dev category
    * \param  enDeviceCategory : Device category
    * \retval t_Void
    **************************************************************************/
   virtual t_U16 u16GetGeneralRestrictionsInfo(tenDeviceCategory enDeviceCategory) const = 0;

   /***************************************************************************
    ** FUNCTION:   t_String spi_tclConnSettingsIntf::szGetChannelID()
    ***************************************************************************/
   /*!
    * \fn     t_String szGetChannelID()
    * \brief   Method to get channel ID
    * \retval  szChannelID : Unique Channel ID for Baidu Carlife technology.
    **************************************************************************/
   virtual t_String szGetChannelID() const = 0;

   /***************************************************************************
   ** FUNCTION:  tenEnabledInfo spi_tclConnSettingsIntf::enReadDipoEnableSettingVal()
   ***************************************************************************/
   /*!
   * \fn      enReadDipoEnableSettingVal
   * \brief   Provides DiPO On/Off setting value stored in Datapool.
   * \param   None
   * \retval  tenEnabledInfo:
   *               e8USAGE_DISABLED - to set value as OFF
   *               e8USAGE_ENABLED - to set value as ON
   ***************************************************************************/
   virtual tenEnabledInfo enReadDipoEnableSettingVal() const = 0;

   /***************************************************************************
   ** FUNCTION:  tenEnabledInfo spi_tclConnSettingsIntf::enReadMLEnableSettingVal()
   ***************************************************************************/
   /*!
   * \fn      enReadMLEnableSettingVal
   * \brief   Provides MirrorLink On/Off setting value stored in Datapool.
   * \param   None
   * \retval  tenEnabledInfo:
   *               e8USAGE_DISABLED - to set value as OFF
   *               e8USAGE_ENABLED - to set value as ON
   ***************************************************************************/
   virtual tenEnabledInfo enReadMLEnableSettingVal() const = 0;

   /***************************************************************************
   ** FUNCTION:  tenEnabledInfo spi_tclConnSettingsIntf::enReadAAPEnableSettingVal()
   ***************************************************************************/
   /*!
   * \fn      enReadAAPEnableSettingVal
   * \brief   Provides AAP On/Off setting value stored in Datapool.
   * \param   None
   * \retval  tenEnabledInfo:
   *               e8USAGE_DISABLED - to set value as OFF
   *               e8USAGE_ENABLED - to set value as ON
   ***************************************************************************/
   virtual tenEnabledInfo enReadAAPEnableSettingVal() const = 0;

   /***************************************************************************
   ** FUNCTION:  tenEnabledInfo spi_tclConnSettingsIntf::enReadmySPINEnableSettingVal()
   ***************************************************************************/
   /*!
   * \fn      enReadmySPINEnableSettingVal
   * \brief   Provides mySPIN On/Off setting value stored in Datapool.
   * \param   None
   * \retval  tenEnabledInfo:
   *               e8USAGE_DISABLED - to set value as OFF
   *               e8USAGE_ENABLED - to set value as ON
   ***************************************************************************/
   virtual tenEnabledInfo enReadmySPINEnableSettingVal() const = 0;

   /***************************************************************************
   ** FUNCTION:  tenEnabledInfo spi_tclConnSettingsIntf::enReadCarlifeEnableSettingVal()
   ***************************************************************************/
   /*!
   * \fn      enReadCarlifeEnableSettingVal
   * \brief   Provides Carlife On/Off setting value stored in Datapool.
   * \param   None
   * \retval  tenEnabledInfo:
   *               e8USAGE_DISABLED - to set value as OFF
   *               e8USAGE_ENABLED - to set value as ON
   ***************************************************************************/
   virtual tenEnabledInfo enReadCarlifeEnableSettingVal() const = 0;

   /***************************************************************************
    ** FUNCTION:  t_Bool spi_tclConnSettingsIntf::bReadAndroidDeviceTechnologyPreferenceVal()
    ***************************************************************************/
   /*!
    * \fn      bReadAndroidDeviceTechnologyPreferenceVal()
    * \brief   Function to read Android Device the TechnologyPreference
    * \retval  t_Bool
    ***************************************************************************/
   virtual t_Bool bReadAndroidDeviceTechnologyPreferenceVal(tenDeviceCategory &enTechnologyPreference) = 0;

   /***************************************************************************
    ** FUNCTION:  t_Bool spi_tclConnSettingsIntf::bReadAppleDeviceTechnologyPreferenceVal()
    ***************************************************************************/
   /*!
    * \fn      bReadAppleDeviceTechnologyPreferenceVal()
    * \brief   Function to read Apple Device the TechnologyPreference
    * \retval  t_Bool
    ***************************************************************************/
   virtual t_Bool bReadAppleDeviceTechnologyPreferenceVal(tenDeviceCategory &enTechnologyPreference) = 0;

   /***************************************************************************
   ** FUNCTION:  tenEnabledInfo spi_tclConnSettingsIntf::enReadOnCarEnableSetting()
   ***************************************************************************/
   /*!
   * \fn      enReadOnCarEnableSetting
   * \brief   Provides OnCar On/Off setting value stored in Datapool.
   * \param   None
   * \retval  tenEnabledInfo:
   *               e8USAGE_DISABLED - to set value as OFF
   *               e8USAGE_ENABLED - to set value as ON
   ***************************************************************************/
   virtual tenEnabledInfo enReadOnCarEnableSetting() const = 0 ;

   /***************************************************************************
   ** FUNCTION: t_Bool spi_tclConnSettingsIntf::bGetSysVehicleInfo())
   ***************************************************************************/
   /*!
   * \fn      t_Bool bGetSysVehicleInfo()
   * \brief   Function to Get Region, Vendor and Vehicle
   * \retval  t_Bool
   **************************************************************************/
   virtual t_Bool bGetSysVehicleInfo(t_U8 &u8RegionCode, t_U8 &u8VendorCode, t_U16 &u16VehicleCode) = 0;

   /***************************************************************************
   ****************************END OF PUBLIC *********************************
   ***************************************************************************/

};
#endif //SPI_TCLCONNSETTINGSINTF_
