/***********************************************************************/
/*!
* \file  spi_tclAppSettingsIntf.h
* \brief  Implementation of the Class spi_tclAppSettingsIntf
*************************************************************************
\verbatim


PROJECT:        Gen3
SW-COMPONENT:   Smart Phone Integration
DESCRIPTION:    Interface class for App Manager Settings
AUTHOR:         kmo6kor
COPYRIGHT:      &copy; 2017 Robert Bosch Car Multimedia GmbH
HISTORY:
Date        | Author                | Modification
07.06.2018  | kmo6kor			      | Initial Version
\endverbatim
*************************************************************************/


/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/
/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/
#ifndef SPI_TCLAPPSETTINGSINTF_
#define SPI_TCLAPPSETTINGSINTF_

#include "spi_tclCommonSettingsIntf.h"

class spi_tclAppSettingsIntf : public virtual spi_tclCommonSettingsIntf
{

public:

   /***************************************************************************
   ****************************PUBLIC *********************************
   ***************************************************************************/

   /***************************************************************************
	** FUNCTION: spi_tclAppSettingsIntf()
	***************************************************************************/
   /*!
	* \fn   spi_tclAppSettingsIntf(){}
	* \brief   Constructor of the class
	* \param   None
	**************************************************************************/
   spi_tclAppSettingsIntf(){}

   /***************************************************************************
	** FUNCTION: spi_tclAppSettingsIntf
	***************************************************************************/
   /*!
	* \fn     spi_tclAppSettingsIntf
	* \brief   Destructor of the class
	* \param   None
	**************************************************************************/
   virtual ~spi_tclAppSettingsIntf(){}

   /***************************************************************************
   ** FUNCTION:  t_Bool spi_tclAppSettingsIntf::bGetNonCertAppsReq()
   ***************************************************************************/
   /*!
   * \fn     t_Bool bGetNonCertAppsReq()
   * \brief  To get whether the Non certified Applications are required
   *          when the application certification is enabled for the
   *          particular version of the device.
   * \retval t_Bool
   **************************************************************************/
   virtual t_Bool bGetNonCertAppsReq() const = 0;

   /***************************************************************************
   ** FUNCTION: t_Bool spi_tclAppSettingsIntf::bGetAAPNavigationEnabledInfo()
   ***************************************************************************/
   /*!
   * \fn     t_Bool bIsAAPNavigationEnabled(t_Bool bEnable)
   * \brief  method to get the navigation feature enable settings for AAP.
   * \param  bEnable       : [IN] TRUE-allows to display navigation updates
   *                         for AAP
   *                         FALSE - doesn't allow
   * \retval t_Bool
   **************************************************************************/
   virtual t_Bool bGetAAPNavigationEnabledInfo() const = 0;

   /***************************************************************************
   ** FUNCTION: t_Bool spi_tclAppSettingsIntf::bGetAAPMediaPlaybackEnabledInfo()
   ***************************************************************************/
   /*!
   * \fn     t_Bool bIsAAPMediaPlaybackEnabled(t_Bool bEnable)
   * \brief  method to get the media playback feature enable settings for AAP.
   * \param  bEnable       : [IN] TRUE-allows to display media playback updates
   *                         for AAP
   *                         FALSE - doesn't allow
   * \retval t_Bool
   **************************************************************************/
   virtual t_Bool bGetAAPMediaPlaybackEnabledInfo() const = 0;

   /***************************************************************************
   ** FUNCTION: t_Bool spi_tclAppSettingsIntf::bGetAAPNotificationUpdatesEnabledInfo()
   ***************************************************************************/
   /*!
   * \fn     t_Bool bGetAAPNotificationUpdatesEnabledInfo(t_Bool bEnable)
   * \brief  method to get notification update enable settings for AAP.
   * \param  bEnable       : [IN] TRUE-allows to display notification updates
   *                         for AAP
   *                         FALSE - doesn't allow
   * \retval t_Bool
   **************************************************************************/
   virtual t_Bool bGetAAPNotificationUpdatesEnabledInfo() const = 0;

   /***************************************************************************
   ** FUNCTION: t_Bool spi_tclAppSettingsIntf::bGetTBTUpdatesEnabledInfo()
   ***************************************************************************/
   /*!
   * \fn     t_Bool bGetTBTUpdatesEnabledInfo()
   * \brief  Provides information on whether TBT updates are enabled or disabled.
   * \retval t_Bool TRUE- Enabled FALSE-Disabled
   **************************************************************************/
   virtual t_Bool bGetTBTUpdatesEnabledInfo() const = 0;

   /***************************************************************************
   ** FUNCTION: t_Bool spi_tclAppSettingsIntf::bGetAssisstantGuideUpdatesEnabledInfo()
   ***************************************************************************/
   /*!
   * \fn     t_Bool bGetAssisstantGuideUpdatesEnabledInfo()
   * \brief  Provides information on whether Assisstant Guide updates are enabled
   *         or disabled.
   * \retval t_Bool TRUE- Enabled FALSE-Disabled
   **************************************************************************/
   virtual t_Bool bGetAssisstantGuideUpdatesEnabledInfo() const = 0;

   /***************************************************************************
   ** FUNCTION:  t_String spi_tclAppSettingsIntf::szGetRegion()
   ***************************************************************************/
   /*!
   * \fn     t_String szGetRegion()
   * \brief  To Get the which regions CCC guidelines should be followed for the
   *          Application certification.
   * \retval t_String
   **************************************************************************/
   virtual t_String szGetRegion() const = 0;

   /***************************************************************************
   ** FUNCTION: t_Bool spi_tclAppSettingsIntf::bGetNonCertAppAllowedInfo()
   ***************************************************************************/
   /*!
   * \fn     t_Bool bGetNonCertAppAllowedInfo()
   * \brief  Provides information on whether non certified ML apps are allowed
   *         in all modes(drive/park)
   * \retval t_Bool TRUE- Allowed FALSE-Not allowed
   **************************************************************************/
   virtual t_Bool bGetNonCertAppAllowedInfo() const = 0;

   /***************************************************************************
   ** FUNCTION: t_Bool spi_tclAppSettingsIntf::bEnableCTSTest()
   ***************************************************************************/
   /*!
   * \fn     t_Bool bEnableCTSTest()
   * \brief  To get whether the CTS test is enabled.
   * \retval t_Bool  TRUE- Enabled FALSE-Disabled
   **************************************************************************/
   virtual t_Bool bEnableCTSTest() = 0;

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclAppSettingsIntf::vSetDriveModeInfo()
   ***************************************************************************/
   /*!
   * \fn      t_Void vSetDriveModeInfo()
   * \brief   Method set the drive mode information
   * \param   enDriveModeInfo : [IN] Drive mode info.
   * \retval  t_Void
   **************************************************************************/
   virtual t_Void vSetDriveModeInfo(const tenVehicleConfiguration enDriveModeInfo) = 0;

   /***************************************************************************
   ** FUNCTION:  t_String spi_tclAppSettingsIntf::szGetClientManufacturerName()
   ***************************************************************************/
   /*!
   * \fn      t_String szGetClientManufacturerName()
   * \brief   Method to get the client manufacturer name.
   * \param   NONE
   * \retval  t_String
   **************************************************************************/
   virtual t_String szGetClientManufacturerName() const = 0;

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclAppSettingsIntf::vSetNightModeInfo()
   ***************************************************************************/
   /*!
   * \fn      t_Void vSetNightModeInfo()
   * \brief   Method set the night  mode information
   * \param   enNightModeInfo : [IN] Night mode info
   * \retval  t_Void
   **************************************************************************/
   virtual t_Void vSetNightModeInfo(const tenVehicleConfiguration enNightModeInfo) = 0;

   /***************************************************************************
    ** FUNCTION:  t_Void spi_tclAppSettingsIntf::szGetVehicleModelNumber()
    ***************************************************************************/
   /*!
    * \fn      szGetVehicleModelNumber()
    * \brief   Method to get Vehicle Model Number information
    * \retval  t_Void
    **************************************************************************/
   virtual t_Void szGetVehicleModelNumber(t_String& szVehicleModelNumber) const = 0;

   /***************************************************************************
   ** FUNCTION:  t_String spi_tclAppSettingsIntf::szGetClientID()
   ***************************************************************************/
   /*!
   * \fn      t_String szGetClientID()
   * \brief   Method to get the client ID.
   * \param   NONE
   * \retval  t_String
   **************************************************************************/
   virtual t_String szGetClientID() const = 0;

   /***************************************************************************
   ** FUNCTION:  t_String spi_tclAppSettingsIntf::szGetClientFriendlyName()
   ***************************************************************************/
   /*!
   * \fn      t_String szGetClientFriendlyName()
   * \brief   Method to get the client friendly name.
   * \param   NONE
   * \retval  t_String
   **************************************************************************/
   virtual t_String szGetClientFriendlyName() const = 0;

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclAppSettingsIntf::vSetDriveSideInfo()
   ***************************************************************************/
   /*!
   * \fn      t_Void vSetDriveSideInfo()
   * \brief   Method to set the night mode info
   * \param   enVehicleConfig : [IN] Drive side info.
   * \retval  t_Void
   **************************************************************************/
   virtual t_Void vSetDriveSideInfo(const tenVehicleConfiguration enVehicleConfig) = 0;

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclAppSettingsIntf::vReadSysConfigs()
   ***************************************************************************/
   /*!
   * \fn      t_Void vReadSysConfigs()
   * \brief   Method to read & store the system configurations from KDS.
   * \param   NONE
   * \retval  t_Void
   **************************************************************************/
   virtual t_Void vReadSysConfigs() = 0;

   /***************************************************************************
   ** FUNCTION:  t_Void spi_tclAppSettingsIntf::vDisplayAppSettings()
   ***************************************************************************/
   /*!
   * \fn     t_Void vDisplayAppSettings()
   * \brief  To print the settings
   * \retval t_Void
   **************************************************************************/
   virtual t_Void vDisplayAppSettings() = 0;

   /***************************************************************************
   ****************************END OF PUBLIC *********************************
   ***************************************************************************/
};
#endif //SPI_TCLAPPSETTINGSINTF_
